/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.reseller;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.reseller.AbstractSplitHandler;
import biz.elabor.prebilling.services.reseller.GetMnoResellerStrategy;
import biz.elabor.prebilling.services.reseller.RecordMnoResellerStrategy;
import biz.elabor.prebilling.services.reseller.SetResellerStrategy;
import biz.elabor.prebilling.web.xml.Partition;
import java.util.List;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

class MnoSplitHandler
extends AbstractSplitHandler {
    public MnoSplitHandler(PrebillingConfiguration configuration, MisureDao misureDao, TalkManager talkManager) {
        super(configuration, misureDao, talkManager);
    }

    @Override
    public List<ElaborCalendar> getMonths() {
        return this.misureDao.getMnoMonths();
    }

    @Override
    public List<Partition> getPrefixes(ElaborCalendar month, String prefix, int prefixLength) {
        return this.misureDao.getMnoPrefixes(month, prefix, prefixLength);
    }

    @Override
    protected StrategiesManager buildStrategies(ElaborCalendar month, String prefix) {
        StrategiesManager manager = new StrategiesManager(this.configuration);
        manager.addStrategy(new GetMnoResellerStrategy(month, prefix, this.misureDao));
        manager.addStrategy(new SetResellerStrategy(this.configuration, this.talkManager));
        manager.addStrategy(new RecordMnoResellerStrategy(this.misureDao, this.talkManager));
        return manager;
    }
}

