/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.regime;

import biz.elabor.prebilling.common.BasicServiceStatus;
import biz.elabor.prebilling.common.FileCopyHelper;
import biz.elabor.prebilling.common.model.RegimeContratto;
import biz.elabor.prebilling.common.utils.AbstractRegimeService;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.ServiceStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.structures.listmap.ListMap;

public class RegimeEleStrategy
extends AbstractRegimeService
implements ServiceStrategy {
    private static final String FILE_HEADER = "InizioTrattamentoOrario";
    private final int ritardo;
    private final String target;
    private final GiadaDao giadaDao;
    private final PrebillingConfiguration configuration;

    public RegimeEleStrategy(int ritardo, String target, GiadaDao giadaDao, PrebillingConfiguration configuration) {
        super(FILE_HEADER);
        this.ritardo = ritardo;
        this.target = target;
        this.giadaDao = giadaDao;
        this.configuration = configuration;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        this.initRegime();
        Date date = this.configuration.getTimeout(this.ritardo);
        List<RegimeContratto> contratti = this.giadaDao.getContrattiNonRegime(date);
        this.handleContratti(contratti, status);
        boolean ok = this.exportRegime("-", this.target, status);
        return ok &= this.exportRegimeDispatcher(status);
    }

    private boolean exportRegimeDispatcher(BasicServiceStatus status) {
        boolean ok;
        try {
            if (!this.regime.isEmpty()) {
                String idEsecuzione = status.getIdEsecuzione();
                File folder = this.target.equalsIgnoreCase("file") ? ConfigurationHelper.getDispatcherTmpImportFolder(this.configuration, idEsecuzione, Funzionalita.REGIME) : ConfigurationHelper.getDispatcherCodaTmpFolder(this.configuration, idEsecuzione);
                String timestamp = this.getTimestamp();
                File file = new File(folder, "regime-" + timestamp + ".txt");
                Throwable throwable = null;
                Object var8_10 = null;
                try (PrintWriter writer = new PrintWriter(file);){
                    writer.println(FILE_HEADER);
                    for (Map.Entry entry : this.regime.entrySet()) {
                        ListMap regimeAzienda = (ListMap)entry.getValue();
                        this.printRegimeAzienda(regimeAzienda, writer);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            ok = true;
        }
        catch (FileNotFoundException exc) {
            Logger logger = status.getLogger();
            logger.log(Level.SEVERE, "exception", exc);
            ok = false;
        }
        return ok;
    }

    private void handleContratti(List<RegimeContratto> contratti, ServiceStatus status) {
        Logger logger = status.getLogger();
        int size = contratti.size();
        int batchSize = Math.max(1000, Math.min(10000, size / 10));
        int count = 0;
        for (RegimeContratto contratto : contratti) {
            this.handleContratto(contratto, status);
            if (count % batchSize == 0) {
                logger.info("elaborati " + count + " pod su " + size);
            }
            ++count;
        }
        logger.info("elaborati " + count + " pod su " + size);
    }

    void handleContratto(RegimeContratto contratto, ServiceStatus status) {
        Date dataFirstRegime = contratto.getDataFirstRegime();
        this.fillRegime(contratto, dataFirstRegime, status);
    }

    @Override
    protected File getFolder(String idEsecuzione, String azienda, String targetStr) {
        File folder = targetStr.equalsIgnoreCase("file") ? ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, Funzionalita.REGIME) : FileCopyHelper.getResellerCodaTmpFolder(this.configuration, idEsecuzione, azienda);
        return folder;
    }

    @Override
    protected Date getDataRegime(Date dataPrimaMisura, Date dataInizio) {
        Date dataRegime;
        Date dataOverflow = CalendarTools.previousDay(dataPrimaMisura);
        if (dataOverflow.after(dataInizio)) {
            Date dataInizioMese = RegimeEleStrategy.getDataInizioMese(dataPrimaMisura);
            dataRegime = CalendarTools.max(dataInizioMese, dataInizio);
        } else {
            dataRegime = CalendarTools.min(dataPrimaMisura, dataInizio);
        }
        return dataRegime;
    }
}

