/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture.statopod;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.MisuraPdo;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.PdoResult;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.common.statopod.AbstractStatoPodHandler;
import java.util.Arrays;
import java.util.List;
import org.homelinux.elabor.structures.listmap.SafeListMap;

public abstract class AbstractPdoStatoPodHandler<M extends MisuraPod>
extends AbstractStatoPodHandler<M> {
    private static final List<String> FLUSSI = Arrays.asList("PDO", "PDO2G");

    public AbstractPdoStatoPodHandler(String servizio, MisureDao misureDao) {
        super(servizio, misureDao);
    }

    public void addObsoleto(StatusTransaction transaction, MisuraPdo misuraPod, ErroriElaborazione errore, String messaggio) {
        Pdo pdo = misuraPod.getPdo();
        PdoResult result = new PdoResult(pdo, errore, messaggio);
        transaction.addPdoObsoleto(result);
    }

    public void check(SafeListMap<String, Prestazione> prestazioni, List<String> codiciPrestazione) throws SegnaleNotHandledException, PrestazioneNotFoundException {
        this.check(prestazioni, codiciPrestazione, FLUSSI);
    }
}

