/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.misure.InvalidFasciaValue;
import biz.elabor.prebilling.model.misure.MnoPod;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodCheckException;
import biz.elabor.prebilling.services.letture.AbstractPivChecker;
import biz.elabor.prebilling.services.letture.BaseAggregationStrategy;
import biz.elabor.prebilling.services.letture.ExportLetturePeriodoStrategy;
import biz.elabor.prebilling.services.letture.IncoherenceException;
import biz.elabor.prebilling.services.letture.MisuraNonZeroException;
import biz.elabor.prebilling.services.letture.PodNonorarioException;
import org.homelinux.elabor.db.DataNotFoundException;

public class PivNotExistsChecker
extends AbstractPivChecker {
    @Override
    public void handlePdo(Pdo pdo, StatusTransaction transaction, BaseAggregationStrategy baseStrategy) throws PodNonorarioException, DataNotFoundException, CalendarNotFoundException, IncoherenceException, StatoPodCheckException, PraticaAnnullataException, MisuraNonZeroException, InvalidFasciaValue {
        if (PivNotExistsChecker.checkPiv(pdo, transaction)) {
            baseStrategy.handlePdo(pdo, null, transaction);
        }
    }

    private static boolean checkPiv(Pdo pdo, StatusTransaction transaction) {
        boolean ok;
        try {
            String codicePod = pdo.getCodicePod();
            PraticaVolo pratica = PivNotExistsChecker.getVirtualPiv(codicePod, transaction);
            ok = pratica == null;
        }
        catch (DataNotFoundException exc) {
            ok = false;
        }
        return ok;
    }

    @Override
    public void write(MnoPod mnoPod, ServiceStatus status, ExportLetturePeriodoStrategy baseStrategy) throws CalendarNotFoundException {
        String codicePod = mnoPod.getKey();
        try {
            StrategyHelper.getPiv(codicePod, null, status);
        }
        catch (DataNotFoundException exc) {
            baseStrategy.write(mnoPod, status);
        }
    }

    @Override
    public String getId() {
        return "nopiv";
    }

    @Override
    public boolean isPiv() {
        return false;
    }

    @Override
    public boolean isCheckOutDate() {
        return true;
    }
}

