/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.config.CdConMag;
import biz.elabor.prebilling.config.Generazione;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.letture.MisuraHandler;
import java.util.Date;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class Pdo2GRMisuraHandler
implements MisuraHandler {
    private final PrebillingConfiguration configuration;
    private final TalkManager talkManager;

    public Pdo2GRMisuraHandler(PrebillingConfiguration configuration, TalkManager talkManager) {
        this.configuration = configuration;
        this.talkManager = talkManager;
    }

    @Override
    public void addElaborato(Pod pod, Mno mno, StatusTransaction transaction) {
        MnoResult result = this.buildResult(pod, mno);
        transaction.addPdo2GRElaborato(result);
    }

    @Override
    public void addObsoleto(MnoResult result, StatusTransaction transaction) {
        transaction.addPdo2GRObsoleto(result);
    }

    private MnoResult buildResult(Pod pod, Mno mno) {
        String descrizione;
        ErroriElaborazione errore;
        if (this.checkModello(mno, pod)) {
            errore = ErroriElaborazione.OK;
            descrizione = "";
        } else {
            errore = ErroriElaborazione.INCOHERENT_MODEL;
            descrizione = StrategyHelper.handleErrore(pod, errore, this.talkManager);
        }
        return new MnoResult(mno, errore, descrizione);
    }

    private boolean checkModello(Mno mno, Pod pod) {
        String codiceFlusso = mno.getCodiceFlusso();
        Date dataMisura = mno.getDataMisura();
        String cdConMagKey = pod.getCdConMag(dataMisura);
        CdConMag cdConMag = this.configuration.getCdConMag(cdConMagKey);
        Generazione generazione = cdConMag.getGenerazione();
        return generazione.checkCodiceFlusso(codiceFlusso);
    }

    @Override
    public void addSospeso(MnoResult result, StatusTransaction transaction) {
        transaction.addPdo2GRSospeso(result);
    }
}

