/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.config.CdConMag;
import biz.elabor.prebilling.config.Generazione;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.TipoLetStd;
import biz.elabor.prebilling.model.calendar.CalendarMap;
import biz.elabor.prebilling.model.calendar.CalendarioCommercialeHelper;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraCompleta;
import biz.elabor.prebilling.model.misure.MisuraContatorePdo;
import biz.elabor.prebilling.model.misure.MisuraPdo;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.MnoPod;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.prebilling.DispatchingFlussi;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.model.statopod.StatoPodHelper;
import biz.elabor.prebilling.model.statopod.StatoPodMisuraHandler;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.GestFile16Helper;
import biz.elabor.prebilling.services.common.MisuraAccumulator;
import biz.elabor.prebilling.services.common.PdoSwitchoutSPB;
import biz.elabor.prebilling.services.common.TipoPrestazione;
import biz.elabor.prebilling.services.common.statopod.AbstractStatoPodHandler;
import biz.elabor.prebilling.services.common.statopod.NullReferenceHandler;
import biz.elabor.prebilling.services.common.statopod.PdoTH;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodCheckException;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.letture.CurrentMisuraHandler;
import biz.elabor.prebilling.services.letture.ErrorePdo;
import biz.elabor.prebilling.services.letture.IncoherenceException;
import biz.elabor.prebilling.services.letture.MisuraNonZeroException;
import biz.elabor.prebilling.services.letture.MisuraVoltura;
import biz.elabor.prebilling.services.letture.MisureOrarieEnvironment;
import biz.elabor.prebilling.services.letture.RiferimentoMisuraHandler;
import biz.elabor.prebilling.services.letture.SE1Handler;
import biz.elabor.prebilling.services.letture.VT1Handler;
import biz.elabor.prebilling.services.letture.VolturaDefferedStatoPod;
import biz.elabor.prebilling.services.letture.statopod.MontaggioStatoPodHandler;
import biz.elabor.prebilling.services.letture.statopod.PdoVoltureStatoPodHandler;
import biz.elabor.prebilling.services.letture.statopod.SmontaggioStatoPodHandler;
import biz.elabor.prebilling.services.switched.PdoSnfStatoPodHandler;
import biz.elabor.prebilling.services.volture.ExtMno;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.safe.SafeMap;

public class MisureOrarieService {
    private static final StatoPodMisuraHandler CURRENT_MISURA_HANDLER = new CurrentMisuraHandler();
    private static final StatoPodMisuraHandler RIFERIMENTO_MISURA_HANDLER = new RiferimentoMisuraHandler();
    private final PdoVoltureStatoPodHandler pdoVoltureSPH;
    private final PrebillingConfiguration configuration;
    private final Set<String> codiciPodRiconfigurati;
    private final MisureDao misureDao;
    private final Set<String> switchouts;

    public MisureOrarieService(PdoVoltureStatoPodHandler pdoVoltureStatoPodHandler, PrebillingConfiguration configuration, MisureDao misureDao) {
        this.pdoVoltureSPH = pdoVoltureStatoPodHandler;
        this.configuration = configuration;
        this.codiciPodRiconfigurati = new HashSet<String>();
        this.misureDao = misureDao;
        this.switchouts = new HashSet<String>();
    }

    public Set<ErrorePdo> generateMisure(boolean crm, Reseller reseller, Pod pod, Pdo pdo, StatusTransaction transaction, List<SpecificaTecnica> specifiche, MisureOrarieEnvironment environment) throws DataNotFoundException, CalendarNotFoundException, IncoherenceException, StatoPodCheckException, PraticaAnnullataException, MisuraNonZeroException {
        HashSet<ErrorePdo> errori = new HashSet<ErrorePdo>();
        String codicePod = pod.getCodice();
        boolean stimata = pdo.isStimata();
        RilMese rilMese = pdo.getRilMese();
        int anno = rilMese.getAnno();
        Month mese = rilMese.getMese();
        CalendarMap calendarMap = transaction.getCalendarMap();
        MisuraAccumulator accumulator = new MisuraAccumulator(rilMese, calendarMap, this.configuration);
        ArrayList<MisuraPdo> misureDates = new ArrayList<MisuraPdo>();
        SpecificaTecnica specificaVoltura = environment.getSpecificaVoltura();
        Date dataVoltura = specificaVoltura.getData();
        for (SpecificaTecnica specifica : specifiche) {
            Date date = specifica.getData();
            String codiceOfferta = specifica.getCodiceOfferta();
            accumulator.setOfferta(codiceOfferta, codicePod, transaction);
            if (date.equals(dataVoltura)) continue;
            boolean overflow = pod.isLastAzzeramento(date);
            this.handleDate(anno, mese, pod, pdo, stimata, accumulator, date, misureDates, overflow, environment);
        }
        ArrayList<MisuraPdo> misureVoltura = new ArrayList<MisuraPdo>();
        if (dataVoltura != null) {
            String codiceOfferta = specificaVoltura.getCodiceOfferta();
            accumulator.setOfferta(codiceOfferta, codicePod, transaction);
            this.handleDate(anno, mese, pod, pdo, stimata, accumulator, dataVoltura, misureVoltura, false, environment);
        }
        ArrayList<MisuraPdo> misureFine = new ArrayList<MisuraPdo>();
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        calendar.addMesi(1);
        calendar.addGiorni(-1);
        Date endDate = calendar.getDate();
        Date dataOut = pod.getSwitchout();
        if (dataOut != null && !dataOut.equals(dataVoltura) && !dataOut.equals(endDate)) {
            this.handleDate(anno, mese, pod, pdo, stimata, accumulator, dataOut, misureFine, true, environment);
        }
        WorkingPeriod period = rilMese.getPeriod();
        Date startDate = period.getStartDate();
        String codiceOfferta = pod.getCodiceOfferta(startDate);
        accumulator.setOfferta(codiceOfferta, codicePod, transaction);
        this.handleDate(anno, mese, pod, pdo, stimata, accumulator, endDate, misureFine, false, environment);
        boolean rettifica = environment.isRettifica();
        Date dataMisuraSmis = environment.getDataMisuraSmis();
        errori.addAll(this.handleStatoMisure(true, false, rettifica, dataMisuraSmis, reseller, misureDates, transaction));
        errori.addAll(this.handleStatoMisure(crm, false, rettifica, dataMisuraSmis, reseller, misureVoltura, transaction));
        boolean switchOut = environment.isSwitchout();
        errori.addAll(this.handleStatoMisure(true, switchOut, rettifica, dataMisuraSmis, reseller, misureFine, transaction));
        Date date = pod.getInizioConvenzionale();
        boolean commerciale = CalendarioCommercialeHelper.isCommerciale(transaction, codiceOfferta, this.configuration);
        String codiceFlusso = pdo.getFirstCodiceFlusso();
        Misura misura = new Misura(date, stimata, 3, codiceFlusso, "", commerciale, codiceOfferta);
        MisuraContatorePdo misuraPdo = new MisuraContatorePdo(pod, pdo, misura, "G");
        Misura misAnte = GestFile16Helper.buildMisuraZero(3, codiceFlusso, pdo.getId());
        misuraPdo.setMisAnte(misAnte);
        if (MisureOrarieService.checkNuovo(pod, misura) && !MisureOrarieService.checkRiconfigurazioni(codiceFlusso, pod, misureDates, misureVoltura, misureFine)) {
            this.handleNuovo(reseller, misuraPdo, transaction);
        } else {
            boolean flMisbio = pod.isFlMisbio();
            if (flMisbio != commerciale) {
                transaction.addRiconfigurazione("let-tec", misuraPdo);
            }
        }
        if (!environment.isBlocked()) {
            errori.addAll(this.handleMisure(false, rettifica, reseller, environment, misureDates, transaction));
            errori.addAll(this.handleMisure(false, rettifica, reseller, environment, misureVoltura, transaction));
            errori.addAll(this.addRiconfigurazionePod2GR(codicePod, misureFine, transaction));
            errori.addAll(this.handleMisure(switchOut, rettifica, reseller, environment, misureFine, transaction));
        }
        return errori;
    }

    private static boolean checkRiconfigurazioni(String codiceFlusso, Pod pod, List<MisuraPdo> misureDates, List<MisuraPdo> misureVoltura, List<MisuraPdo> misureFine) {
        return MisureOrarieService.checkRiconfigurazioni(codiceFlusso, pod, misureDates) || MisureOrarieService.checkRiconfigurazioni(codiceFlusso, pod, misureVoltura) || MisureOrarieService.checkRiconfigurazioni(codiceFlusso, pod, misureFine);
    }

    private static boolean checkRiconfigurazioni(String codiceFlusso, Pod pod, List<MisuraPdo> misure) {
        boolean riconfigurazione = false;
        Iterator<MisuraPdo> iterator = misure.iterator();
        while (!riconfigurazione && iterator.hasNext()) {
            MisuraPdo misura = iterator.next();
            Date dataMisura = misura.getDataMisura();
            riconfigurazione = MisureOrarieService.checkRiconfigurazione(codiceFlusso, pod, dataMisura);
        }
        return riconfigurazione;
    }

    private void handleNuovo(Reseller reseller, MisuraContatorePdo misuraPdo, StatusTransaction transaction) throws StatoPodCheckException, PraticaAnnullataException, DataNotFoundException {
        String prefix = "let-tec";
        if (reseller.isHandleStato()) {
            try {
                SE1Handler pdoSnfHandler = new SE1Handler();
                PdoSnfStatoPodHandler pdoSnfStatoPodHandler = new PdoSnfStatoPodHandler(this.misureDao, pdoSnfHandler);
                pdoSnfStatoPodHandler.handleStato(misuraPdo, transaction);
            }
            catch (DataNotFoundException exc) {
                String message = exc.getMessage();
                if (message.equals("statopod.notfound")) {
                    VT1Handler pdoSnfHandler = new VT1Handler();
                    PdoSnfStatoPodHandler pdoSnfStatoPodHandler = new PdoSnfStatoPodHandler(this.misureDao, pdoSnfHandler);
                    pdoSnfStatoPodHandler.handleStato(misuraPdo, transaction);
                    transaction.count("prest-d65");
                    prefix = "Volture-IV-VNO-misure";
                }
                throw exc;
            }
        }
        transaction.addRiconfigurazione(prefix, misuraPdo);
    }

    private static boolean checkNuovo(Pod pod, Misura misura) {
        Date dataMisura = misura.getDate();
        Date dataPrestazione = CalendarTools.nextDay(dataMisura);
        boolean podNuovo = pod.isPodNuovo(dataPrestazione);
        Date dataMax = pod.getDataMax();
        Date dataInizio = pod.getDataInizio(dataPrestazione);
        boolean azzeramento = pod.isAzzeramento(dataPrestazione);
        return podNuovo && dataMax.before(dataInizio) && !azzeramento;
    }

    private Set<ErrorePdo> addRiconfigurazionePod2GR(String codicePod, List<MisuraPdo> misureFine, StatusTransaction transaction) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException {
        HashSet<ErrorePdo> errori = new HashSet<ErrorePdo>();
        Map<String, Mno> riconfigurazioniPod2GR = transaction.getRiconfigurazioniPod2GR();
        Mno mno = riconfigurazioniPod2GR.get(codicePod);
        if (mno != null) {
            riconfigurazioniPod2GR.remove(codicePod);
            PodMap podMap = transaction.getPodMap();
            Pod pod = podMap.get(codicePod);
            String azienda = pod.getAzienda();
            mno.setCdaziend(azienda);
            Pdo pdo = MisureOrarieService.buildPdo(mno, azienda);
            Misura misura = mno.getMisura();
            MisuraContatorePdo misuraPdo = new MisuraContatorePdo(pod, pdo, misura, "5");
            misuraPdo.setKa(mno.getKaSegnale());
            misuraPdo.setKr(mno.getKrSegnale());
            misuraPdo.setKp(mno.getKpSegnale());
            int lastIndex = misureFine.size() - 1;
            MisuraPdo lastMisura = misureFine.get(lastIndex);
            SafeMap<String, Reseller> resellers = transaction.getResellers();
            Reseller reseller = (Reseller)resellers.get(azienda);
            if (reseller.isHandleStato()) {
                ExtMno extMno = new ExtMno(mno);
                ExtMno extMnoPrev = MisureOrarieService.buildMnoPrev(mno, lastMisura);
                SmontaggioStatoPodHandler smontaggioSPH = new SmontaggioStatoPodHandler("MISURE_POD_ORARI", true, this.misureDao, CURRENT_MISURA_HANDLER);
                PdoTH pdoTH = new PdoTH(false);
                MontaggioStatoPodHandler montaggioSPH = new MontaggioStatoPodHandler(pdoTH, this.misureDao);
                StatoPodHelper.handleSmisStatoPod(transaction, extMno, extMnoPrev, pod, pod, smontaggioSPH, montaggioSPH);
            }
            Misura misAnte = lastMisura.getMisura();
            misureFine.remove(lastIndex);
            misuraPdo.setMisAnte(misAnte);
            transaction.addRiconfigurazionePdo2GR(mno, misuraPdo);
            lastMisura.getPdo().addId(mno.getFirstId());
            errori.addAll(this.checkModello(misuraPdo));
        }
        return errori;
    }

    private static ExtMno buildMnoPrev(Mno mno, MisuraPdo lastMisura) {
        HashMap<String, Map<String, String>> datiPod = new HashMap<String, Map<String, String>>();
        HashMap datiPdp = new HashMap();
        datiPod.put("DatiPdp", datiPdp);
        Mno mnoPrev = new Mno(mno.getFirstId(), null, mno.getCodicePod(), lastMisura.getMisura(), mno.getPivaUtente(), mno.getPivaDistributore(), mno.getCodContrDisp(), null, null, null, null, datiPod, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, false, false, null);
        ExtMno extMnoPrev = new ExtMno(mnoPrev, false, new NullReferenceHandler<MisuraPod>());
        return extMnoPrev;
    }

    private static Pdo buildPdo(Mno mno, String azienda) {
        Set<String> id = mno.getId();
        HashMap<String, Map<String, String>> datiPod = new HashMap<String, Map<String, String>>();
        HashMap<String, String> datiPdp = new HashMap<String, String>();
        datiPdp.put("Trattamento", "O");
        datiPod.put("DatiPdp", datiPdp);
        Pdo pdo = new Pdo(null, false, null, null, null, null, null, azienda, datiPod, null, null, null, null, null, null, null, null, null);
        pdo.setId(id);
        return pdo;
    }

    private void handleDate(int anno, Month mese, Pod pod, Pdo pdo, boolean stimata, MisuraAccumulator accumulator, Date dataRichiesta, List<MisuraPdo> misure, boolean overflowRichiesto, MisureOrarieEnvironment environment) throws IncoherenceException {
        boolean overflow;
        Date date;
        Date dataMisuraSmis = environment.getDataMisuraSmis();
        boolean switchout = environment.isSwitchout();
        if (dataRichiesta.after(dataMisuraSmis) && !switchout) {
            date = dataMisuraSmis;
            overflow = true;
        } else {
            date = dataRichiesta;
            overflow = overflowRichiesto;
        }
        if (MisureOrarieService.checkMese(anno, mese, date) && MisureOrarieService.checkMisure(pdo, date)) {
            Date misuraDate;
            double ka = pod.getKa(date);
            double kr = pod.getKr(date);
            double kp = pod.getKp(date);
            String codiceFlusso = pdo.getFirstCodiceFlusso();
            String codicePod = pod.getCodice();
            if (codiceFlusso != null && (codiceFlusso.endsWith("2G") ? pod.isMisuraAttiva(date) && pdo.getKa() != ka || pod.isMisuraReattiva(date) && pdo.getKr() != kr || pod.isMisuraPotenza(date) && pdo.getKp() != kp : pod.isAzzeramento(date) && codiceFlusso.equals("PDO") && (ka != 1.0 || kr != 1.0 || kp != 1.0))) {
                throw new IncoherenceException("notcoherent.k", codicePod, ErroriElaborazione.K_NOTCOHERENT);
            }
            do {
                Misura misura;
                if ((misuraDate = (misura = accumulator.buildMisuraRaw(stimata, date)).getDate()) != null) {
                    Date dataInizio;
                    if (overflow) {
                        Date endDate = CalendarTools.getEndDate(anno, mese);
                        Misura misuraOverflow = accumulator.buildMisuraRaw(stimata, endDate);
                        Date overflowDate = CalendarTools.nextDay(date);
                        Date dataMisuraOverflow = misuraOverflow.getDate();
                        if (dataMisuraOverflow != null && overflowDate.equals(dataMisuraOverflow)) {
                            MisureOrarieService.sum(misura, misuraOverflow);
                        } else {
                            this.addMisura(pod, pdo, misura, false, ka, kr, kp, misure);
                            misura = misuraOverflow;
                        }
                    }
                    Date startDate = pdo.getStartDate();
                    Date firstDataInizio = pod.getFirstDataInizio();
                    Date date2 = dataInizio = firstDataInizio == null ? startDate : CalendarTools.max(firstDataInizio, startDate);
                    if (dataInizio == null || !misuraDate.before(dataInizio) && !overflow || !misura.isZero()) {
                        Date nextDataMisura = CalendarTools.nextDay(misuraDate);
                        Date dataInst = pod.getDataInst(nextDataMisura);
                        Date prevDataInst = CalendarTools.previousDay(dataInst);
                        boolean smis = misuraDate.equals(dataMisuraSmis) || misuraDate.equals(prevDataInst);
                        this.addMisura(pod, pdo, misura, smis, ka, kr, kp, misure);
                    }
                }
                date = dataRichiesta;
                overflow = false;
            } while (misuraDate != null && misuraDate.before(date));
        }
    }

    private static boolean checkMisure(Pdo pdo, Date date) {
        Date startDate = pdo.getStartDate();
        return !startDate.after(date);
    }

    private static void sum(Misura misura, Misura misuraOverflow) {
        MisuraCompleta[] attiva = misura.getAttiva();
        MisuraCompleta[] reattiva = misura.getReattiva();
        MisuraCompleta[] potenza = misura.getPotenza();
        MisuraCompleta[] attivaOverflow = misuraOverflow.getAttiva();
        MisuraCompleta[] reattivaOverflow = misuraOverflow.getReattiva();
        MisuraCompleta[] potenzaOverflow = misuraOverflow.getPotenza();
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            int index = fascia.ordinal();
            attiva[index].add(attivaOverflow[index]);
            reattiva[index].add(reattivaOverflow[index]);
            potenza[index].setMax(potenzaOverflow[index]);
            ++n3;
        }
    }

    private void addMisura(Pod pod, Pdo pdo, Misura misura, boolean smis, double ka, double kr, double kp, List<MisuraPdo> misure) {
        misura.align(this.configuration, ka, kr, kp);
        MisuraPdo misuraPdo = new MisuraPdo(pod, pdo, misura, smis);
        misuraPdo.setKa(String.valueOf(ka));
        misuraPdo.setKr(String.valueOf(kr));
        misuraPdo.setKp(String.valueOf(kp));
        misure.add(misuraPdo);
    }

    private static boolean checkMese(int anno, Month mese, Date date) {
        WorkingPeriod wp = new WorkingPeriod(anno, mese);
        return wp.covers(date);
    }

    private Set<ErrorePdo> handleStatoMisure(boolean crm, boolean switchout, boolean rettifica, Date dataMisuraSmis, Reseller reseller, List<MisuraPdo> misure, StatusTransaction transaction) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException, MisuraNonZeroException {
        HashSet<ErrorePdo> errori = new HashSet<ErrorePdo>();
        for (MisuraPdo misura : misure) {
            errori.addAll(this.handleStatoMisura(crm, switchout, rettifica, dataMisuraSmis, reseller, misura, transaction));
        }
        return errori;
    }

    private Set<ErrorePdo> handleStatoMisura(boolean crm, boolean switchout, boolean rettifica, Date dataMisuraSmis, Reseller reseller, MisuraPdo misura, StatusTransaction transaction) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException, MisuraNonZeroException {
        Pod pod = misura.getPod();
        Date dataMisura = misura.getDataMisura();
        HashSet<ErrorePdo> errori = new HashSet<ErrorePdo>();
        if (dataMisura.after(dataMisuraSmis) && !switchout) {
            Set<String> id = misura.getId();
            String codiceFlusso = misura.getCodiceFlusso();
            errori.add(new ErrorePdo(ErroriElaborazione.BLOCKED_PDO, codiceFlusso, id));
        } else {
            String codiceFlusso = misura.getFirstCodiceFlusso();
            if (MisureOrarieService.canBePositive(pod, dataMisura, codiceFlusso, dataMisuraSmis)) {
                if (switchout) {
                    Date dataSwitchout = pod.getSwitchout();
                    if (!rettifica && dataMisura.equals(dataSwitchout)) {
                        this.handleSwitchOut(transaction, reseller, misura);
                    }
                } else if (!crm) {
                    this.handleVoltura(reseller, transaction, misura);
                }
            } else {
                errori.addAll(MisureOrarieService.checkMisuraZero(misura));
            }
        }
        return errori;
    }

    private static boolean canBePositive(Pod pod, Date dataMisura, String codiceFlusso, Date dataMisuraPrestazione) {
        Date dataSwitchout = pod.getSwitchout();
        return !pod.isOrario() || pod.isAzzeramento(dataMisura) && (dataMisura.equals(dataSwitchout) || !dataMisura.after(dataMisuraPrestazione)) || MisureOrarieService.checkRiconfigurazione(codiceFlusso, pod, dataMisura);
    }

    private Set<ErrorePdo> handleMisure(boolean switchout, boolean rettifica, Reseller reseller, MisureOrarieEnvironment environment, List<MisuraPdo> misure, StatusTransaction transaction) throws MisuraNonZeroException, StatoPodInvalidoException, StatoPodObsoletoException, DataNotFoundException {
        HashSet<ErrorePdo> errori = new HashSet<ErrorePdo>();
        for (MisuraPdo misura : misure) {
            errori.addAll(this.handleMisura(switchout, rettifica, reseller, environment, misura, transaction));
        }
        return errori;
    }

    private List<ErrorePdo> checkModello(MisuraPdo misuraPdo) {
        ArrayList<ErrorePdo> errori = new ArrayList<ErrorePdo>();
        String codiceFlusso = misuraPdo.getCodiceFlusso();
        if (codiceFlusso != null && codiceFlusso.endsWith("2G")) {
            Date dataMisura = misuraPdo.getDataMovimento();
            Pod pod = misuraPdo.getPod();
            String cdConMagKey = pod.getCdConMag(dataMisura);
            CdConMag cdConMag = this.configuration.getCdConMag(cdConMagKey);
            Generazione generazione = cdConMag.getGenerazione();
            if (!generazione.checkCodiceFlusso(codiceFlusso)) {
                Set<String> id = misuraPdo.getId();
                errori.add(new ErrorePdo(ErroriElaborazione.INCOHERENT_MODEL, codiceFlusso, id));
            }
        }
        return errori;
    }

    private Set<ErrorePdo> handleMisura(boolean switchout, boolean rettifica, Reseller reseller, MisureOrarieEnvironment environment, MisuraPdo misuraPdo, StatusTransaction transaction) throws MisuraNonZeroException, StatoPodInvalidoException, StatoPodObsoletoException, DataNotFoundException {
        HashSet<ErrorePdo> errori = new HashSet<ErrorePdo>();
        errori.addAll(this.checkModello(misuraPdo));
        Date dataMisura = misuraPdo.getDataMisura();
        Date dataSwitchout = misuraPdo.getSwitchout();
        if (switchout && dataMisura.equals(dataSwitchout)) {
            if (rettifica) {
                transaction.addRettificaSwitchOut(misuraPdo);
            }
        } else {
            Pod pod = misuraPdo.getPod();
            String firstCodiceFlusso = misuraPdo.getFirstCodiceFlusso();
            boolean riconfigurazione = MisureOrarieService.checkRiconfigurazione(firstCodiceFlusso, pod, dataMisura);
            Date dataMisuraSmis = environment.getDataMisuraSmis();
            if (MisureOrarieService.canBePositive(pod, dataMisura, firstCodiceFlusso, dataMisuraSmis)) {
                misuraPdo.setSegnali(true);
                Date dataMisuraPrestazione = environment.getDataMisuraPrestazione();
                TipoLetStd tipo = dataMisura.after(dataMisuraPrestazione) ? TipoLetStd.PIV : TipoLetStd.NOPIV;
                transaction.addMisuraOrariaPeriodo(misuraPdo, tipo);
                String codicePod = pod.getCodice();
                if (riconfigurazione && this.codiciPodRiconfigurati.add(codicePod)) {
                    MisuraContatorePdo riconfMisuraPodSP = MisureOrarieService.buildMisuraRiconfSP(misuraPdo);
                    this.handleStatoPod(riconfMisuraPodSP, reseller, transaction);
                    MisuraContatorePdo riconfMisuraPod = MisureOrarieService.buildMisuraRiconf(misuraPdo);
                    transaction.addRiconfigurazione("let-tec", riconfMisuraPod);
                }
            } else {
                errori.addAll(MisureOrarieService.checkMisuraZero(misuraPdo));
            }
        }
        return errori;
    }

    private static MisuraContatorePdo buildMisuraRiconfSP(MisuraPdo misuraPdo) {
        Pod pod = misuraPdo.getPod();
        Pdo pdo = misuraPdo.getPdo();
        String codiceFlusso = misuraPdo.getCodiceFlusso();
        Date dataMisura = misuraPdo.getDataMisura();
        Set<String> id = misuraPdo.getId();
        Misura misura = MisureOrarieService.buildMisura(pod, dataMisura, codiceFlusso, id);
        MisuraContatorePdo riconfMisuraPod = new MisuraContatorePdo(pod, pdo, misura, "G");
        if (codiceFlusso.endsWith("2G")) {
            riconfMisuraPod.setKa(pdo.getKaString());
            riconfMisuraPod.setKr(pdo.getKrString());
            riconfMisuraPod.setKp(pdo.getKpString());
        }
        return riconfMisuraPod;
    }

    private static MisuraContatorePdo buildMisuraRiconf(MisuraPdo misuraPdo) {
        Pod pod = misuraPdo.getPod();
        Pdo pdo = misuraPdo.getPdo();
        String codiceFlusso = misuraPdo.getCodiceFlusso();
        Date dataMax = pod.getDataMax();
        Misura misura = new Misura(dataMax, false, 3, codiceFlusso);
        MisuraContatorePdo riconfMisuraPod = new MisuraContatorePdo(pod, pdo, misura, "G");
        if (codiceFlusso.endsWith("2G")) {
            riconfMisuraPod.setKa(pdo.getKaString());
            riconfMisuraPod.setKr(pdo.getKrString());
            riconfMisuraPod.setKp(pdo.getKpString());
        }
        Set<String> id = misura.getId();
        Misura misAnte = MisureOrarieService.buildMisura(pod, dataMax, codiceFlusso, id);
        riconfMisuraPod.setMisAnte(misAnte);
        return riconfMisuraPod;
    }

    private void handleStatoPod(MisuraPdo prevMisuraPdo, Reseller reseller, StatusTransaction transaction) throws StatoPodInvalidoException, StatoPodObsoletoException, DataNotFoundException {
        if (reseller.isHandleStato()) {
            Pod pod = prevMisuraPdo.getPod();
            Pdo pdo = prevMisuraPdo.getPdo();
            Set<String> id = pdo.getId();
            Date dataMisura = pod.getDataMax();
            MisuraPod currMisuraPdo = MisureOrarieService.cloneMisuraZero(prevMisuraPdo);
            NullReferenceHandler<MisuraPod> refHandler = new NullReferenceHandler<MisuraPod>();
            SmontaggioStatoPodHandler smontaggioSPH = new SmontaggioStatoPodHandler("MISURE_POD_ORARI", true, this.misureDao, RIFERIMENTO_MISURA_HANDLER);
            PdoTH pdoTH = new PdoTH(true);
            MontaggioStatoPodHandler montaggioSPH = new MontaggioStatoPodHandler(pdoTH, this.misureDao);
            StatoPodHelper.handleSmisStatoPod(id, dataMisura, prevMisuraPdo, currMisuraPdo, refHandler, refHandler, smontaggioSPH, montaggioSPH, transaction);
        }
    }

    private static MisuraPod cloneMisuraZero(MisuraPdo prevMisuraPdo) {
        String codiceFlusso = prevMisuraPdo.getCodiceFlusso();
        Pod pod = prevMisuraPdo.getPod();
        Pdo pdo = prevMisuraPdo.getPdo();
        Set<String> id = prevMisuraPdo.getId();
        Misura misuraZero = GestFile16Helper.buildMisuraZero(3, codiceFlusso, id);
        misuraZero.setDate(prevMisuraPdo.getDataMovimento());
        MisuraPdo currMisuraPdo = new MisuraPdo(pod, pdo, misuraZero);
        currMisuraPdo.setKa(prevMisuraPdo.getKaString());
        currMisuraPdo.setKr(prevMisuraPdo.getKrString());
        currMisuraPdo.setKp(prevMisuraPdo.getKpString());
        return currMisuraPdo;
    }

    private static Misura buildMisura(Pod pod, Date date, String codiceFlusso, Set<String> id) {
        Misura misura = new Misura(date, false, 3, codiceFlusso, id, false, null);
        double[] lastAttiva = pod.getLastAttiva();
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            double value = lastAttiva[fascia.ordinal()];
            misura.setAttiva(fascia, value, 0.0);
            ++n3;
        }
        double[] lastReattiva = pod.getLastReattiva();
        FasciaOraria[] fasciaOrariaArray2 = FasciaOraria.values();
        int n4 = fasciaOrariaArray2.length;
        n2 = 0;
        while (n2 < n4) {
            FasciaOraria fascia = fasciaOrariaArray2[n2];
            double value = lastReattiva[fascia.ordinal()];
            misura.setReattiva(fascia, value, 0.0);
            ++n2;
        }
        return misura;
    }

    private static boolean checkRiconfigurazione(String codiceFlusso, Pod pod, Date dataMisura) {
        Date dataMax = pod.getDataMax();
        Date dataInstallazione = pod.getDataInst(dataMisura);
        Date inizio = dataInstallazione == null ? null : CalendarTools.previousDay(dataInstallazione);
        boolean azzeramento = pod.hasAzzeramento(dataMisura);
        return "PDO2G".equals(codiceFlusso) && !azzeramento && dataMax.equals(inizio);
    }

    private static Set<ErrorePdo> checkMisuraZero(MisuraPdo misuraPdo) throws MisuraNonZeroException {
        Misura misura = misuraPdo.getMisura();
        String firstCodiceFlusso = misuraPdo.getFirstCodiceFlusso();
        HashSet<ErrorePdo> errori = new HashSet<ErrorePdo>();
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            double attiva = misura.getAttiva(fascia).getNetto();
            double reattiva = misura.getReattiva(fascia).getNetto();
            double potenza = misura.getPotenza(fascia).getNetto();
            if (attiva != 0.0 || reattiva != 0.0 || potenza != 0.0) {
                Pod pod = misuraPdo.getPod();
                boolean azzeramento = pod.hasAzzeramento();
                if (firstCodiceFlusso.equals("PDO2G") || !azzeramento) {
                    throw new MisuraNonZeroException(misuraPdo);
                }
                Set<String> id = misuraPdo.getId();
                String codiceFlusso = misuraPdo.getCodiceFlusso();
                errori.add(new ErrorePdo(ErroriElaborazione.MISURA_NON_ZERO, codiceFlusso, id));
            }
            ++n3;
        }
        return errori;
    }

    private void handleVoltura(Reseller reseller, StatusTransaction transaction, MisuraPdo misuraPdo) throws DataNotFoundException {
        String codicePod = misuraPdo.getCodicePod();
        PraticaVolo pratica = StrategyHelper.getPiv(codicePod, null, transaction);
        String codicePrestazione = pratica.getCodicePrestazione();
        String cpGestore = pratica.getCodPratAtt();
        MisuraPdo misuraPdoZero = MisureOrarieService.buildMisuraPdoZero(misuraPdo);
        if (reseller.isHandleStato()) {
            VolturaDefferedStatoPod deferredStatoPod = new VolturaDefferedStatoPod(this.pdoVoltureSPH, misuraPdoZero, codicePrestazione, cpGestore);
            transaction.addDeferredStatoPod(deferredStatoPod);
        }
        MisuraVoltura voltura = new MisuraVoltura(codicePrestazione, misuraPdoZero);
        transaction.addVolturaNoCrm(voltura);
    }

    private static MisuraPdo buildMisuraPdoZero(MisuraPdo misuraPdo) {
        Pod pod = misuraPdo.getPod();
        Pdo pdo = misuraPdo.getPdo();
        Date dataMisura = misuraPdo.getDataMisura();
        Misura misuraOrig = misuraPdo.getMisura();
        boolean stimata = misuraOrig.isStimata();
        boolean commerciale = misuraOrig.hasCommerciale();
        String offerta = misuraOrig.getCodiceOfferta();
        String codiceFlusso = pdo.getFirstCodiceFlusso();
        Misura misura = new Misura(dataMisura, stimata, 3, codiceFlusso, "", commerciale, offerta);
        GestFile16Helper.fillMisuraZero(misura);
        MisuraPdo misuraPdoZero = new MisuraPdo(pod, pdo, misura);
        String ka = misuraPdo.getKaString();
        String kr = misuraPdo.getKrString();
        String kp = misuraPdo.getKpString();
        misuraPdoZero.setKa(ka);
        misuraPdoZero.setKr(kr);
        misuraPdoZero.setKp(kp);
        return misuraPdoZero;
    }

    private void handleSwitchOut(StatusTransaction transaction, Reseller reseller, MisuraPdo misuraPdo) throws StatoPodInvalidoException, StatoPodObsoletoException, DataNotFoundException, PraticaAnnullataException {
        String azienda = reseller.getCodice();
        Pod pod = misuraPdo.getPod();
        MnoPod mnoPod = transaction.getPno(pod);
        String codicePod = misuraPdo.getCodicePod();
        Collection<ExtMno> smis = mnoPod.getSmis();
        if (MisureOrarieService.checkCP1(smis, misuraPdo)) {
            if (this.switchouts.add(codicePod)) {
                PraticaVolo pratica = StrategyHelper.getPiv(codicePod, null, transaction);
                pratica.setHandled(true);
                String codicePrestazione = pratica.getCodicePrestazione();
                TipoPrestazione tipoPrestazione = TipoPrestazione.create(codicePrestazione);
                String cpGestore = pratica.getCodPratAtt();
                DispatchingFlussi dispatchingFlussi = transaction.getDispatchingFlussi();
                boolean resellerCrm = reseller.isCrm();
                String destinazione = dispatchingFlussi.getDestinazione("E", codicePrestazione, "PDO", azienda, resellerCrm);
                if (reseller.isHandleStato()) {
                    PdoSwitchoutSPB builder = new PdoSwitchoutSPB(this.misureDao);
                    AbstractStatoPodHandler<MisuraPdo> statoPodHandler = tipoPrestazione.getStatoPodHandler(builder);
                    statoPodHandler.handleStato(misuraPdo, codicePrestazione, cpGestore, transaction);
                    StatoPod lastStatoPod = transaction.getLastStatoPod();
                    for (ExtMno extMno : smis) {
                        extMno.setForcedStatoPod(lastStatoPod);
                    }
                }
                tipoPrestazione.addSwitchOut(destinazione, codicePrestazione, misuraPdo, transaction);
                transaction.count(codicePrestazione);
                tipoPrestazione.addMisuraOrariaPeriodo(misuraPdo, transaction);
            } else if (!misuraPdo.isZero()) {
                transaction.addMisuraOrariaPeriodo(misuraPdo, TipoLetStd.NOPIV);
            }
        } else {
            ExtMno smontaggio = smis.iterator().next();
            Mno mnoSmontaggio = smontaggio.getMno();
            Date dataSmis = mnoSmontaggio.getDataMisura();
            misuraPdo.setDataMisura(dataSmis);
            transaction.addMisuraOrariaPeriodo(misuraPdo, TipoLetStd.NOPIV);
        }
    }

    private static boolean checkCP1(Collection<ExtMno> smisCollection, MisuraPdo misuraPdo) {
        boolean ok = true;
        Date dataMisura = misuraPdo.getDataMisura();
        for (ExtMno smis : smisCollection) {
            Mno mno = smis.getMno();
            Date dataMno = mno.getDataMisura();
            if (!dataMisura.after(dataMno)) continue;
            ok = false;
        }
        return ok;
    }
}

