/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.model.ErrorWrapper;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.MnoPod;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.services.volture.ExtMno;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.KeyRecord;
import org.homelinux.elabor.structures.safe.DefaultSafeMap;
import org.homelinux.elabor.structures.safe.RecordSafeMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public class MisureAzienda
implements KeyRecord<String> {
    private final String azienda;
    private final RecordSafeMap<String, MnoPod> misure;

    public MisureAzienda(String azienda) {
        ErrorWrapper error = new ErrorWrapper("pno", ErroriElaborazione.PNO_NOTFOUND);
        this.misure = new DefaultSafeMap<String, MnoPod>(error);
        this.azienda = azienda;
    }

    @Override
    public String getKey() {
        return this.azienda;
    }

    public SafeMap<String, MnoPod> getMisure() {
        return this.misure;
    }

    public Mno addMisuraPeriodo(Pod pod, Mno mno) {
        MnoPod mnoPod = this.getMisure(pod);
        return mnoPod.addMisuraPno(mno);
    }

    public boolean addMisuraPdo2GR(Pod pod, Mno mno) {
        MnoPod mnoPod = this.getMisure(pod);
        return mnoPod.addMisuraPdo2GR(mno);
    }

    public void addMisuraTecnica(Pod pod, Mno mno) {
        MnoPod mnoPod = this.getMisure(pod);
        mnoPod.addMisuraTecnica(mno);
    }

    public void addMisuraSospetta(Pod pod, Mno mno) {
        MnoPod mnoPod = this.getMisure(pod);
        mnoPod.addMisuraSospetta(mno);
    }

    public void addSmis(Pod pod, ExtMno smis) {
        MnoPod mnoPod = this.getMisure(pod);
        mnoPod.addSmis(smis);
    }

    public void addSwitchout(Pod pod, Mno mno) throws DataNotFoundException {
        MnoPod mnoPod = this.getMisure(pod);
        mnoPod.addSwitchout(mno);
    }

    public MnoPod getMisure(Pod pod) {
        MnoPod mnoPod;
        String codicePod = pod.getCodice();
        try {
            mnoPod = (MnoPod)this.misure.get(codicePod);
        }
        catch (DataNotFoundException e2) {
            mnoPod = new MnoPod(pod);
            this.misure.add(mnoPod);
        }
        return mnoPod;
    }

    public boolean contains(String codicePod) {
        return this.misure.contains(codicePod);
    }
}

