/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.AbstractMisuraMno;
import biz.elabor.prebilling.model.misure.Mno;
import java.util.Date;

public class MisuraMno
extends AbstractMisuraMno {
    private final boolean smis;
    private final Date fixDataMisura;

    public MisuraMno(Pod pod, Mno mno) {
        this(pod, mno, null);
    }

    public MisuraMno(Pod pod, Mno mno, boolean smis) {
        this(pod, mno, smis, null);
    }

    public MisuraMno(Pod pod, Mno mno, Date fixDataMisura) {
        this(pod, mno, false, fixDataMisura);
    }

    public MisuraMno(Pod pod, Mno mno, boolean smis, Date fixDataMisura) {
        super(pod, mno);
        this.smis = smis;
        this.fixDataMisura = fixDataMisura;
    }

    @Override
    public boolean hasAttiva() {
        Date dataMisura = this.getDataMisura();
        return this.pod.isMisuraAttiva(dataMisura);
    }

    @Override
    public boolean hasReattiva() {
        Date dataMisura = this.getDataMisura();
        return this.pod.isMisuraReattiva(dataMisura);
    }

    @Override
    public boolean hasPotenza() {
        Date dataMisura = this.getDataMisura();
        return this.pod.isMisuraPotenza(dataMisura);
    }

    @Override
    public String getCountLabel() {
        return "prest_" + this.getCodiceFlusso();
    }

    @Override
    public boolean isCalcolata() {
        return this.getMno().isCalcolata();
    }

    @Override
    public boolean isPdo2GR() {
        return this.getMno().isPdo2GR();
    }

    @Override
    public boolean isSmis() {
        return this.smis;
    }

    @Override
    public Date getDataMisura() {
        return this.fixDataMisura == null ? super.getDataMisura() : this.fixDataMisura;
    }
}

