/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.letture.ConsumiService;
import biz.elabor.prebilling.services.letture.ConsumiServiceHelper;
import biz.elabor.prebilling.services.letture.MisureMese;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class IdConsumiService
implements ConsumiService {
    private String id;
    private int inizio;
    private int fine;
    private final MisureDao misureDao;
    private final TalkManager talkManager;
    private final ConsumiServiceHelper helper;
    private String codicePod;

    public IdConsumiService(String id, int inizio, int fine, String idCalendario, PrebillingDao prebillingDao, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager) {
        this.id = id;
        this.inizio = inizio;
        this.fine = fine;
        this.misureDao = misureDao;
        this.talkManager = talkManager;
        this.helper = new ConsumiServiceHelper(idCalendario, prebillingDao, configuration);
    }

    @Override
    public List<Misura> getMisure() throws DataNotFoundException, CalendarNotFoundException {
        Pdo pdo = this.misureDao.getPdo(this.id, this.talkManager);
        this.codicePod = pdo.getCodicePod();
        RilMese rilMese = pdo.getRilMese();
        int anno = rilMese.getAnno();
        Month mese = pdo.getRilMese().getMese();
        Date dataInizio = CalendarTools.getDate(anno, mese, this.inizio);
        Date dataFine = CalendarTools.getDate(anno, mese, this.fine);
        MisureMese misureMese = this.helper.getMisureMese(pdo, dataInizio, dataFine);
        return misureMese.getMisure();
    }

    @Override
    public String getCodicePod() {
        return this.codicePod;
    }
}

