/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.TipoEstrazione;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.statopod.NullReferenceHandler;
import biz.elabor.prebilling.services.volture.ExtMno;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMapKey;

public class GetSmisStrategy
implements ServiceStrategy {
    private final MisureDao misureDao;
    private final TipoEstrazione tipo;
    private final String reseller;
    private final String filtroPod;
    private final Date maxDate;
    private final TalkManager talkManager;

    public GetSmisStrategy(int anno, Month mese, String reseller, TipoEstrazione tipo, String filtroPod, MisureDao misureDao, TalkManager talkManager) {
        this.talkManager = talkManager;
        this.maxDate = CalendarTools.getEndDate(anno, mese);
        this.tipo = tipo;
        this.reseller = reseller;
        this.filtroPod = filtroPod;
        this.misureDao = misureDao;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        if (this.tipo.equals((Object)TipoEstrazione.TUTTI) || this.tipo.equals((Object)TipoEstrazione.NONORARI)) {
            ListMapKey<String, Mno> smis = this.misureDao.getSmis(this.reseller, this.filtroPod, StrategyHelper.STATI);
            for (Map.Entry entry : smis.entrySet()) {
                List podSmis = (List)entry.getValue();
                this.handlePodSmis(podSmis, status);
            }
        }
        return true;
    }

    private void handlePodSmis(List<Mno> podSmis, ServiceStatus status) {
        Mno prev = null;
        for (Mno next : podSmis) {
            if (prev == null) {
                prev = next;
                continue;
            }
            if (GetSmisStrategy.check(prev, next)) {
                this.elaboraSmis(prev, next, status);
                prev = null;
                continue;
            }
            this.addSmis(prev, status);
            prev = next;
        }
        if (prev != null) {
            this.addSmis(prev, status);
        }
    }

    private static boolean check(Mno smontaggio, Mno montaggio) {
        String raccoltaS = smontaggio.getRaccolta();
        String raccoltaM = montaggio.getRaccolta();
        Date dataS = smontaggio.getDataMisura();
        Date dataM = montaggio.getDataMisura();
        ElaborCalendar calendar = new ElaborCalendar(dataS);
        calendar.addGiorni(1);
        Date succDataS = calendar.getDate();
        return raccoltaS.equals("S") && raccoltaM.equals("M") && dataM.equals(succDataS);
    }

    private void elaboraSmis(Mno smontaggio, Mno montaggio, ServiceStatus status) {
        try {
            Pod pod;
            String codicePod = smontaggio.getCodicePod();
            PodMap pods = status.getPodMap();
            if (pods == null) {
                String codiceReseller = montaggio.getCdaziend();
                pod = new Pod(codicePod, false, 0, codiceReseller, null, null, false, false, false, null, null, null, false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, null, 0.0, 0.0, 0.0, false, null);
            } else {
                pod = pods.get(codicePod);
            }
            String azienda = pod.getAzienda();
            smontaggio.setCdaziend(azienda);
            montaggio.setCdaziend(azienda);
            StrategyHelper.handleKX(pod, montaggio);
            status.addSmis(pod, new ExtMno(smontaggio));
            status.addSmis(pod, new ExtMno(montaggio));
        }
        catch (DataNotFoundException exc) {
            String message = exc.getMessage();
            String key = exc.getKey();
            ErroriElaborazione error = StrategyHelper.getErroreElaborazione(exc);
            this.addSmisSospeso(smontaggio, key, message, error, status);
            this.addSmisSospeso(montaggio, key, message, error, status);
        }
    }

    private void addSmis(Mno smis, ServiceStatus status) {
        String codicePod = smis.getCodicePod();
        try {
            PodMap podMap = status.getPodMap();
            Pod pod = podMap.get(codicePod);
            if (pod.isOrario() && smis.getRaccolta().equals("M")) {
                Date dataMontaggio = smis.getDataMisura();
                Date dataSmontaggio = CalendarTools.previousDay(dataMontaggio);
                if (!dataSmontaggio.after(this.maxDate)) {
                    String id = smis.getId().iterator().next();
                    String flusso = smis.getCodiceFlusso();
                    String pIvaUtente = smis.getPivaUtente();
                    String pIvaDistributore = smis.getPivaDistributore();
                    String codContrDisp = smis.getCodContrDisp();
                    String codPratAtt = smis.getCodPratAtt();
                    String cdaziend = smis.getCdaziend();
                    String codiceFlusso = smis.getCodiceFlusso();
                    Misura misura = new Misura(dataSmontaggio, false, 3, codiceFlusso);
                    HashMap<String, Map<String, String>> datiPod = new HashMap<String, Map<String, String>>();
                    HashMap<String, String> datiPdp = new HashMap<String, String>();
                    datiPdp.put("Ka", "1");
                    datiPdp.put("Kr", "1");
                    datiPdp.put("Kp", "1");
                    datiPdp.put("Trattamento", "O");
                    datiPod.put("DatiPdp", datiPdp);
                    Mno smontaggio = new Mno(id, flusso, codicePod, misura, pIvaUtente, pIvaDistributore, codContrDisp, codPratAtt, cdaziend, null, null, datiPod, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, false, false, null);
                    status.addSmis(pod, new ExtMno(smontaggio, false, new NullReferenceHandler<MisuraPod>()));
                    status.addSmis(pod, new ExtMno(smis));
                }
            } else {
                this.addSmisSospeso(smis, codicePod, "smis.nonappaiato", ErroriElaborazione.SMIS_NONAPPAIATO, status);
            }
        }
        catch (DataNotFoundException exc) {
            this.addSmisSospeso(smis, codicePod, "smis.nonappaiato", ErroriElaborazione.SMIS_NONAPPAIATO, status);
        }
    }

    private void addSmisSospeso(Mno smis, String key, String message, ErroriElaborazione error, ServiceStatus status) {
        Message sentence = new Message("getsmis.strategy", message);
        sentence.addParam(key);
        this.talkManager.addSentence(sentence);
        String descrizione = this.talkManager.getMessage(sentence);
        MnoResult result = new MnoResult(smis, error, descrizione);
        status.addSmisSospeso(result);
    }
}

