/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.TestServiceStatus;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.services.letture.GetRfoLettureStrategy;
import biz.elabor.prebilling.services.letture.MockGetRfoStrategyMisuredaoDao;
import java.util.Date;
import java.util.Map;
import junit.framework.TestCase;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;

public class GetRfoStrategyTest
extends TestCase {
    private GetRfoLettureStrategy strategy;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        MockGetRfoStrategyMisuredaoDao misureDao = new MockGetRfoStrategyMisuredaoDao();
        this.strategy = new GetRfoLettureStrategy("", misureDao, null);
    }

    public void testExecute() {
        TestConfiguration configuration = new TestConfiguration();
        TestServiceStatus status = new TestServiceStatus(configuration);
        this.strategy.execute(status);
        Map<Date, Map<String, Pdo>> rfos = status.getRfoMap();
        GetRfoStrategyTest.assertEquals(3, rfos.entrySet().size());
        Date giugno = CalendarTools.getDate(2018, Month.JUNE, 1);
        Map<String, Pdo> mapRfo = rfos.get(giugno);
        GetRfoStrategyTest.assertEquals(2, mapRfo.size());
        Pdo pdo = mapRfo.get("pod1");
        String codicePod = pdo.getCodicePod();
        GetRfoStrategyTest.assertEquals("pod1", codicePod);
        pdo = mapRfo.get("pod2");
        codicePod = pdo.getCodicePod();
        GetRfoStrategyTest.assertEquals("pod2", codicePod);
        Date maggio = CalendarTools.getDate(2018, Month.MAY, 1);
        GetRfoStrategyTest.assertEquals(2, mapRfo.size());
        mapRfo = rfos.get(maggio);
        pdo = mapRfo.get("pod1");
        codicePod = pdo.getCodicePod();
        GetRfoStrategyTest.assertEquals("pod1", codicePod);
        pdo = mapRfo.get("pod2");
        codicePod = pdo.getCodicePod();
        GetRfoStrategyTest.assertEquals("pod2", codicePod);
        Date luglio = CalendarTools.getDate(2018, Month.JULY, 1);
        mapRfo = rfos.get(luglio);
        GetRfoStrategyTest.assertEquals(1, mapRfo.size());
        pdo = mapRfo.get("pod3");
        codicePod = pdo.getCodicePod();
        GetRfoStrategyTest.assertEquals("pod3", codicePod);
    }
}

