/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.PdoResult;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategyHelper;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class GetRfoLettureStrategy
implements ServiceStrategy {
    private final String filtroPod;
    private final MisureDao misureDao;
    private final TalkManager talkManager;
    private final DateFormat dataFormat;

    public GetRfoLettureStrategy(String filtroPod, MisureDao misureDao, TalkManager talkManager) {
        this.filtroPod = filtroPod;
        this.misureDao = misureDao;
        this.talkManager = talkManager;
        this.dataFormat = StrategyHelper.getDataFormat();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        List<Pdo> rfos = this.misureDao.getRfo(Funzionalita.LETTURE, this.filtroPod, StrategyHelper.STATI);
        TreeMap<Date, Map<String, Pdo>> mapRfo = new TreeMap<Date, Map<String, Pdo>>();
        for (Pdo rfo : rfos) {
            this.add(status, rfo, mapRfo);
        }
        status.setRfoMap(mapRfo);
        return true;
    }

    private void add(ServiceStatus status, Pdo rfo, Map<Date, Map<String, Pdo>> mapRfo) {
        String codicePod = rfo.getCodicePod();
        Date meseCompetenza = this.getMeseCompetenza(rfo);
        Map<String, Pdo> mapCodiceRfo = mapRfo.get(meseCompetenza);
        if (mapCodiceRfo == null) {
            mapCodiceRfo = new TreeMap<String, Pdo>();
            mapRfo.put(meseCompetenza, mapCodiceRfo);
        }
        if (mapCodiceRfo.containsKey(codicePod)) {
            Message sentence = new Message("get.rfo.strategy", "obsoleto");
            sentence.addParam(codicePod);
            sentence.addParam(this.dataFormat.format(meseCompetenza));
            sentence.setCss("alert-danger");
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            PdoResult result = new PdoResult(rfo, ErroriElaborazione.OBSOLETO, descrizione);
            status.addRfoObsoleto(result);
        } else {
            mapCodiceRfo.put(codicePod, rfo);
        }
    }

    public Date getMeseCompetenza(Pdo rfo) {
        RilMese rilMese = rfo.getRilMese();
        int anno = rilMese.getAnno();
        Month mese = rilMese.getMese();
        return CalendarTools.getDate(anno, mese, 1);
    }
}

