/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.TestServiceStatus;
import biz.elabor.prebilling.model.ErrorWrapper;
import biz.elabor.prebilling.model.TipoEstrazione;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.MnoPod;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.services.letture.GetPnoStrategy;
import biz.elabor.prebilling.services.letture.MisureAzienda;
import biz.elabor.prebilling.services.letture.MockGetPnoStrategyMisureDao;
import biz.elabor.prebilling.services.letture.PrebillingTestHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.Sentence;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.safe.DefaultSafeListMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public class GetPnoStrategyTest
extends TestCase {
    private GetPnoStrategy strategy;
    private TalkManager talkManager;
    private MockGetPnoStrategyMisureDao dao;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.dao = new MockGetPnoStrategyMisureDao();
        this.talkManager = new TalkManager();
    }

    public void testExecute() {
        TestConfiguration configuration = new TestConfiguration();
        Reseller tutti = new Reseller("*", "tutti", null, false, false);
        this.strategy = new GetPnoStrategy(2016, Month.JUNE, "", this.dao, this.talkManager);
        TestServiceStatus status = new TestServiceStatus(configuration);
        status.setPno(new MappaMisureAzienda(TipoEstrazione.TUTTI, tutti, this.talkManager, this.dao));
        DefaultPodMap pods = new DefaultPodMap();
        Date startDate = new Date(0L);
        int index = 10;
        while (index < 20) {
            Pod pod = new Pod("pod" + index, false, 0, "azienda", startDate, null, false, false, false, startDate, null, "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
            pods.add(pod);
            ++index;
        }
        pods.add(new Pod("pod4", true, 0, null, startDate, null, false, false, false, startDate, null, "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null));
        status.setPodMap(pods);
        ErrorWrapper error = new ErrorWrapper("pdo", ErroriElaborazione.PDO_NOTFOUND);
        DefaultSafeListMap<String, Pdo> pdos = new DefaultSafeListMap<String, Pdo>(error);
        status.setPdo(pdos);
        this.insertPnosPeriodoInMisureDao();
        this.strategy.execute(status);
        List<Sentence> sentences = this.talkManager.getSentences();
        GetPnoStrategyTest.assertEquals(2, sentences.size());
        Sentence sentence = sentences.get(0);
        GetPnoStrategyTest.assertEquals("pod.notfound", sentence.getDescription());
        sentence = sentences.get(1);
        GetPnoStrategyTest.assertEquals("pod.orario", sentence.getDescription());
        MappaMisureAzienda pnos = status.getPnos();
        MisureAzienda misureAzienda = (MisureAzienda)pnos.get("azienda");
        SafeMap<String, MnoPod> misure = misureAzienda.getMisure();
        GetPnoStrategyTest.assertEquals(10, misure.size());
        Iterable residue = status.getPnoSospesi();
        GetPnoStrategyTest.assertEquals(2, residue.size());
    }

    public void testExecuteReseller() {
        Pod pod;
        TestConfiguration configuration = new TestConfiguration();
        Reseller reseller = new Reseller("azienda1", "azienda1", null, false, false);
        this.strategy = new GetPnoStrategy(2016, Month.JUNE, "", this.dao, this.talkManager);
        TestServiceStatus status = new TestServiceStatus(configuration);
        status.setPno(new MappaMisureAzienda(TipoEstrazione.TUTTI, reseller, this.talkManager, this.dao));
        DefaultPodMap pods = new DefaultPodMap();
        Date startDate = new Date(0L);
        int index = 10;
        while (index < 15) {
            pod = new Pod("pod" + index, false, 0, "azienda1", startDate, null, false, false, false, startDate, null, "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
            pods.add(pod);
            ++index;
        }
        index = 15;
        while (index < 20) {
            pod = new Pod("pod" + index, false, 0, "azienda2", startDate, null, false, false, false, startDate, null, "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
            pods.add(pod);
            ++index;
        }
        status.setPodMap(pods);
        this.insertPnosPeriodoInMisureDao();
        this.strategy.execute(status);
        MappaMisureAzienda pnos = status.getPnos();
        MisureAzienda misureAzienda1 = (MisureAzienda)pnos.get("azienda1");
        MisureAzienda misureAzienda2 = (MisureAzienda)pnos.get("azienda2");
        SafeMap<String, MnoPod> misure1 = misureAzienda1.getMisure();
        GetPnoStrategyTest.assertNull(misureAzienda2);
        GetPnoStrategyTest.assertEquals(5, misure1.size());
        Iterable pnoSospesi = status.getPnoSospesi();
        GetPnoStrategyTest.assertEquals(2, pnoSospesi.size());
    }

    public void testExecuteDate() {
        TestConfiguration configuration = new TestConfiguration();
        Reseller tutti = new Reseller("*", "tutti", null, false, false);
        this.strategy = new GetPnoStrategy(2016, Month.JUNE, "", this.dao, this.talkManager);
        TestServiceStatus status = new TestServiceStatus(configuration);
        status.setPno(new MappaMisureAzienda(TipoEstrazione.TUTTI, tutti, this.talkManager, this.dao));
        DefaultPodMap pods = new DefaultPodMap();
        Date startDate = new Date(0L);
        int index = 10;
        while (index < 40) {
            Pod pod = new Pod("pod" + index, false, 0, "azienda", startDate, null, false, false, false, startDate, null, "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
            pods.add(pod);
            ++index;
        }
        status.setPodMap(pods);
        this.insertPnosTecnicheInMisureDaoTestExecuteDate();
        this.insertPnosPeriodoInMisureDaoTestExecuteDate();
        this.strategy.execute(status);
        MappaMisureAzienda pnos = status.getPnos();
        MisureAzienda misureAzienda = (MisureAzienda)pnos.get("azienda");
        SafeMap<String, MnoPod> misure = misureAzienda.getMisure();
        GetPnoStrategyTest.assertEquals(20, misure.size());
        Iterable pnoResidue = status.getPnoSospesi();
        GetPnoStrategyTest.assertEquals(0, pnoResidue.size());
    }

    public void testExecutePnoPdo() {
        TestConfiguration configuration = new TestConfiguration();
        Reseller tutti = new Reseller("*", "tutti", null, false, false);
        this.strategy = new GetPnoStrategy(2016, Month.JUNE, "", this.dao, this.talkManager);
        TestServiceStatus status = new TestServiceStatus(configuration);
        status.setPno(new MappaMisureAzienda(TipoEstrazione.TUTTI, tutti, this.talkManager, this.dao));
        DefaultPodMap pods = new DefaultPodMap();
        Date startDate = new Date(0L);
        Pod pod = new Pod("pod", true, 0, "azienda", startDate, null, false, false, false, startDate, null, "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
        pods.add(pod);
        status.setPodMap(pods);
        ErrorWrapper error = new ErrorWrapper("pdo", ErroriElaborazione.PDO_NOTFOUND);
        DefaultSafeListMap<String, Pdo> pdos = new DefaultSafeListMap<String, Pdo>(error);
        RilMese rilMese = new RilMese("pod", 2016, Month.JUNE, "");
        Pdo pdo = new Pdo(null, false, rilMese, null, null, "dispatcher", null, null, null, "", "", null, "");
        pdos.add(pdo);
        status.setPdo(pdos);
        this.insertPnosPeriodoTestExecutePnoPdo();
        this.strategy.execute(status);
        List<Sentence> sentences = this.talkManager.getSentences();
        GetPnoStrategyTest.assertEquals(1, sentences.size());
        Sentence sentence = sentences.get(0);
        GetPnoStrategyTest.assertEquals("pod.orarioConTutteMisure", sentence.getDescription());
    }

    private void insertPnosPeriodoTestExecutePnoPdo() {
        ArrayList<Mno> pnos = new ArrayList<Mno>();
        Date dateJune = CalendarTools.getDate(2016, Month.JUNE, 30);
        Misura misuraJune = PrebillingTestHelper.newMisura(dateJune, false, 3);
        HashMap<String, Map<String, String>> datipod = new HashMap<String, Map<String, String>>();
        datipod.put("DatiPdp", new HashMap());
        Mno pno = new Mno(null, null, "pod", misuraJune, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, "");
        pnos.add(pno);
        this.dao.insertPnosPeriodo(pnos);
    }

    private void insertPnosPeriodoInMisureDao() {
        Mno pno;
        ArrayList<Mno> pnos = new ArrayList<Mno>();
        Date dateJune = CalendarTools.getDate(2016, Month.JUNE, 30);
        Date dateMay = CalendarTools.getDate(2016, Month.MAY, 30);
        Misura misuraMay = PrebillingTestHelper.newMisura(dateMay, false, 3);
        Misura misuraJune = PrebillingTestHelper.newMisura(dateJune, false, 3);
        HashMap<String, Map<String, String>> datipod = new HashMap<String, Map<String, String>>();
        datipod.put("DatiPdp", new HashMap());
        int index = 0;
        while (index < 5) {
            pno = new Mno(null, null, "pod" + (index + 10), misuraJune, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, "");
            pnos.add(pno);
            ++index;
        }
        index = 5;
        while (index < 10) {
            pno = new Mno(null, null, "pod" + (index + 10), misuraMay, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, "");
            pnos.add(pno);
            ++index;
        }
        Mno pnoSenzaPod = new Mno(null, null, "nonce", misuraJune, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, "");
        pnos.add(pnoSenzaPod);
        Mno pnoOrario = new Mno(null, null, "pod4", misuraJune, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, "");
        pnos.add(pnoOrario);
        this.dao.insertPnosPeriodo(pnos);
    }

    private void insertPnosPeriodoInMisureDaoTestExecuteDate() {
        Mno pno;
        ArrayList<Mno> pnos = new ArrayList<Mno>();
        Date dateJune = CalendarTools.getDate(2016, Month.JUNE, 30);
        Date dateMay = CalendarTools.getDate(2016, Month.MAY, 30);
        Misura misuraMay = PrebillingTestHelper.newMisura(dateMay, false, 3);
        Misura misuraJune = PrebillingTestHelper.newMisura(dateJune, false, 3);
        HashMap<String, Map<String, String>> datipod = new HashMap<String, Map<String, String>>();
        datipod.put("DatiPdp", new HashMap());
        int index = 0;
        while (index < 5) {
            pno = new Mno(null, null, "pod" + (index + 10), misuraJune, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, "");
            pnos.add(pno);
            ++index;
        }
        index = 5;
        while (index < 10) {
            pno = new Mno(null, null, "pod" + (index + 10), misuraMay, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, "");
            pnos.add(pno);
            ++index;
        }
        this.dao.insertPnosPeriodo(pnos);
    }

    private void insertPnosTecnicheInMisureDaoTestExecuteDate() {
        Mno pno;
        ArrayList<Mno> pnos = new ArrayList<Mno>();
        Date dateJune = CalendarTools.getDate(2016, Month.JUNE, 30);
        Date dateMay = CalendarTools.getDate(2016, Month.MAY, 30);
        Misura misuraMay = PrebillingTestHelper.newMisura(dateMay, false, 3);
        Misura misuraJune = PrebillingTestHelper.newMisura(dateJune, false, 3);
        HashMap<String, Map<String, String>> datipod = new HashMap<String, Map<String, String>>();
        datipod.put("DatiPdp", new HashMap());
        int index = 20;
        while (index < 25) {
            pno = new Mno(null, null, "pod" + (index + 10), misuraJune, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, "");
            pnos.add(pno);
            ++index;
        }
        index = 25;
        while (index < 30) {
            pno = new Mno(null, null, "pod" + (index + 10), misuraMay, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, "");
            pnos.add(pno);
            ++index;
        }
        PrebillingTestHelper.fillMno(pnos);
        this.dao.insertPnosTecniche(pnos);
    }
}

