/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategyHelper;
import java.text.DateFormat;
import java.util.List;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.AbstractSentence;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.RecordSafeListMap;

public class GetPnoStrategy
implements ServiceStrategy {
    private final int anno;
    private final Month mese;
    private final String filtroPod;
    private final MisureDao misureDao;
    private final TalkManager talkManager;

    public GetPnoStrategy(int anno, Month mese, String filtroPod, MisureDao misureDao, TalkManager talkManager) {
        this.anno = anno;
        this.mese = mese;
        this.filtroPod = filtroPod;
        this.misureDao = misureDao;
        this.talkManager = talkManager;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        PodMap pods = status.getPodMap();
        RecordSafeListMap<String, Pdo> pdos = status.getPdoMap();
        MappaMisureAzienda misureAzienda = this.getPnos(status, pods, pdos);
        status.setPno(misureAzienda);
        return true;
    }

    private MappaMisureAzienda getPnos(ServiceStatus status, PodMap podMap, SafeListMap<String, Pdo> pdo) {
        MappaMisureAzienda pno = status.getPnos();
        List<Mno> pnoPeriodoMisure = this.misureDao.getPnoPeriodo(this.anno, this.mese, this.filtroPod, StrategyHelper.STATI);
        this.fixStimate(status, podMap, pnoPeriodoMisure);
        pno.addMisurePeriodo(status, pnoPeriodoMisure, podMap, pdo);
        List<Mno> pnoTecnicheMisure = this.misureDao.getPnoTecniche(this.anno, this.mese, this.filtroPod, StrategyHelper.STATI);
        pno.addMisureTecniche(status, pnoTecnicheMisure, podMap, pdo);
        List<Mno> pnoSospette = this.misureDao.getPnoSospette(this.anno, this.mese, this.filtroPod);
        pno.addMisureSospette(status, pnoSospette, podMap, pdo);
        List<Mno> pdos2gr = this.misureDao.getPdo2GRFinoMese(this.anno, this.mese, this.filtroPod, StrategyHelper.STATI);
        pno.addPdo2GR(status, pdos2gr, podMap, pdo);
        return pno;
    }

    private void fixStimate(ServiceStatus status, PodMap podMap, List<Mno> misure) {
        int index = 0;
        while (index < misure.size() - 1) {
            Mno next;
            String codicePod;
            Mno mno = misure.get(index);
            Misura misura = mno.getMisura();
            if (misura.isStimata() && (codicePod = mno.getCodicePod()).equals((next = misure.get(index + 1)).getCodicePod())) {
                MnoResult result;
                AbstractSentence sentence;
                try {
                    Pod pod = podMap.get(codicePod);
                    String azienda = pod.getAzienda();
                    mno.setCdaziend(azienda);
                    ErroriElaborazione errore = ErroriElaborazione.STIMATA_ESCLUSA;
                    String message = errore.getMessage();
                    sentence = new Message("acquisizione.letture", message);
                    sentence.addParam(String.valueOf(codicePod) + " / " + azienda);
                    DateFormat formatter = StrategyCommonHelper.getStandardDateFormat();
                    sentence.addParam(formatter.format(mno.getDataMisura()));
                    String descrizione = this.talkManager.getMessage(sentence);
                    result = new MnoResult(mno, errore, descrizione);
                    status.addPnoEscluso(result);
                }
                catch (DataNotFoundException exc) {
                    String message = exc.getMessage();
                    String key = exc.getKey();
                    sentence = new Warning("acquisizione.letture", message);
                    sentence.addParam(key);
                    this.talkManager.addSentence(sentence);
                    String descrizione = this.talkManager.getMessage(sentence);
                    ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                    result = new MnoResult(mno, errore, descrizione);
                    status.addPnoSospeso(result);
                }
                misure.remove(index);
                --index;
            }
            ++index;
        }
    }
}

