/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ErrorWrapper;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategyHelper;
import java.util.List;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.structures.safe.DefaultSafeListMap;

public class GetPdoLettureStrategy
implements ServiceStrategy {
    private final int anno;
    private final Month mese;
    private final String reseller;
    private final String filtroPod;
    private final MisureDao misureDao;

    public GetPdoLettureStrategy(int anno, Month mese, String reseller, String filtroPod, MisureDao dao) {
        this.anno = anno;
        this.mese = mese;
        this.reseller = reseller;
        this.filtroPod = filtroPod;
        this.misureDao = dao;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ErrorWrapper error = new ErrorWrapper("pdo", ErroriElaborazione.PDO_NOTFOUND);
        DefaultSafeListMap<String, Pdo> pdo = new DefaultSafeListMap<String, Pdo>(error);
        List<Pdo> pdoList = this.misureDao.getPdoFinoMese(this.anno, this.mese, this.reseller, this.filtroPod, StrategyHelper.STATI);
        pdo.addAll(pdoList);
        status.setPdo(pdo);
        return true;
    }
}

