/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.TestServiceStatus;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.services.letture.GetAllPodMockGiadaDao;
import biz.elabor.prebilling.services.riallineamento.GetAllPodStrategy;
import junit.framework.TestCase;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;

public class GetAllPodStrategyTest
extends TestCase {
    private GetAllPodStrategy strategy;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        GetAllPodMockGiadaDao dao = new GetAllPodMockGiadaDao();
        TestConfiguration configuration = new TestConfiguration();
        this.strategy = new GetAllPodStrategy(2016, Month.JUNE, configuration, dao);
    }

    public void testExecute() throws DataNotFoundException {
        TestConfiguration configuration = new TestConfiguration();
        TestServiceStatus status = new TestServiceStatus(configuration);
        this.strategy.execute(status);
        DefaultPodMap podMap = status.getAllPods();
        GetAllPodStrategyTest.assertEquals(3, podMap.size());
        Pod pod = podMap.get("1");
        GetAllPodStrategyTest.assertEquals("1", pod.getCodice());
        GetAllPodStrategyTest.assertEquals(1, pod.getSpecificheTecniche().size());
        pod = podMap.get("2");
        GetAllPodStrategyTest.assertEquals("2", pod.getCodice());
        GetAllPodStrategyTest.assertEquals(2, pod.getSpecificheTecniche().size());
        pod = podMap.get("3");
        GetAllPodStrategyTest.assertEquals("3", pod.getCodice());
        GetAllPodStrategyTest.assertEquals(0, pod.getSpecificheTecniche().size());
    }
}

