/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.MnoPod;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.statopod.NullReferenceHandler;
import biz.elabor.prebilling.services.common.statopod.NullStatoPodChecker;
import biz.elabor.prebilling.services.letture.MisuraMno;
import biz.elabor.prebilling.services.letture.MisureAzienda;
import biz.elabor.prebilling.services.letture.MnoDateComparator;
import biz.elabor.prebilling.services.volture.VnoStatoPodHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.safe.SafeMap;

public class ExportVoltureVirtualiStrategy
implements ServiceStrategy {
    private final VnoStatoPodHandler statoPodHandler;
    private final TalkManager talkManager;
    private final PrebillingConfiguration configuration;

    public ExportVoltureVirtualiStrategy(MisureDao misureDao, TalkManager talkManager, PrebillingConfiguration configuration) {
        this.talkManager = talkManager;
        this.configuration = configuration;
        this.statoPodHandler = new VnoStatoPodHandler(misureDao);
    }

    @Override
    public boolean execute(ServiceStatus status) {
        for (Map.Entry<String, PraticaVolo> entry : status.getVirtualPiv().entrySet()) {
            PraticaVolo pratica;
            Date data;
            String codicePod = entry.getKey();
            Mno mno = ExportVoltureVirtualiStrategy.getFirstMno(codicePod, status, data = (pratica = entry.getValue()).getSpecificaTecnica().getData());
            if (mno == null) continue;
            mno.setDataVoltura(data);
            String cpGestore = pratica.getCodPratAtt();
            try {
                StatusTransaction transaction = new StatusTransaction(null, status, this.configuration);
                NullStatoPodChecker checker = new NullStatoPodChecker();
                NullReferenceHandler referenceHandler = new NullReferenceHandler();
                MisuraMno misuraMno = new MisuraMno(null, mno);
                this.statoPodHandler.handleStato(misuraMno, "AE1", "PNO", cpGestore, data, data, null, transaction, checker, referenceHandler);
                transaction.commit(codicePod);
            }
            catch (DataNotFoundException exc) {
                String message = exc.getMessage();
                String key = exc.getKey();
                Message sentence = new Message("export.vnovirtuali.strategy", message);
                sentence.setCss("alert-danger");
                sentence.addParam(key);
                sentence.addParam(codicePod);
                this.talkManager.addSentence(sentence);
                String description = this.talkManager.getMessage(sentence);
                status.suspendPod(codicePod, description);
            }
            catch (Exception exc) {
                String description = StrategyHelper.handleRuntimeException(exc, codicePod, "export.vnovirtuali.strategy", this.talkManager, status);
                status.suspendPod(codicePod, description);
            }
        }
        return true;
    }

    private static Mno getFirstMno(String codicePod, ServiceStatus status, Date data) {
        Mno mno = null;
        MappaMisureAzienda mappaMisureAzienda = status.getPnos();
        for (Map.Entry entry : mappaMisureAzienda.entrySet()) {
            MisureAzienda misureAzienda = (MisureAzienda)entry.getValue();
            SafeMap<String, MnoPod> misure = misureAzienda.getMisure();
            try {
                MnoPod mnoPod = (MnoPod)misure.get(codicePod);
                Collection<Mno> misurePeriodo = mnoPod.getMisurePno();
                Collection<Mno> misureTecniche = mnoPod.getMisureTecniche();
                mno = ExportVoltureVirtualiStrategy.getFirstMno(misurePeriodo, misureTecniche, data);
            }
            catch (DataNotFoundException dataNotFoundException) {
                // empty catch block
            }
        }
        return mno;
    }

    private static Mno getFirstMno(Collection<Mno> misurePeriodo, Collection<Mno> misureTecniche, Date data) {
        ArrayList<Mno> misure = new ArrayList<Mno>(misurePeriodo);
        misure.addAll(misureTecniche);
        MnoDateComparator comparator = new MnoDateComparator();
        Collections.sort(misure, comparator);
        return ExportVoltureVirtualiStrategy.getFirstMno(misure, data);
    }

    private static Mno getFirstMno(List<Mno> misure, Date data) {
        Mno mno = null;
        Iterator<Mno> iterator = misure.iterator();
        while (mno == null && iterator.hasNext()) {
            Mno misura = iterator.next();
            Date dataMisura = misura.getDataMisura();
            if (dataMisura.before(data)) continue;
            mno = misura;
        }
        return mno;
    }
}

