/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.common.LetstdPrintMapWriter;
import biz.elabor.prebilling.util.MapWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ExportSwitchOutStrategy
implements ServiceStrategy {
    private static final String SWITCHOUT_HEADER = "@16SWITCHOUT";
    private final Funzionalita funzionalita;
    private final int anno;
    private final Month mese;
    private final PrebillingConfiguration configuration;
    private final TalkManager talkManager;
    private final DateFormat timestampFormat;

    public ExportSwitchOutStrategy(Funzionalita funzionalita, int anno, Month mese, PrebillingConfiguration configuration, TalkManager talkManager) {
        this.funzionalita = funzionalita;
        this.anno = anno;
        this.mese = mese;
        this.configuration = configuration;
        this.talkManager = talkManager;
        this.timestampFormat = StrategyCommonHelper.getTimestampFormat();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok;
        try {
            Map<String, MapWriter> xmlMap = status.getSwitchoutXmlWriter();
            String idEsecuzione = status.getIdEsecuzione();
            this.printXml(xmlMap, idEsecuzione);
            Map<String, MapWriter> csvMap = status.getSwitchoutCsvWriter();
            this.printCsv(csvMap, "switchout", idEsecuzione);
            Map<String, MapWriter> rettMap = status.getRettificheSwitchoutCsvWriter();
            this.printCsv(rettMap, "rettifiche-switchout", idEsecuzione);
            MapWriter rettificheSwitchoutDispatcher = status.getRettificheSwitchoutDispatcher();
            this.printLetStd(idEsecuzione, rettificheSwitchoutDispatcher);
            ok = true;
        }
        catch (FileNotFoundException exc) {
            Message sentence = new Message("export.switchout", "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getMessage());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private void printLetStd(String idEsecuzione, MapWriter rettificheSwitchoutDispatcher) throws FileNotFoundException {
        LetstdPrintMapWriter writer = new LetstdPrintMapWriter(this.anno, this.mese, this.configuration);
        Date timestamp = new Date();
        writer.printDispatcher(idEsecuzione, rettificheSwitchoutDispatcher, "so-", "", timestamp);
    }

    private void printXml(Map<String, MapWriter> serviceMap, String idEsecuzione) throws FileNotFoundException {
        for (Map.Entry<String, MapWriter> entry : serviceMap.entrySet()) {
            String key = entry.getKey();
            String[] split = key.split("\\|");
            String prefix = String.valueOf(split.length > 1 ? String.valueOf(split[1]) + "-" : "") + "switchout";
            MapWriter mapWriter = entry.getValue();
            this.printXml(prefix, mapWriter, idEsecuzione);
        }
    }

    private void printXml(String prefix, MapWriter mapWriter, String idEsecuzione) throws FileNotFoundException {
        File folder = ConfigurationHelper.getMiddlewareTmpFolder(this.configuration, idEsecuzione, this.funzionalita);
        String dateStr = this.timestampFormat.format(new Date());
        for (Map.Entry<String, List<String>> entry : mapWriter.entrySet()) {
            String codicePod = entry.getKey();
            Class<?> strategyClass = this.getClass();
            String className = strategyClass.getSimpleName();
            PrebillingContext.setContext(className, "pod: " + codicePod);
            String fileName = String.valueOf(prefix) + "-" + codicePod + "-" + dateStr + ".xml";
            File file = new File(folder, fileName);
            Throwable throwable = null;
            Object var14_15 = null;
            try (PrintWriter printWriter = new PrintWriter(file);){
                for (String row : entry.getValue()) {
                    printWriter.print(row);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void printCsv(Map<String, MapWriter> serviceMap, String genPrefix, String idEsecuzione) throws FileNotFoundException {
        for (Map.Entry<String, MapWriter> entry : serviceMap.entrySet()) {
            String key = entry.getKey();
            String[] split = key.split("\\|");
            String azienda = split[0];
            String prefix = String.valueOf(split.length > 1 ? String.valueOf(split[1]) + "-" : "") + genPrefix;
            String destinazione = split.length > 2 ? split[2] : "";
            MapWriter mapWriter = entry.getValue();
            this.printCsv(azienda, destinazione, prefix, mapWriter, idEsecuzione);
        }
    }

    private void printCsv(String azienda, String destinazione, String prefix, MapWriter mapWriter, String idEsecuzione) throws FileNotFoundException {
        File resellerFolder = ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, this.funzionalita, destinazione);
        String timestamp = this.timestampFormat.format(new Date());
        String fileName = String.valueOf(prefix) + "-" + azienda + "-" + this.anno + "-" + this.mese.getIndex() + "-" + timestamp + ".txt";
        File file = new File(resellerFolder, fileName);
        if (!mapWriter.isEmpty()) {
            try (PrintWriter printWriter = new PrintWriter(file);){
                printWriter.println(SWITCHOUT_HEADER);
                mapWriter.flush(printWriter);
            }
        }
    }
}

