/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Scarto;
import biz.elabor.prebilling.services.ServiceStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.text.Format;

public class ExportLogScartiStrategy
implements ServiceStrategy {
    private int anno;
    private Month mese;
    private PrebillingConfiguration configuration;
    private TalkManager talkManager;
    private Funzionalita funzionalita;
    private static final DecimalFormat FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "###,##0.000");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public ExportLogScartiStrategy(Funzionalita funzionalita, int anno, Month mese, PrebillingConfiguration configuration, TalkManager talkManager) {
        this.funzionalita = funzionalita;
        this.anno = anno;
        this.mese = mese;
        this.configuration = configuration;
        this.talkManager = talkManager;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok = true;
        List<Scarto> scarti = status.getScarti();
        if (!scarti.isEmpty()) {
            String idEsecuzione = status.getIdEsecuzione();
            ok = this.exportLog(scarti, idEsecuzione);
        }
        return ok;
    }

    public boolean exportLog(List<Scarto> scarti, String idEsecuzione) {
        boolean ok;
        File folder = ConfigurationHelper.getDispatcherTmpLettureFolder(this.configuration, idEsecuzione, this.funzionalita);
        String fileName = "scarti-" + this.anno + "-" + this.mese.getIndex() + ".txt";
        File file = new File(folder, fileName);
        try {
            PrintWriter writer = new PrintWriter(file);
            for (Scarto scarto : scarti) {
                String pod = scarto.getCodice();
                PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + pod);
                Date data = scarto.getData();
                String dataFormattata = DATE_FORMAT.format(data);
                this.anno = scarto.getAnno();
                this.mese = scarto.getMese();
                String F1 = FORMAT.format(scarto.getF1());
                String F2 = FORMAT.format(scarto.getF2());
                String F3 = FORMAT.format(scarto.getF3());
                writer.println(String.valueOf(pod) + ";" + dataFormattata + ";" + this.anno + ";" + this.mese.getIndex() + ";" + F1 + ";" + F2 + ";" + F3);
            }
            writer.close();
            ok = true;
        }
        catch (FileNotFoundException e2) {
            Warning sentence = new Warning("export.scarti.strategy", "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(file.getAbsolutePath());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }
}

