/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.TestServiceStatus;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Rno;
import biz.elabor.prebilling.services.letture.PrebillingTestHelper;
import biz.elabor.prebilling.services.rettifiche.ExportLogRettifiche;
import biz.elabor.test.TextTestHelper;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.junit.Test;

public class ExportLogRnoTest
extends TestCase {
    private static final String[] CONTENT = new String[]{"pod1;2016-10-05;+000000000,000;+000000000,000;+000000000,000;+000000000,000;+000000000,000;+000000000,000;+000000000,000;+000000000,000;+000000000,000;", "pod1;2016-10-15;+000000000,000;+000000000,000;+000000000,000;+000000000,000;+000000000,000;+000000000,000;+000000000,000;+000000000,000;+000000000,000;", "pod2;2016-10-05;+000000000,000;+000000000,000;+000000000,000;+000000000,000;+000000000,000;+000000000,000;+000000000,000;+000000000,000;+000000000,000;"};

    @Test
    public void testExecute() throws UnsupportedEncodingException, IOException {
        TestConfiguration configuration = new TestConfiguration();
        File folder = ConfigurationHelper.getDispatcherTmpLettureFolder(configuration, null, Funzionalita.LETTURE);
        TextTestHelper.clearFolder(folder);
        TalkManager talkManager = new TalkManager();
        ExportLogRettifiche strategy = new ExportLogRettifiche(2016, Month.OCTOBER, configuration, talkManager);
        TestServiceStatus status = new TestServiceStatus(configuration);
        ArrayList<Rno> rnos = new ArrayList<Rno>();
        HashMap<String, Map<String, String>> datipod = new HashMap<String, Map<String, String>>();
        datipod.put("DatiPdp", new HashMap());
        Misura misura11 = PrebillingTestHelper.newMisura(CalendarTools.getDate(2016, Month.OCTOBER, 5), false, 3);
        rnos.add(new Rno(new Mno(null, "RNO", "pod1", misura11, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, ""), null, false, false, false, false));
        Misura misura12 = PrebillingTestHelper.newMisura(CalendarTools.getDate(2016, Month.OCTOBER, 15), false, 3);
        rnos.add(new Rno(new Mno(null, "RNO", "pod1", misura12, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, ""), null, false, false, false, false));
        Misura misura2 = PrebillingTestHelper.newMisura(CalendarTools.getDate(2016, Month.OCTOBER, 5), false, 3);
        rnos.add(new Rno(new Mno(null, "RNO", "pod2", misura2, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, ""), null, false, false, false, false));
        status.addRno(rnos);
        DefaultPodMap pods = new DefaultPodMap();
        pods.add(new Pod("pod1", false, 0, "azienda1", null, null, false, false, false, null, null, "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null));
        pods.add(new Pod("pod2", false, 0, "azienda1", null, null, false, false, false, null, null, "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null));
        status.setPodMap(pods);
        boolean ok = strategy.execute(status);
        ExportLogRnoTest.assertTrue(ok);
        TextTestHelper.checkTextFile(folder, "rettifiche-nonorarie-2016-10-(\\d*).txt", "UTF-8", CONTENT);
    }

    @Test
    public void testExecuteNoFile() {
        TestConfiguration configuration = new TestConfiguration();
        File folder = ConfigurationHelper.getDispatcherTmpLettureFolder(configuration, null, Funzionalita.LETTURE);
        TextTestHelper.clearFolder(folder);
        TalkManager talkManager = new TalkManager();
        ArrayList<Rno> rnos = new ArrayList<Rno>();
        TestServiceStatus status = new TestServiceStatus(configuration);
        status.addRno(rnos);
        ExportLogRettifiche strategy = new ExportLogRettifiche(2016, Month.OCTOBER, configuration, talkManager);
        boolean ok = strategy.execute(status);
        ExportLogRnoTest.assertTrue(ok);
        File[] listFiles = folder.listFiles();
        ExportLogRnoTest.assertEquals(0, listFiles.length);
    }
}

