/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.model.misure.Mno;
import java.util.Date;
import org.homelinux.elabor.arrays.Condition;
import org.homelinux.elabor.calendar.ElaborCalendar;

class ExclusionCondition
implements Condition<Mno> {
    private final Date fineMese;

    public ExclusionCondition(Date dataPratica) {
        ElaborCalendar calendar = new ElaborCalendar(dataPratica);
        if (calendar.getGiorno() == 1) {
            calendar.addGiorni(-1);
            this.fineMese = calendar.getDate();
        } else {
            this.fineMese = null;
        }
    }

    @Override
    public boolean check(Mno item) {
        return ExclusionCondition.rnoCondition(item) && this.letturaPeriodoCondition(item);
    }

    private boolean letturaPeriodoCondition(Mno item) {
        return this.fineMese != null && this.fineMese.equals(item.getDataMisura());
    }

    private static boolean rnoCondition(Mno item) {
        return !item.getCodiceFlusso().startsWith("RNO");
    }
}

