/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.InvalidCurvaRilevazioniException;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Lettura;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.model.misure.RilQuartoType;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.letture.FixLetturaSegnanti;
import biz.elabor.prebilling.services.tariffe.CalendarException;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.InvalidSegnantiException;
import biz.elabor.prebilling.services.tariffe.LetturaSegnanti;
import biz.elabor.prebilling.services.tariffe.SmisException;
import biz.elabor.prebilling.services.tariffe.TariffeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.TappoIterator;

public class ConsumiHelper {
    private static final Iterable<StatoMisure> STATI_PDO2GR = Arrays.asList(StatoMisure.VALIDATO, StatoMisure.SOSPESO, StatoMisure.ESCLUSO, StatoMisure.ELABORATO);
    private static final Mno TAPPO = TariffeHelper.buildMnoTappo();

    public static double updateK(double kComplessivo, double kNuovo) {
        return kNuovo == 0.0 ? kComplessivo : (kComplessivo == 0.0 || kComplessivo == kNuovo ? kNuovo : -1.0);
    }

    public static String getKMessage(double k2) {
        return k2 == -1.0 ? " (variazione coeff. K nel periodo di osservazione)" : " (KA=" + k2 + " KR=" + k2 + " KP=" + k2 + ")";
    }

    public static RilQuarto createRilQuarto(int index, double attiva, double kA, RilQuartoType type) {
        return new RilQuarto(index, null, null, attiva, null, null, null, kA, type);
    }

    public static void fixMissingDays(RilMese rilMese, String codicePod, Date inizioConsumi, Date fineConsumi, String pivaDistr, String codComIst, String codiceOfferta, List<Mno> mnoList, Date dataLetPre, int annoRif, Month meseRif, ServiceStatus status, Destinatari destinatari, MisureDao misureDao, PrebillingConfiguration configuration, boolean excludeStimatoFineConsumi) throws DataNotFoundException, CalendarException, CalendarNotFoundException, SmisException, InvalidSegnantiException, InvalidCurvaRilevazioniException {
        Date fineMeseRif;
        List<Mno> misurePdo;
        Mno mno;
        Date dateBefore = null;
        Date expectedDate = inizioConsumi;
        ArrayList<RilGiorno> missingDays = new ArrayList<RilGiorno>();
        for (RilGiorno rilGiorno : rilMese) {
            Date date = rilGiorno.getDate();
            if (date.equals(expectedDate)) {
                expectedDate = CalendarTools.nextDay(expectedDate);
            } else if (!date.before(inizioConsumi)) {
                dateBefore = dateBefore == null ? CalendarTools.previousDay(expectedDate) : dateBefore;
                double[] consumiAfter = ConsumiHelper.getConsumiFasce(rilGiorno, codicePod, codiceOfferta, status);
                List<RilGiorno> newMissingDays = ConsumiHelper.buildMissingDays(codicePod, dateBefore, date, consumiAfter, null, pivaDistr, codComIst, mnoList, dataLetPre, misureDao, destinatari, status, configuration);
                missingDays.addAll(newMissingDays);
                expectedDate = CalendarTools.nextDay(date);
            }
            if (!date.before(fineConsumi)) break;
            dateBefore = date;
        }
        if (!expectedDate.after(fineConsumi) && (mno = ConsumiHelper.findFirst(expectedDate, misurePdo = misureDao.getPdo2GRDaA(codicePod, fineConsumi, fineMeseRif = CalendarTools.getEndDate(annoRif, meseRif), destinatari, STATI_PDO2GR), mnoList)) != null) {
            LetturaSegnanti misura;
            double[] consumiAfter;
            RilGiorno rilGiorno;
            Date dataMisuraSuccessiva = mno.getDataMisura();
            ElaborCalendar calendar = new ElaborCalendar(dataMisuraSuccessiva);
            int annoMisuraSucc = calendar.getAnno();
            Month meseMisuraSucc = calendar.getMese();
            try {
                Pdo pdo = misureDao.getPdo(codicePod, annoMisuraSucc, meseMisuraSucc, null, StrategyHelper.STATI_ALL);
                RilMese rilMeseSuccessivo = pdo.getRilMese();
                rilGiorno = rilMeseSuccessivo.getRilGiorno(dataMisuraSuccessiva);
            }
            catch (DataNotFoundException exc) {
                rilGiorno = null;
            }
            if (rilGiorno != null && rilGiorno.getDate().equals(dataMisuraSuccessiva)) {
                consumiAfter = ConsumiHelper.getConsumiFasce(rilGiorno, codicePod, codiceOfferta, status);
                misura = mno;
            } else {
                consumiAfter = new double[3];
                dataMisuraSuccessiva = CalendarTools.nextDay(dataMisuraSuccessiva);
                misura = new FixLetturaSegnanti(mno, dataMisuraSuccessiva);
            }
            List<RilGiorno> newMissingDays = ConsumiHelper.buildMissingDays(codicePod, dateBefore, dataMisuraSuccessiva, consumiAfter, misura, pivaDistr, codComIst, mnoList, dataLetPre, misureDao, destinatari, status, configuration);
            missingDays.addAll(newMissingDays);
        }
        ConsumiHelper.addMissingDays(rilMese, missingDays);
        if (excludeStimatoFineConsumi) {
            ConsumiHelper.removeStimatoFineConsumi(rilMese);
        }
    }

    private static Mno findFirst(Date expectedDate, List<Mno> misurePdo, List<Mno> mnoList) {
        Mno mno = null;
        TappoIterator<Mno> pdoIterator = new TappoIterator<Mno>(misurePdo, TAPPO);
        ArrayList misurePno = mnoList == null ? new ArrayList() : mnoList;
        TappoIterator<Mno> pnoIterator = new TappoIterator<Mno>(misurePno, TAPPO);
        Mno pdo = (Mno)pdoIterator.next();
        Mno pno = (Mno)pnoIterator.next();
        Date pdoDate = pdo.getDataMisura();
        Date pnoDate = pno.getDataMisura();
        Date endDate = TAPPO.getDataMisura();
        while (pdoDate.before(endDate) || pnoDate.before(endDate)) {
            Mno candidate;
            if (!pdoDate.after(pnoDate)) {
                candidate = pdo;
                pdo = (Mno)pdoIterator.next();
                if (pdoDate.equals(pnoDate)) {
                    pno = (Mno)pnoIterator.next();
                }
            } else {
                candidate = pno;
                pno = (Mno)pnoIterator.next();
            }
            if (!candidate.getDataMisura().before(expectedDate)) {
                mno = candidate;
                break;
            }
            pdoDate = pdo.getDataMisura();
            pnoDate = pno.getDataMisura();
        }
        return mno;
    }

    private static void removeStimatoFineConsumi(RilMese rilMese) throws InvalidCurvaRilevazioniException {
        if (!rilMese.isEmpty()) {
            Date fineMese = rilMese.getPeriod().getLastDate();
            int lastIndex = rilMese.size() - 1;
            RilGiorno rilGiorno = (RilGiorno)rilMese.get(lastIndex);
            if (ConsumiHelper.isStimatoFineConsumi(rilGiorno, fineMese)) {
                throw new InvalidCurvaRilevazioniException("last.stimata", fineMese, true);
            }
        }
    }

    private static void addMissingDays(RilMese rilMese, List<RilGiorno> missingDays) {
        Date endDate = rilMese.getPeriod().getLastDate();
        for (RilGiorno missingDay : missingDays) {
            Date missingDate = missingDay.getDate();
            if (missingDate.after(endDate)) continue;
            int index = ConsumiHelper.getIndex(rilMese, missingDate);
            rilMese.add(index, missingDay);
        }
    }

    private static boolean isStimatoFineConsumi(RilGiorno missingDay, Date fineConsumi) {
        Date missingDate = missingDay.getDate();
        return missingDate.equals(fineConsumi) && ConsumiHelper.isStimato(missingDay);
    }

    private static boolean isStimato(RilGiorno rilGiorno) {
        boolean stimato = false;
        for (RilQuarto rilQuarto : rilGiorno) {
            if (!rilQuarto.getType().equals((Object)RilQuartoType.STIMATO)) continue;
            stimato = true;
            break;
        }
        return stimato;
    }

    private static int getIndex(RilMese rilMese, Date missingDate) {
        int index = 0;
        while (index < rilMese.size()) {
            if (((RilGiorno)rilMese.get(index)).getDate().after(missingDate)) break;
            ++index;
        }
        return index;
    }

    private static double[] getConsumiFasce(RilGiorno rilGiorno, String codicePod, String codiceOfferta, ServiceStatus status) throws CalendarNotFoundException {
        Date date = rilGiorno.getDate();
        Date prev = CalendarTools.previousDay(date);
        FasciaOraria[] fascePeriodo = TariffeHelper.getFasce(codicePod, codiceOfferta, prev, date, status);
        double[] consumiFasce = new double[FasciaOraria.values().length];
        for (RilQuarto rilQuarto : rilGiorno) {
            int index = rilQuarto.getIndex();
            int ora = index / 4;
            FasciaOraria fascia = fascePeriodo[ora];
            Double attiva = rilQuarto.getAttiva();
            int n2 = fascia.ordinal();
            consumiFasce[n2] = consumiFasce[n2] + (attiva == null ? 0.0 : attiva);
        }
        return consumiFasce;
    }

    private static List<RilGiorno> buildMissingDays(String codicePod, Date dateBefore, Date dateAfter, double[] consumiAfter, LetturaSegnanti misura, String pivaDistr, String codComIst, List<Mno> mnoList, Date dataLetPre, MisureDao misureDao, Destinatari destinatari, ServiceStatus status, PrebillingConfiguration configuration) throws CalendarException, DataNotFoundException, CalendarNotFoundException, SmisException, InvalidSegnantiException {
        LetturaSegnanti ultimaLettura = ConsumiHelper.getUltimaLettura(codicePod, dataLetPre, dateBefore, destinatari, misureDao);
        List<Mno> misure = misureDao.getPdo2GRDaA(codicePod, dateBefore, dateAfter, destinatari, STATI_PDO2GR);
        List<LetturaSegnanti> letture = ConsumiHelper.buildLetture(misure, ultimaLettura, misura);
        return ConsumiHelper.buildMissingDays(codicePod, dateBefore, dateAfter, consumiAfter, pivaDistr, codComIst, mnoList, status, configuration, letture);
    }

    public static List<RilGiorno> buildMissingDays(String codicePod, Date dateBefore, Date dateAfter, double[] consumiAfter, String pivaDistr, String codComIst, List<Mno> mnoList, ServiceStatus status, PrebillingConfiguration configuration, List<LetturaSegnanti> letture) throws CalendarException, DataNotFoundException, CalendarNotFoundException, InvalidSegnantiException, SmisException {
        Iterator<Mno> smisIterator = TariffeHelper.buildSmisIterator(mnoList);
        Mno smontaggio = smisIterator.next();
        Date dataSmontaggio = smontaggio.getDataMisura();
        Date dataIniziale = null;
        ArrayList<RilGiorno> missingDays = new ArrayList<RilGiorno>();
        Iterator<LetturaSegnanti> misureIterator = TariffeHelper.buildLettureIterator(letture);
        LetturaSegnanti misura = misureIterator.next();
        Date dataMisura = misura.getDataMisura();
        LetturaSegnanti misuraBefore = null;
        while (!dataMisura.after(dateAfter)) {
            Mno montaggio;
            List<RilGiorno> newMissingDays;
            double ka;
            if (!dataMisura.after(dataSmontaggio)) {
                if (dataMisura.equals(dateBefore)) {
                    if (misuraBefore == null || !misuraBefore.isSmisMontaggio()) {
                        misuraBefore = misura;
                    }
                    dataIniziale = CalendarTools.nextDay(dataMisura);
                }
                if (dataMisura.equals(dateAfter) && misuraBefore != null) {
                    Date dataFinale = CalendarTools.previousDay(dateAfter);
                    if (dataIniziale != null && !dataIniziale.after(dataFinale)) {
                        double[] attivaIniziale = misuraBefore.getAttiva();
                        double[] attivaFinale = misura.getAttiva();
                        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
                        int n2 = fasciaOrariaArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            int index;
                            FasciaOraria fascia = fasciaOrariaArray[n3];
                            int n4 = index = fascia.ordinal();
                            attivaFinale[n4] = attivaFinale[n4] - consumiAfter[index];
                            ++n3;
                        }
                        ka = misura.getKa().doubleValue();
                        newMissingDays = ConsumiHelper.buildMissingDays(codicePod, dataIniziale, attivaIniziale, dataFinale, attivaFinale, pivaDistr, codComIst, ka, status, configuration);
                        missingDays.addAll(newMissingDays);
                    }
                }
                misura = misureIterator.next();
                dataMisura = misura.getDataMisura();
                continue;
            }
            if (smontaggio.isSmisMontaggio()) {
                montaggio = smontaggio;
            } else {
                if (misuraBefore != null) {
                    double[] attivaBefore = misuraBefore.getAttiva();
                    double[] attivaSmontaggio = smontaggio.getAttiva();
                    ka = misuraBefore.getKa().doubleValue();
                    newMissingDays = ConsumiHelper.buildMissingDays(codicePod, dataIniziale, attivaBefore, dataSmontaggio, attivaSmontaggio, pivaDistr, codComIst, ka, status, configuration);
                    missingDays.addAll(newMissingDays);
                }
                montaggio = smisIterator.next();
            }
            Date dataMontaggio = montaggio.getDataMisura();
            if (!montaggio.isSmisMontaggio() || !smisIterator.hasNext()) {
                throw new SmisException(codicePod, dataMontaggio);
            }
            if (dateBefore.before(dataMontaggio)) {
                misuraBefore = montaggio;
                dataIniziale = dataMontaggio;
            }
            smontaggio = smisIterator.next();
            dataSmontaggio = smontaggio.getDataMisura();
        }
        return missingDays;
    }

    public static LetturaSegnanti getUltimaLettura(String codicePod, Date dataLetPre, Date dateBefore, Destinatari destinatari, MisureDao misureDao) {
        List<Lettura> letture;
        List<Mno> misureBefore = misureDao.getPdo2GRDaA(codicePod, dataLetPre, dateBefore, destinatari, STATI_PDO2GR);
        LetturaSegnanti misuraBefore = misureBefore.isEmpty() ? (dataLetPre == null ? null : ((letture = misureDao.getLetture(codicePod, dataLetPre)).isEmpty() ? null : (LetturaSegnanti)letture.get(letture.size() - 1))) : (LetturaSegnanti)misureBefore.get(misureBefore.size() - 1);
        return misuraBefore;
    }

    private static List<LetturaSegnanti> buildLetture(List<? extends LetturaSegnanti> misure, LetturaSegnanti ultimaLettura, LetturaSegnanti misura) {
        ArrayList<LetturaSegnanti> filtered = new ArrayList<LetturaSegnanti>();
        Date dataMisura = misura == null ? null : misura.getDataMisura();
        LetturaSegnanti prev = ultimaLettura;
        for (LetturaSegnanti letturaSegnanti : misure) {
            if (prev != null) {
                Date dataPrev = prev.getDataMisura();
                Date dataMno = letturaSegnanti.getDataMisura();
                if (dataMisura != null && dataMisura.before(dataPrev) && dataMisura.before(dataMno)) {
                    filtered.add(misura);
                }
                if (!dataMno.equals(dataPrev)) {
                    filtered.add(prev);
                }
            }
            prev = letturaSegnanti;
        }
        if (prev != null) {
            Date date = prev.getDataMisura();
            if (dataMisura != null && dataMisura.before(date)) {
                filtered.add(misura);
            }
            filtered.add(prev);
            if (dataMisura != null && dataMisura.after(date)) {
                filtered.add(misura);
            }
        }
        return filtered;
    }

    private static List<RilGiorno> buildMissingDays(String codicePod, Date dataIniziale, double[] attivaIniziale, Date dataFinale, double[] attivaFinale, String pivaDistr, String codComIst, double ka, ServiceStatus status, PrebillingConfiguration configuration) throws CalendarException, DataNotFoundException, CalendarNotFoundException, InvalidSegnantiException {
        Date dateBefore = CalendarTools.previousDay(dataIniziale);
        double[] consumo = new double[FasciaOraria.values().length];
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            int ordinal = fascia.ordinal();
            consumo[ordinal] = attivaFinale[ordinal] - attivaIniziale[ordinal];
            if (consumo[ordinal] < -0.001) {
                throw new InvalidSegnantiException(dateBefore, dataFinale, codicePod);
            }
            ++n3;
        }
        double[] profiloPeriodo = TariffeHelper.getProfilo(pivaDistr, dateBefore, dataFinale, codComIst, status);
        FasciaOraria[] fascePeriodo = TariffeHelper.getFasce(codicePod, "", dateBefore, dataFinale, status);
        boolean monorario = configuration.isConsumoComplessivo();
        List<Double> consumi = TariffeHelper.calcolaConsumi(consumo, dataIniziale, dataFinale, dataIniziale, dataFinale, profiloPeriodo, fascePeriodo, monorario);
        return ConsumiHelper.buildMissingDays(dataIniziale, dataFinale, consumi, ka);
    }

    private static List<RilGiorno> buildMissingDays(Date firstDate, Date lastDate, List<Double> consumi, double ka) {
        Iterator<Double> consumiIterator = consumi.iterator();
        ArrayList<RilGiorno> missingDays = new ArrayList<RilGiorno>();
        Date current = firstDate;
        while (!current.after(lastDate)) {
            RilGiorno rilGiorno = new RilGiorno(current, true);
            int hour = 0;
            while (hour < CalendarTools.getHoursOfDay(current)) {
                double attiva = consumiIterator.next();
                int index = hour * 4;
                rilGiorno.add(ConsumiHelper.createRilQuarto(index++, attiva, ka, RilQuartoType.RICOSTRUITO));
                rilGiorno.add(ConsumiHelper.createRilQuarto(index++, 0.0, ka, RilQuartoType.RICOSTRUITO));
                rilGiorno.add(ConsumiHelper.createRilQuarto(index++, 0.0, ka, RilQuartoType.RICOSTRUITO));
                rilGiorno.add(ConsumiHelper.createRilQuarto(index++, 0.0, ka, RilQuartoType.RICOSTRUITO));
                ++hour;
            }
            missingDays.add(rilGiorno);
            current = CalendarTools.nextDay(current);
        }
        return missingDays;
    }
}

