/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.TipoEstrazione;
import biz.elabor.prebilling.model.calendar.CalendarioCommercialeHelper;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.InvalidFasciaValue;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraContatorePod;
import biz.elabor.prebilling.model.misure.MisureHelper;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.model.statomisure.PdoResult;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.DuplicatePivException;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.GestFile16Helper;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodCheckException;
import biz.elabor.prebilling.services.letture.ErrorePdo;
import biz.elabor.prebilling.services.letture.IncoherenceException;
import biz.elabor.prebilling.services.letture.MisuraNonZeroException;
import biz.elabor.prebilling.services.letture.MisureOrarieService;
import biz.elabor.prebilling.services.letture.PdoEnvironment;
import biz.elabor.prebilling.services.letture.PivChecker;
import biz.elabor.prebilling.services.letture.PodNonorarioException;
import biz.elabor.prebilling.services.letture.statopod.PdoSwitchoutStatoPodHandler;
import biz.elabor.prebilling.services.letture.statopod.PdoVoltureStatoPodHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.exceptions.BasicKeyException;
import org.homelinux.elabor.springtools.web.widgets.AbstractSentence;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.RecordSafeListMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public class BaseAggregationStrategy
implements ServiceStrategy {
    private static final List<ErroriElaborazione> AMMESSI = Arrays.asList(ErroriElaborazione.MISURA_NON_ZERO, ErroriElaborazione.INCOHERENT_MODEL);
    private final TalkManager talkManager;
    private final Reseller queryReseller;
    private final TipoEstrazione tipo;
    private final MisureOrarieService misureOrarieService;
    private final PdoSwitchoutStatoPodHandler pdoSwitchoutSPH;
    private final PdoVoltureStatoPodHandler pdoVoltureSPH;
    private final String title;
    private final PivChecker pivChecker;
    private final PrebillingConfiguration configuration;
    private final int anno;
    private final Month mese;
    private final DecimalFormat doubleFormat;
    private final DateFormat timestampFormat;

    public BaseAggregationStrategy(int anno, Month mese, String title, Reseller queryReseller, TipoEstrazione tipo, MisureDao misureDao, TalkManager talkManager, PivChecker pivChecker, PrebillingConfiguration configuration) {
        this.anno = anno;
        this.mese = mese;
        this.title = title;
        this.queryReseller = queryReseller;
        this.tipo = tipo;
        this.talkManager = talkManager;
        this.pivChecker = pivChecker;
        this.configuration = configuration;
        this.pdoSwitchoutSPH = new PdoSwitchoutStatoPodHandler(misureDao);
        this.pdoVoltureSPH = new PdoVoltureStatoPodHandler(misureDao);
        this.misureOrarieService = new MisureOrarieService(this.pdoVoltureSPH, configuration, misureDao);
        this.doubleFormat = BasicRecordCreatorHelper.getDoubleFormat();
        this.timestampFormat = StrategyCommonHelper.getTimestampFormat();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok;
        try {
            SafeListMap<String, Prestazione> prestazioni = status.getPrestazioni();
            this.pdoSwitchoutSPH.check(prestazioni, StrategyHelper.PNO_CDUNIPRE_LIST);
            this.pdoVoltureSPH.check(prestazioni, StrategyHelper.VOLTURE_CDUNIPRE_LIST);
            RecordSafeListMap<String, Pdo> pdos = status.getPdoMap();
            this.execute(pdos, status);
            this.exportRiconfigurazioni(status);
            ok = true;
        }
        catch (SegnaleNotHandledException exc) {
            Warning sentence = new Warning("export.stdlet.strategy", "segnale.nothandled");
            sentence.setCss("alert-danger");
            Prestazione prestazione = exc.getPrestazione();
            sentence.addParam(prestazione.getKey());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        catch (PrestazioneNotFoundException exc) {
            Warning sentence = new Warning("export.stdlet.strategy", "prestazione.notfound");
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getKey());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        catch (FileNotFoundException exc) {
            Warning sentence = new Warning("export.stdlet.strategy", "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getMessage());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private void exportRiconfigurazioni(ServiceStatus status) throws FileNotFoundException {
        String idEsecuzione = status.getIdEsecuzione();
        Map<String, ListMap<String, MisuraContatorePod>> riconfMap = status.getRiconfigurazioni();
        for (Map.Entry<String, ListMap<String, MisuraContatorePod>> entry : riconfMap.entrySet()) {
            String azienda = entry.getKey();
            ListMap<String, MisuraContatorePod> riconfMapAzienda = entry.getValue();
            for (Map.Entry<String, List<MisuraContatorePod>> entry2 : riconfMapAzienda.entrySet()) {
                this.exportRiconfigurazioni(azienda, entry2, idEsecuzione);
            }
        }
    }

    private void exportRiconfigurazioni(String azienda, Map.Entry<String, List<MisuraContatorePod>> aziendaEntry, String idEsecuzione) throws FileNotFoundException {
        String prefix = aziendaEntry.getKey();
        List<MisuraContatorePod> riconfAzienda = aziendaEntry.getValue();
        if (!riconfAzienda.isEmpty()) {
            this.exportRiconfigurazioni(azienda, prefix, riconfAzienda, idEsecuzione);
        }
    }

    private void exportRiconfigurazioni(String azienda, String prefix, List<MisuraContatorePod> riconfAzienda, String idEsecuzione) throws FileNotFoundException {
        File resellerFolder = ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, Funzionalita.LETTURE);
        String annoMeseFilename = Funzionalita.LETTURE.getAnnoMeseFilename(this.anno, this.mese);
        String timestamp = this.timestampFormat.format(new Date());
        String id = this.pivChecker.getId();
        String fileName = String.valueOf(prefix) + "-" + azienda + annoMeseFilename + "-" + id + "-" + timestamp + ".txt";
        File file = new File(resellerFolder, fileName);
        try (PrintWriter writer = new PrintWriter(file);){
            int lunghezzaMatricola = this.configuration.getLunghezzaMatricola();
            GestFile16Helper.printGestFile16Header(writer, "", lunghezzaMatricola);
            for (MisuraContatorePod misuraPdo : riconfAzienda) {
                Date dataMisura;
                Date dataPrestazione;
                Pod pod = misuraPdo.getPod();
                String matricola = pod.getMatricola(dataPrestazione = CalendarTools.nextDay(dataMisura = misuraPdo.getDataMisura()));
                if (matricola == null || matricola.length() < 17 || matricola.startsWith("ORARIA") || matricola.startsWith("FITTIZIA")) {
                    matricola = "ORARIA";
                }
                misuraPdo.setMatricola(matricola);
                Misura misAnte = misuraPdo.getMisAnte();
                String tipoRec = misuraPdo.getTipoRec();
                GestFile16Helper.writeMisura(writer, pod, misAnte, misuraPdo, tipoRec, this.configuration, false);
            }
        }
    }

    private void execute(SafeListMap<String, Pdo> pdos, ServiceStatus status) {
        for (List list : pdos) {
            this.execute(list, status);
        }
    }

    private void execute(List<Pdo> pdos, ServiceStatus status) {
        for (Pdo pdo : pdos) {
            ErroriElaborazione errore;
            String descrizione;
            AbstractSentence sentence;
            String descrizione2;
            Message sentence2;
            String message;
            String codicePod = pdo.getCodicePod();
            try {
                StatusTransaction transaction = new StatusTransaction(null, status, this.configuration);
                this.handlePdo(pdo, transaction);
                transaction.handleDeferredStatiPod();
                transaction.commit(codicePod);
            }
            catch (DuplicatePivException | DataNotFoundException exc) {
                message = exc.getMessage();
                sentence2 = new Message(this.title, message);
                sentence2.addParam(exc.getKey());
                sentence2.setCss("alert-danger");
                this.talkManager.addSentence(sentence2);
                descrizione2 = this.talkManager.getMessage(sentence2);
                ErroriElaborazione errore2 = StrategyHelper.getErroreElaborazione(exc);
                status.addPdoSospeso(new PdoResult(pdo, errore2, descrizione2));
            }
            catch (PodNonorarioException exc) {
                MappaMisureAzienda pnos = status.getPnos();
                boolean containsPod = pnos.containsPod(codicePod);
                sentence = containsPod ? new Warning(this.title, "pod.nonOrarioConTutteMisure") : new Warning(this.title, "pod.nonOrario");
                sentence.setCss("alert-warning");
                sentence.addParam(codicePod);
                this.talkManager.addSentence(sentence);
                descrizione = this.talkManager.getMessage(sentence);
                status.addPdoSospeso(new PdoResult(pdo, ErroriElaborazione.POD_NONORARIO, descrizione));
            }
            catch (CalendarNotFoundException exc) {
                message = exc.getMessage();
                sentence2 = new Message(this.title, message);
                sentence2.addParam(exc.getKey());
                sentence2.addParam(exc.getCodicePod());
                sentence2.setCss("alert-danger");
                this.talkManager.addSentence(sentence2);
                descrizione2 = this.talkManager.getMessage(sentence2);
                PdoResult result = new PdoResult(pdo, ErroriElaborazione.CALENDARIO_NOTFOUND, descrizione2);
                status.addPdoSospeso(result);
            }
            catch (IncoherenceException exc) {
                message = exc.getMessage();
                String key = exc.getKey();
                sentence = new Message(this.title, message);
                sentence.setCss("alert-danger");
                sentence.addParam(key);
                sentence.addParam(codicePod);
                this.talkManager.addSentence(sentence);
                descrizione = this.talkManager.getMessage(sentence);
                errore = StrategyHelper.getErroreElaborazione(exc);
                PdoResult pdoResult = new PdoResult(pdo, errore, descrizione);
                status.addPdoSospeso(pdoResult);
                Map<String, Mno> riconfigurazioni = status.getRiconfigurazioniPod2GR();
                Mno riconfigurazione = riconfigurazioni.get(codicePod);
                if (riconfigurazione == null) continue;
                MnoResult mnoResult = new MnoResult(riconfigurazione, errore, descrizione);
                status.addPdo2GRSospeso(mnoResult);
            }
            catch (PraticaAnnullataException | StatoPodCheckException exc) {
                String prestazione = exc.getSpecification();
                this.handleException(exc, pdo, prestazione, status);
            }
            catch (MisuraNonZeroException exc) {
                Message sentence3 = new Message(this.title, "misura.nonzero");
                sentence3.addParam(codicePod);
                this.talkManager.addSentence(sentence3);
                String descrizione3 = this.talkManager.getMessage(sentence3);
                PdoResult result = new PdoResult(pdo, ErroriElaborazione.MISURA_NON_ZERO, descrizione3);
                status.addPdoSospeso(result);
            }
            catch (InvalidFasciaValue exc) {
                message = exc.getMessage();
                sentence2 = new Message(this.title, message);
                String key = exc.getKey();
                sentence2.addParam(key);
                this.talkManager.addSentence(sentence2);
                descrizione = this.talkManager.getMessage(sentence2);
                errore = StrategyHelper.getErroreElaborazione(exc);
                PdoResult result = new PdoResult(pdo, errore, descrizione);
                status.addPdoSospeso(result);
            }
            catch (RuntimeException exc) {
                String descrizione4 = StrategyHelper.handleRuntimeException(exc, codicePod, this.title, this.talkManager, status);
                PdoResult result = new PdoResult(pdo, ErroriElaborazione.EXCLUDING_ERROR, descrizione4);
                status.addPdoSospeso(result);
            }
        }
    }

    private void handlePdo(Pdo pdo, StatusTransaction transaction) throws DataNotFoundException, IncoherenceException, StatoPodCheckException, PraticaAnnullataException, InvalidFasciaValue, PodNonorarioException, CalendarNotFoundException, MisuraNonZeroException, DuplicatePivException {
        String codicePod = pdo.getCodicePod();
        PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codicePod);
        this.pivChecker.handlePdo(pdo, transaction, this);
    }

    private void handleException(BasicKeyException exc, Pdo pdo, String param, ServiceStatus status) {
        String message = exc.getMessage();
        Message sentence = new Message(this.title, message);
        sentence.setCss("alert-danger");
        sentence.addParam(exc.getKey());
        if (param != null) {
            sentence.addParam(param);
        }
        this.talkManager.addSentence(sentence);
        String descrizione = this.talkManager.getMessage(sentence);
        ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
        status.addPdoSospeso(new PdoResult(pdo, errore, descrizione));
    }

    public void handlePdo(Pdo pdo, PraticaVolo pratica, StatusTransaction transaction) throws DataNotFoundException, PodNonorarioException, CalendarNotFoundException, IncoherenceException, StatoPodCheckException, PraticaAnnullataException, MisuraNonZeroException, InvalidFasciaValue {
        PodMap pods = transaction.getPodMap();
        String codicePod = pdo.getCodicePod();
        Pod pod = pods.get(codicePod);
        String azienda = pod.getAzienda();
        transaction.setAzienda(azienda);
        pdo.setCdaziend(azienda);
        MisureHelper.checkFasce(pdo, this.doubleFormat);
        this.handlePdo(pdo, pod, pratica, transaction);
    }

    private void handlePdo(Pdo pdo, Pod pod, PraticaVolo pratica, StatusTransaction transaction) throws PodNonorarioException, DataNotFoundException, CalendarNotFoundException, IncoherenceException, StatoPodCheckException, PraticaAnnullataException, MisuraNonZeroException {
        boolean flMisbio = pod.isFlMisbio();
        RilMese rilMese = pdo.getRilMese();
        WorkingPeriod period = rilMese.getPeriod();
        Date startDate = period.getStartDate();
        String codiceOfferta = pod.getCodiceOfferta(startDate);
        boolean commerciale = CalendarioCommercialeHelper.isCommerciale(transaction, codiceOfferta, this.configuration);
        BaseAggregationStrategy.checkCommerciale(pod, flMisbio, commerciale);
        Pdo pdoRettificato = BaseAggregationStrategy.getRettifica(pdo, transaction);
        this.handlePdoRettificato(pdoRettificato, pod, pratica, transaction);
    }

    private static void checkCommerciale(Pod pod, boolean flMisbio, boolean commerciale) throws IncoherenceException {
        if (flMisbio != commerciale && (flMisbio || !pod.isNuovaFornitura())) {
            String codicePod = pod.getCodice();
            throw new IncoherenceException("notcoherent.offer", codicePod, ErroriElaborazione.OFFERTA_COMMERCIALE_INCOERENTE);
        }
    }

    private void handlePdoRettificato(Pdo pdo, Pod pod, PraticaVolo pratica, StatusTransaction transaction) throws DataNotFoundException, PodNonorarioException, CalendarNotFoundException, IncoherenceException, StatoPodCheckException, PraticaAnnullataException, MisuraNonZeroException {
        SafeMap<String, Reseller> resellers = transaction.getResellers();
        String azienda = pod.getAzienda();
        if (this.queryReseller.match(azienda) && this.tipo.match(true)) {
            Date dataMax = pod.getDataMax();
            Date dataRif = CalendarTools.nextDay(dataMax);
            Date dataInst = pod.getDataInst(dataRif);
            if (pod.isOrario() || pod.isAttesaSnm() || dataInst.equals(dataRif)) {
                Reseller podReseller = (Reseller)resellers.get(azienda);
                boolean crm = podReseller.isCrm();
                this.handlePdo(crm, podReseller, pod, pdo, pratica, transaction);
            } else {
                throw new PodNonorarioException();
            }
        }
    }

    private static Pdo getRettifica(Pdo pdo, StatusTransaction transaction) {
        Pdo rfo;
        Month meseRil;
        Pdo pdoRettificato = pdo;
        Map<Date, Map<String, Pdo>> rfos = transaction.getRfos();
        String codicePod = pdo.getCodicePod();
        RilMese rilMese = pdo.getRilMese();
        int annoRil = rilMese.getAnno();
        Date date = CalendarTools.getDate(annoRil, meseRil = rilMese.getMese(), 1);
        Map<String, Pdo> rfosMese = rfos.get(date);
        if (rfosMese != null && (rfo = rfosMese.get(codicePod)) != null) {
            PdoResult result = new PdoResult(pdo, ErroriElaborazione.OK, "");
            transaction.addPdoElaborato(result);
            RilMese rilMeseRfo = rfo.getRilMese();
            RilMese rilMeseRett = StrategyHelper.merge(rilMeseRfo, rilMese);
            pdoRettificato = rfo;
            Set<String> pdoId = pdo.getId();
            pdoRettificato.addId(pdoId);
            pdoRettificato.setRilMese(rilMeseRett);
            rfosMese.remove(codicePod);
        }
        return pdoRettificato;
    }

    private void handlePdo(boolean crm, Reseller reseller, Pod pod, Pdo pdo, PraticaVolo pratica, StatusTransaction transaction) throws DataNotFoundException, CalendarNotFoundException, IncoherenceException, StatoPodCheckException, PraticaAnnullataException, MisuraNonZeroException {
        MappaMisureAzienda pnos = transaction.getPnos();
        List<SpecificaTecnica> specifiche = pod.getSpecificheTecniche();
        PdoEnvironment environment = new PdoEnvironment(pod, pdo, pnos, pratica);
        Set<ErrorePdo> errori = this.misureOrarieService.generateMisure(crm, reseller, pod, pdo, transaction, specifiche, environment);
        if (environment.isBlocked() && !environment.isSwitchout()) {
            Message sentence = new Message(this.title, "blocked.pdo");
            String codicePod = pod.getCodice();
            sentence.addParam(codicePod);
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            ErroriElaborazione errore = ErroriElaborazione.BLOCKED_PDO;
            PdoResult result = new PdoResult(pdo, errore, descrizione);
            transaction.addPdoSospeso(result);
        } else {
            Set<String> id = pdo.getId();
            for (ErrorePdo errorePdo : errori) {
                ErroriElaborazione errore = errorePdo.getErrore();
                String descrizione = StrategyHelper.handleErrore(pod, errore, this.talkManager);
                String flusso = errorePdo.getCodiceFlusso();
                Set<String> idErrore = errorePdo.getId();
                PdoResult pdoResult = new PdoResult(pdo, errore, descrizione, idErrore);
                if (AMMESSI.contains(errore)) {
                    transaction.addPdoElaborato(pdoResult);
                    transaction.count(flusso);
                } else {
                    transaction.addPdoSospeso(pdoResult);
                }
                id.removeAll(idErrore);
            }
            if (!id.isEmpty()) {
                PdoResult pdoResult = new PdoResult(pdo, ErroriElaborazione.OK, "", id);
                transaction.addPdoElaborato(pdoResult);
                String flusso = pdo.getFirstCodiceFlusso();
                transaction.count(flusso);
            }
        }
    }
}

