/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.TestServiceStatus;
import biz.elabor.prebilling.model.ErrorWrapper;
import biz.elabor.prebilling.model.MockOfferteCommerciali;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.TipoEstrazione;
import biz.elabor.prebilling.model.calendar.CalendarMap;
import biz.elabor.prebilling.model.calendar.OffertaCommerciale;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodInstance;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Misure;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.model.prebilling.DispatchingFlussi;
import biz.elabor.prebilling.model.prebilling.DispatchingFlusso;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.services.HelperTest;
import biz.elabor.prebilling.services.PrebillingTestCase;
import biz.elabor.prebilling.services.letture.AggregationMockPrebillingDao;
import biz.elabor.prebilling.services.letture.BaseAggregationStrategy;
import biz.elabor.prebilling.services.letture.MockSwitchoutPrebillingDao;
import biz.elabor.prebilling.services.letture.PrebillingTestHelper;
import biz.elabor.prebilling.services.letture.TestPivChecker;
import biz.elabor.prebilling.services.volture.model.Voltura;
import biz.elabor.prebilling.util.MapWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.DaysOfMonthIterator;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.Sentence;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.DefaultListMapKey;
import org.homelinux.elabor.structures.safe.DefaultSafeListMap;
import org.homelinux.elabor.structures.safe.DefaultSafeMap;
import org.homelinux.elabor.structures.safe.RecordSafeListMap;
import org.homelinux.elabor.structures.safe.SimpleSafeListMap;

public class AggregationStrategyTest
extends PrebillingTestCase {
    private static final Date JUNE_1_DATE = CalendarTools.getDate(2016, Month.JUNE, 1);
    private static final Date JUNE_13_DATE = CalendarTools.getDate(2016, Month.JUNE, 13);
    private static final Date JUNE_17_DATE = CalendarTools.getDate(2016, Month.JUNE, 17);
    private static final Date JUNE_30_DATE = CalendarTools.getDate(2016, Month.JUNE, 30);
    private static final SpecificaTecnica JUNE_1 = new SpecificaTecnica("1", JUNE_1_DATE);
    private static final SpecificaTecnica JUNE_13 = new SpecificaTecnica("1", JUNE_13_DATE);
    private static final SpecificaTecnica JUNE_17 = new SpecificaTecnica("1", JUNE_17_DATE);
    private static final SpecificaTecnica JUNE_30 = new SpecificaTecnica("1", JUNE_30_DATE);

    public void testExecute() {
        TalkManager talkManager = new TalkManager();
        Reseller reseller = new Reseller("azienda", null, null, false, false);
        TestPivChecker pivChecker = new TestPivChecker();
        TestConfiguration configuration = new TestConfiguration();
        BaseAggregationStrategy strategy = new BaseAggregationStrategy(2017, Month.JANUARY, null, reseller, TipoEstrazione.TUTTI, null, talkManager, pivChecker, configuration);
        TestServiceStatus status = new TestServiceStatus(configuration);
        status.setVirtualPiv(new HashMap<String, PraticaVolo>());
        AggregationMockPrebillingDao prebillingDao = new AggregationMockPrebillingDao();
        CalendarMap calendarMap = new CalendarMap(prebillingDao);
        MockOfferteCommerciali offerte = new MockOfferteCommerciali();
        status.setCalendarMap(calendarMap, offerte, configuration.getIdCalendarioArera());
        ArrayList<Reseller> resellers = new ArrayList<Reseller>();
        resellers.add(new Reseller("azienda", null, "azienda", true, false));
        status.setResellers(resellers);
        DefaultPodMap pods = AggregationStrategyTest.getPods();
        status.setPodMap(pods);
        RecordSafeListMap<String, Pdo> pdos = AggregationStrategyTest.getPdos();
        status.setPdo(pdos);
        AggregationStrategyTest.definePiv(status);
        status.setPno(new MappaMisureAzienda(null, null, talkManager, null));
        SimpleSafeListMap<String, Prestazione> prestazioni = new SimpleSafeListMap<String, Prestazione>("");
        status.setPrestazioni(prestazioni);
        AggregationStrategyTest.definePrestazioni(status);
        status.setRfoMap(new HashMap<Date, Map<String, Pdo>>());
        strategy.execute(status);
        List<Sentence> sentences = talkManager.getSentences();
        AggregationStrategyTest.assertEquals(4, sentences.size());
        int index = 0;
        while (index < 3) {
            Sentence sentence = sentences.get(index);
            AggregationStrategyTest.assertEquals("pod.nonOrario", sentence.getDescription());
            ++index;
        }
        Sentence sentence = sentences.get(3);
        AggregationStrategyTest.assertEquals("pod.notfound", sentence.getDescription());
        Map<String, Misure<Voltura>> misureOrarieNoCrm = status.getMisureOrarieVolturaNoCrm();
        Misure<Voltura> misureOrarieNoCrmAzienda = misureOrarieNoCrm.get("azienda");
        AggregationStrategyTest.assertNull(misureOrarieNoCrmAzienda);
    }

    private static void definePiv(ServiceStatus status) {
        DefaultListMapKey<String, PraticaVolo> piv = new DefaultListMapKey<String, PraticaVolo>();
        Date date = new Date(0L);
        SpecificaTecnica voltura = new SpecificaTecnica(null, date);
        PraticaVolo value = new PraticaVolo("pod1", "azienda1", voltura, "SE3", null, date, 0);
        piv.add(value);
        status.setPiv(piv);
        HashMap<String, PraticaVolo> virtualPiv = new HashMap<String, PraticaVolo>();
        status.setVirtualPiv(virtualPiv);
    }

    public void testPdoPno() {
        TalkManager talkManager = new TalkManager();
        Reseller reseller = new Reseller("*", null, null, false, false);
        TestPivChecker pivChecker = new TestPivChecker();
        TestConfiguration configuration = new TestConfiguration();
        BaseAggregationStrategy strategy = new BaseAggregationStrategy(2017, Month.JANUARY, null, reseller, TipoEstrazione.TUTTI, null, talkManager, pivChecker, configuration);
        TestServiceStatus status = new TestServiceStatus(configuration);
        status.setVirtualPiv(new HashMap<String, PraticaVolo>());
        DefaultPodMap pods = AggregationStrategyTest.getPodsPdoPno();
        status.setPodMap(pods);
        RecordSafeListMap<String, Pdo> pdos = AggregationStrategyTest.getPdosPdoPno();
        status.setPdo(pdos);
        MappaMisureAzienda pnos = AggregationStrategyTest.getPnosPdoPno(status, talkManager, pods);
        status.setPno(pnos);
        AggregationStrategyTest.definePiv(status);
        status.setRfoMap(new HashMap<Date, Map<String, Pdo>>());
        AggregationStrategyTest.definePrestazioni(status);
        ErrorWrapper safeMapError = new ErrorWrapper("offertacommerciale", ErroriElaborazione.OFFERTA_COMMERCIALE_NOTFOUND);
        DefaultSafeMap<String, OffertaCommerciale> offerteCommerciali = new DefaultSafeMap<String, OffertaCommerciale>(safeMapError);
        String idCalendarioArera = configuration.getIdCalendarioArera();
        status.setCalendarMap(null, offerteCommerciali, idCalendarioArera);
        strategy.execute(status);
        List<Sentence> sentences = talkManager.getSentences();
        AggregationStrategyTest.assertEquals(1, sentences.size());
        Sentence sentence = sentences.get(0);
        AggregationStrategyTest.assertEquals("pod.nonOrarioConTutteMisure", sentence.getDescription());
    }

    public void testSwitchOut() {
        TalkManager talkManager = new TalkManager();
        Reseller reseller = new Reseller("*", null, null, false, false);
        TestPivChecker pivChecker = new TestPivChecker();
        TestConfiguration configuration = new TestConfiguration();
        BaseAggregationStrategy strategy = new BaseAggregationStrategy(2017, Month.JANUARY, null, reseller, TipoEstrazione.TUTTI, null, talkManager, pivChecker, configuration);
        TestServiceStatus status = new TestServiceStatus(configuration);
        MockSwitchoutPrebillingDao prebillingDao = new MockSwitchoutPrebillingDao();
        CalendarMap calendarMap = new CalendarMap(prebillingDao);
        MockOfferteCommerciali offerteCommerciali = new MockOfferteCommerciali();
        status.setCalendarMap(calendarMap, offerteCommerciali, configuration.getIdCalendarioArera());
        ArrayList<Reseller> resellers = new ArrayList<Reseller>();
        resellers.add(new Reseller("azienda1", null, "azienda1", true, false));
        status.setResellers(resellers);
        DefaultPodMap pods = AggregationStrategyTest.getPodsSwitchOut();
        status.setPodMap(pods);
        AggregationStrategyTest.definePrestazioni(status);
        RecordSafeListMap<String, Pdo> pdos = AggregationStrategyTest.getPdosSwitchOut();
        status.setPdo(pdos);
        AggregationStrategyTest.definePiv(status);
        AggregationStrategyTest.defineDispatchingFlussi(status);
        status.setRfoMap(new HashMap<Date, Map<String, Pdo>>());
        MappaMisureAzienda pno = new MappaMisureAzienda(null, reseller, talkManager, null);
        status.setPno(pno);
        strategy.execute(status);
        List<Sentence> sentences = talkManager.getSentences();
        AggregationStrategyTest.assertEquals(0, sentences.size());
        MapWriter switchOut = status.getSwitchoutCsvWriter("azienda1|SE3");
        AggregationStrategyTest.assertTrue(switchOut.isEmpty());
    }

    private static void defineDispatchingFlussi(ServiceStatus status) {
        DispatchingFlussi dispatchingFlussi = new DispatchingFlussi();
        DispatchingFlusso value = new DispatchingFlusso("E", "SE3", "PDO", "azienda1", false, "");
        dispatchingFlussi.put(value.getKey(), value);
        status.setDispatchingFlussi(dispatchingFlussi);
    }

    private static void definePrestazioni(ServiceStatus status) {
        SimpleSafeListMap<String, Prestazione> prestazioni = new SimpleSafeListMap<String, Prestazione>("");
        prestazioni.add(new Prestazione("E", "SE3", "PNO", 0, 2, null, null, "", false));
        prestazioni.add(new Prestazione("E", "SE3", "PDO", 0, 2, null, null, "", false));
        prestazioni.add(new Prestazione("E", "CP1", "PNO", 0, 2, null, null, "", false));
        prestazioni.add(new Prestazione("E", "CP1", "PDO", 0, 2, null, null, "", false));
        prestazioni.add(new Prestazione("E", "VT1", "PNO", 0, 2, null, null, "", false));
        prestazioni.add(new Prestazione("E", "VT1", "PDO", 0, 2, null, null, "", false));
        prestazioni.add(new Prestazione("E", "VT3", "PNO", 0, 2, null, null, "", false));
        prestazioni.add(new Prestazione("E", "VT3", "PDO", 0, 2, null, null, "", false));
        prestazioni.add(new Prestazione("E", "RC1", "PNO", 0, 2, null, null, "", false));
        prestazioni.add(new Prestazione("E", "RC1", "PDO", 0, 2, null, null, "", false));
        prestazioni.add(new Prestazione("E", "AE1", "PNO", 0, 1, null, null, "", false));
        prestazioni.add(new Prestazione("E", "AE1", "PDO", 0, 1, null, null, "", false));
        prestazioni.add(new Prestazione("E", "VT4", "PNO", 0, 2, null, null, "", false));
        prestazioni.add(new Prestazione("E", "VT4", "PDO", 0, 2, null, null, "", false));
        status.setPrestazioni(prestazioni);
    }

    private static MappaMisureAzienda getPnosPdoPno(ServiceStatus status, TalkManager talkManager, PodMap pods) {
        ArrayList<Mno> pnosPeriodo = new ArrayList<Mno>();
        Date date = JUNE_30.getData();
        Misura misura = PrebillingTestHelper.newMisura(date, false, 3);
        HashMap<String, Map<String, String>> datipod = new HashMap<String, Map<String, String>>();
        datipod.put("DatiPdp", new HashMap());
        Mno pno = new Mno(null, "PNO", "pod", misura, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, "");
        pnosPeriodo.add(pno);
        Reseller tutti = new Reseller("*", "tutti", null, false, false);
        MappaMisureAzienda pnos = new MappaMisureAzienda(TipoEstrazione.TUTTI, tutti, talkManager, null);
        ErrorWrapper error = new ErrorWrapper("pdo", ErroriElaborazione.PDO_NOTFOUND);
        DefaultSafeListMap<String, Pdo> pdos = new DefaultSafeListMap<String, Pdo>(error);
        PrebillingTestHelper.fillMno(pnosPeriodo);
        pnos.addMisurePeriodo(status, pnosPeriodo, pods, pdos);
        return pnos;
    }

    private static RecordSafeListMap<String, Pdo> getPdosPdoPno() {
        ErrorWrapper error = new ErrorWrapper("pdo", ErroriElaborazione.PDO_NOTFOUND);
        DefaultSafeListMap<String, Pdo> pdos = new DefaultSafeListMap<String, Pdo>(error);
        RilMese rilMese = new RilMese("pod", 2016, Month.JUNE, null);
        HashMap<String, Map<String, String>> datiPod = new HashMap<String, Map<String, String>>();
        Pdo pdo = new Pdo(null, false, rilMese, null, null, "dispatcher", null, null, datiPod, "", "", null, "");
        pdos.add(pdo);
        return pdos;
    }

    private static RecordSafeListMap<String, Pdo> getPdosSwitchOut() {
        ErrorWrapper error = new ErrorWrapper("pdo", ErroriElaborazione.PDO_NOTFOUND);
        DefaultSafeListMap<String, Pdo> pdos = new DefaultSafeListMap<String, Pdo>(error);
        RilMese rilMese = new RilMese("pod1", 2017, Month.AUGUST, null);
        RilGiorno rilGiorno = new RilGiorno(CalendarTools.getDate(2017, Month.AUGUST, 1));
        rilMese.add(rilGiorno);
        LinkedHashMap<String, Map<String, String>> datiPod = new LinkedHashMap<String, Map<String, String>>();
        LinkedHashMap<String, String> datiPdp = new LinkedHashMap<String, String>();
        datiPdp.put("Trattamento", "O");
        datiPod.put("DatiPdp", datiPdp);
        Pdo pdo1 = new Pdo(null, false, rilMese, null, null, "dispatcher", null, null, datiPod, "", "", null, "");
        pdos.add(pdo1);
        return pdos;
    }

    private static RecordSafeListMap<String, Pdo> getPdos() {
        HashMap<String, Map<String, String>> datiPod = new HashMap<String, Map<String, String>>();
        ErrorWrapper error = new ErrorWrapper("pdo", ErroriElaborazione.PDO_NOTFOUND);
        DefaultSafeListMap<String, Pdo> pdos = new DefaultSafeListMap<String, Pdo>(error);
        int index = 0;
        while (index < 5) {
            RilMese rilMese = new RilMese("pod" + index, 2016, Month.JUNE, null);
            DaysOfMonthIterator iterator = new DaysOfMonthIterator(2016, Month.JUNE);
            ElaborCalendar calendar = new ElaborCalendar(2016, Month.JUNE);
            while (iterator.hasNext()) {
                int giorno = iterator.next();
                calendar.setGiorno(giorno);
                Date date = calendar.getDate();
                RilGiorno rilGiorno = new RilGiorno(date);
                int quarto = 0;
                while (quarto < 96) {
                    RilQuarto rilQuarto = HelperTest.createRilQuarto(quarto, giorno * quarto, giorno * quarto * 2, giorno * quarto * 2, giorno * quarto * 2);
                    rilGiorno.add(rilQuarto);
                    ++quarto;
                }
                rilMese.add(rilGiorno);
            }
            Pdo pdo = new Pdo(null, false, rilMese, null, null, "dispatcher", null, null, datiPod, "", "", null, "");
            pdos.add(pdo);
            ++index;
        }
        RilMese rilMese = new RilMese("pod5", 2016, Month.JUNE, null);
        ElaborCalendar calendar = new ElaborCalendar(2016, Month.JUNE);
        int giorno = 10;
        while (giorno < 20) {
            calendar.setGiorno(giorno);
            Date date = calendar.getDate();
            RilGiorno rilGiorno = new RilGiorno(date);
            int quarto = 0;
            while (quarto < 96) {
                RilQuarto rilQuarto = HelperTest.createRilQuarto(quarto, giorno * quarto, giorno * quarto * 2, giorno * quarto * 2, giorno * quarto * 2);
                rilGiorno.add(rilQuarto);
                ++quarto;
            }
            rilMese.add(rilGiorno);
            ++giorno;
        }
        Pdo pdo = new Pdo(null, true, rilMese, null, null, "dispatcher", null, null, datiPod, "", "", null, "");
        pdos.add(pdo);
        RilMese rilMeseSenzaPod = new RilMese("nonce", 2016, Month.JUNE, null);
        Pdo pdoSenzaPod = new Pdo(null, false, rilMeseSenzaPod, null, null, "dispatcher", null, null, null, "", "", null, "");
        pdos.add(pdoSenzaPod);
        return pdos;
    }

    private static DefaultPodMap getPods() {
        DefaultPodMap pods = new DefaultPodMap();
        Date startDate = new Date(0L);
        int index = 0;
        while (index < 15) {
            Pod pod = new Pod("pod" + index, index % 2 == 1, 1001, "azienda", startDate, null, true, true, true, new Date(0L), null, "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
            pod.addInstance(new PodInstance(startDate, true, true, true, true, 1.0, 1.0, 1.0, "", false, null, null, null, null, null));
            if (index == 3) {
                pod.addSpecificaTecnica(JUNE_1);
            }
            if (index == 5) {
                pod.addSpecificaTecnica(JUNE_13);
                pod.addSpecificaTecnica(JUNE_17);
            }
            pods.add(pod);
            ++index;
        }
        return pods;
    }

    private static DefaultPodMap getPodsPdoPno() {
        DefaultPodMap pods = new DefaultPodMap();
        Date startDate = new Date(0L);
        Pod pod = new Pod("pod", false, 1001, "azienda", startDate, null, true, true, true, startDate, null, "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
        PodInstance instance = new PodInstance(startDate, false, false, false, false, 0.0, 0.0, 0.0, null, false, startDate, null, null, null, null);
        pod.addInstance(instance);
        pods.add(pod);
        return pods;
    }

    private static DefaultPodMap getPodsSwitchOut() {
        DefaultPodMap pods = new DefaultPodMap();
        Date switchout = CalendarTools.getDate(2017, Month.AUGUST, 31);
        Pod pod1 = new Pod("pod1", true, 0, "azienda1", new Date(0L), null, true, true, true, new Date(0L), null, "dispatcher", false, switchout, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
        Pod pod2 = new Pod("pod2", false, 0, "azienda1", null, null, true, true, true, new Date(0L), null, "dispatcher", false, switchout, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
        pods.add(pod1);
        pods.add(pod2);
        return pods;
    }
}

