/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.gestionematricole;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.TestServiceStatus;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.services.gestionematricole.GestioneMatricoleMockGiadaDao;
import biz.elabor.prebilling.services.gestionematricole.GestioneMatricoleMockMisureDao;
import biz.elabor.prebilling.services.matricolefittizie.GestioneMatricoleStrategy;
import biz.elabor.test.TextTestHelper;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import junit.framework.TestCase;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.CountMap;

public class GestioneMatricoleStrategyTest
extends TestCase {
    private static final String[] CONTENT = new String[]{"@33                                                        .", "%pod1                          20072020matricola11234561   .", "%pod2                          20072020matricola11234562   .", "%pod3                          20072020matricola11234563   .", "%pod4                          20072020matricolapod41234   ."};
    private static final String[] CONTENT2 = new String[]{"@33                                                        .", "%pod6                          20072020matricolapod66666   .", "%pod7                          20072020matricolapod77777   ."};

    public void testExecute() throws UnsupportedEncodingException, IOException {
        TestConfiguration configuration = new TestConfiguration();
        File folder1 = ConfigurationHelper.getResellerTmpImportFolder(configuration, "a1", null, Funzionalita.GESTIONE_MATRICOLE);
        TextTestHelper.clearFolder(folder1);
        File folder2 = ConfigurationHelper.getResellerTmpImportFolder(configuration, "a2", null, Funzionalita.GESTIONE_MATRICOLE);
        TextTestHelper.clearFolder(folder2);
        GestioneMatricoleMockGiadaDao giadaDao = new GestioneMatricoleMockGiadaDao();
        GestioneMatricoleMockMisureDao misureDao = new GestioneMatricoleMockMisureDao();
        TalkManager talkManager = new TalkManager();
        GestioneMatricoleStrategy strategy = new GestioneMatricoleStrategy(configuration, giadaDao, misureDao, talkManager, "");
        TestServiceStatus status = new TestServiceStatus(configuration);
        ArrayList<Reseller> resellers = new ArrayList<Reseller>();
        status.setResellers(resellers);
        strategy.execute(status);
        Map<String, CountMap<String>> results = status.getResults();
        CountMap<String> a1Map = results.get("a1");
        GestioneMatricoleStrategyTest.assertEquals(5, a1Map.getCount("letti"));
        GestioneMatricoleStrategyTest.assertEquals(4, a1Map.getCount("gestiti"));
        CountMap<String> a2Map = results.get("a2");
        GestioneMatricoleStrategyTest.assertEquals(2, a2Map.getCount("letti"));
        GestioneMatricoleStrategyTest.assertEquals(2, a2Map.getCount("gestiti"));
        File[] files = folder1.listFiles();
        GestioneMatricoleStrategyTest.assertEquals(1, files.length);
        File file = files[0];
        String fileName = file.getName();
        GestioneMatricoleStrategyTest.assertTrue(fileName.startsWith("gestione-matricole-fittizie-a1-"));
        GestioneMatricoleStrategyTest.assertTrue(fileName.endsWith(".txt"));
        TextTestHelper.checkTextFile(file, "UTF-8", CONTENT);
        files = folder2.listFiles();
        GestioneMatricoleStrategyTest.assertEquals(1, files.length);
        file = files[0];
        fileName = file.getName();
        GestioneMatricoleStrategyTest.assertTrue(fileName.startsWith("gestione-matricole-fittizie-a2-"));
        GestioneMatricoleStrategyTest.assertTrue(fileName.endsWith(".txt"));
        TextTestHelper.checkTextFile(file, "UTF-8", CONTENT2);
    }
}

