/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.gas;

import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.services.gas.OutputHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.homelinux.elabor.dom.DomHelper;
import org.homelinux.elabor.file.InvalidFileFormat;
import org.w3c.dom.Element;

class XmlOutputHandler
implements OutputHandler {
    public static final String XML_SCHEMA = " xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" CodFlusso=\"D06\"";
    private File folder;

    public XmlOutputHandler(PrebillingConfiguration configuration, String idEsecuzione) {
        this.folder = ConfigurationHelper.getMiddlewareTmpFolder(configuration, idEsecuzione, Funzionalita.GAS);
    }

    @Override
    public String printD65(Element docElement) throws InvalidFileFormat, FileNotFoundException {
        Element element = DomHelper.getElement(docElement, "IdentificativiRichiesta", false);
        String pivaUtente = DomHelper.getTextElement(element, "piva_utente");
        String pivaDistributore = DomHelper.getTextElement(element, "piva_distr");
        String codicePratica = DomHelper.getTextElement(element, "cod_prat_attivazione");
        File file = new File(this.folder, String.valueOf(pivaUtente) + "-" + pivaDistributore + "-" + codicePratica + ".xml");
        PrintWriter writer = new PrintWriter(file);
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        writer.println("<Prestazione xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" CodFlusso=\"D06\">");
        writer.println("<CodProcesso>VTG</CodProcesso>");
        XmlOutputHandler.printIdentificativiRichiesta(writer, pivaUtente, pivaDistributore, codicePratica);
        XmlOutputHandler.printDatiTecnici(writer, docElement);
        XmlOutputHandler.printDatiLettura(writer, docElement);
        XmlOutputHandler.printElement(writer, docElement, "note");
        writer.print("</Prestazione>");
        writer.close();
        return file.getName();
    }

    private static void printIdentificativiRichiesta(PrintWriter writer, String pivaUtente, String pivaDistributore, String codicePratica) {
        writer.println("<IdentificativiRichiesta>");
        XmlOutputHandler.printElement(writer, "piva_utente", pivaUtente);
        XmlOutputHandler.printElement(writer, "piva_distr", pivaDistributore);
        XmlOutputHandler.printElement(writer, "cod_prat_attivazione", codicePratica);
        writer.println("</IdentificativiRichiesta>");
    }

    private static void printDatiTecnici(PrintWriter writer, Element docElement) throws InvalidFileFormat {
        Element element = DomHelper.getElement(docElement, "DatiTecnici", false);
        writer.println("<DatiTecnici>");
        XmlOutputHandler.printElement(writer, element, "cod_pdr");
        XmlOutputHandler.printElement(writer, element, "matr_mis");
        XmlOutputHandler.printElement(writer, element, "data_att_contr");
        XmlOutputHandler.printElement(writer, element, "vol_annuo_sost");
        XmlOutputHandler.printElement(writer, element, "classe_gruppo_mis");
        XmlOutputHandler.printElement(writer, element, "n_cifre_mis");
        writer.println("</DatiTecnici>");
    }

    private static void printDatiLettura(PrintWriter writer, Element docElement) throws InvalidFileFormat {
        Element element = DomHelper.getElement(docElement, "DatiLettura", false);
        writer.println("<DatiLettura>");
        XmlOutputHandler.printElement(writer, element, "segn_mis_sost");
        XmlOutputHandler.printElement(writer, element, "tipo_lettura");
        XmlOutputHandler.printElement(writer, element, "pre_conv");
        XmlOutputHandler.printElement(writer, element, "gruppo_mis_int");
        XmlOutputHandler.printElement(writer, element, "coeff_corr");
        XmlOutputHandler.printElement(writer, element, "matr_conv");
        XmlOutputHandler.printElement(writer, element, "n_cifre_conv");
        XmlOutputHandler.printElement(writer, element, "segn_conv");
        XmlOutputHandler.printElement(writer, element, "data_mis_eff");
        XmlOutputHandler.printElement(writer, element, "segn_mis_eff");
        XmlOutputHandler.printElement(writer, element, "segn_conv_eff");
        writer.println("</DatiLettura>");
    }

    private static void printElement(PrintWriter writer, Element element, String name) {
        try {
            String value = DomHelper.getTextElement(element, name);
            XmlOutputHandler.printElement(writer, name, value);
        }
        catch (InvalidFileFormat invalidFileFormat) {
            // empty catch block
        }
    }

    private static void printElement(PrintWriter writer, String name, String value) {
        writer.println("<" + name + ">" + value + "</" + name + ">");
    }

    @Override
    public void close() {
    }

    @Override
    public void closePod() {
        this.close();
    }
}

