/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.gas;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.services.gas.GasService;
import biz.elabor.prebilling.services.letture.MockPrebillingDao;
import biz.elabor.test.TextTestHelper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.homelinux.elabor.file.FileSystemTools;
import org.homelinux.elabor.springtools.web.widgets.Sentence;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class GasServiceTest
extends TestCase {
    private static final String[] NO_CRM = new String[]{"D06;PDR;DATAEVASIO;MATRICOLA1", ";02490000000074;23/11/2016;;28466409;G4;5;000000010;;;;;;;;;;;;;;;;;;;;;;;;1;;5.18001;1.036002;;VTG;;;E;;;;;;;*", ";02490000000074;23/11/2016;;28466409;G4;5;000000010;;;;;;;;;;;;;;;;;;;;;;;;1;;5.18001;1.036002;;VTG;;;E;;;;;;;*"};
    private static final String[] CRM = new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\" ?>", "<Prestazione xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" CodFlusso=\"D06\">", "<CodProcesso>VTG</CodProcesso>", "<IdentificativiRichiesta>", "<piva_utente>p_iva1</piva_utente>", "<piva_distr>00353660400</piva_distr>", "<cod_prat_attivazione>SIRIESIR1661913</cod_prat_attivazione>", "</IdentificativiRichiesta>", "<DatiTecnici>", "<cod_pdr>02490000000074</cod_pdr>", "<matr_mis>28466409</matr_mis>", "<data_att_contr>23/11/2016</data_att_contr>", "<vol_annuo_sost>5.18001</vol_annuo_sost>", "<classe_gruppo_mis>G4</classe_gruppo_mis>", "<n_cifre_mis>5</n_cifre_mis>", "</DatiTecnici>", "<DatiLettura>", "<segn_mis_sost>000000010</segn_mis_sost>", "<tipo_lettura>E</tipo_lettura>", "<pre_conv>NO</pre_conv>", "<coeff_corr>1.036002</coeff_corr>", "<data_mis_eff>23/11/2016</data_mis_eff>", "</DatiLettura>", "</Prestazione>"};
    private static final File HOME = new File("/tmp/prebilling-test");
    private static final File IN_FOLDER = new File(HOME, "input");
    private static final File SAVE_FOLDER = new File(IN_FOLDER, "save");
    private static final File MW_FOLDER = new File(HOME, "gas/middleware");
    private static final File RESELLER_FOLDER = new File(HOME, "gas/reseller-2/import");
    private static final File SAMPLES_FOLDER = new File("samples");
    private GasService strategy;
    private TalkManager talkManager;
    private PrebillingDao dao;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.dao = new MockPrebillingDao();
        TestConfiguration configuration = new TestConfiguration();
        configuration.setCrm(true);
        TextTestHelper.clearFolder(IN_FOLDER);
        TextTestHelper.clearFolder(SAVE_FOLDER);
        TextTestHelper.clearFolder(MW_FOLDER);
        TextTestHelper.clearFolder(RESELLER_FOLDER);
        this.talkManager = new TalkManager();
        this.strategy = new GasService(configuration, this.talkManager);
    }

    public void testExecute() throws IOException {
        File fileCrm = new File(SAMPLES_FOLDER, "tmv-0350-crm.xml");
        FileSystemTools.copy(fileCrm, IN_FOLDER);
        File fileNoCrm = new File(SAMPLES_FOLDER, "tmv-0350-nocrm-1.xml");
        FileSystemTools.copy(fileNoCrm, IN_FOLDER);
        fileNoCrm = new File(SAMPLES_FOLDER, "tmv-0350-nocrm-2.xml");
        FileSystemTools.copy(fileNoCrm, IN_FOLDER);
        this.strategy.execute(this.dao, null);
        List<Sentence> messages = this.talkManager.getSentences();
        GasServiceTest.assertEquals(3, messages.size());
        for (Sentence message : messages) {
            GasServiceTest.assertEquals("file.exported", message.getDescription());
        }
        File[] listFilesMiddleware = MW_FOLDER.listFiles();
        File[] listFilesReseller2 = RESELLER_FOLDER.listFiles();
        File[] listFilesSave = SAVE_FOLDER.listFiles();
        GasServiceTest.assertEquals(1, listFilesMiddleware.length);
        GasServiceTest.assertEquals(1, listFilesReseller2.length);
        GasServiceTest.assertEquals(3, listFilesSave.length);
        TextTestHelper.checkTextFile(listFilesReseller2[0], "UTF-8", NO_CRM);
        TextTestHelper.checkTextFile(listFilesMiddleware[0], "UTF-8", CRM);
    }
}

