/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.gas;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.services.gas.OutputHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import org.homelinux.elabor.dom.DomHelper;
import org.homelinux.elabor.file.InvalidFileFormat;
import org.w3c.dom.Element;

class CsvOutputHandler
implements OutputHandler {
    private PrintWriter writer;
    private File file;
    private final DateFormat timestampFormat = StrategyCommonHelper.getTimestampFormat();

    public CsvOutputHandler(PrebillingConfiguration configuration, String idEsecuzione, String id) throws FileNotFoundException {
        File outputFolder = ConfigurationHelper.getResellerTmpImportFolder(configuration, idEsecuzione, id, Funzionalita.GAS);
        String time = this.timestampFormat.format(new Date());
        this.file = new File(outputFolder, "Voltura_D06-" + id + "-" + time + ".csv");
        this.writer = new PrintWriter(this.file);
        this.writer.println("D06;PDR;DATAEVASIO;MATRICOLA1");
    }

    @Override
    public String printD65(Element docElement) throws InvalidFileFormat {
        Element tecElement = DomHelper.getElement(docElement, "DatiTecnici", false);
        Element letElement = DomHelper.getElement(docElement, "DatiLettura", false);
        this.writer.print(";");
        this.printElement(tecElement, "cod_pdr");
        this.printElement(tecElement, "data_att_contr");
        this.writer.print(";");
        this.printElement(tecElement, "matr_mis");
        this.printElement(tecElement, "classe_gruppo_mis");
        this.printElement(tecElement, "n_cifre_mis");
        this.printElement(letElement, "segn_mis_sost");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.printElement(letElement, "matr_conv");
        this.writer.print(";");
        this.printElement(letElement, "n_cifre_conv");
        this.printElement(letElement, "segn_conv");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print("1;");
        this.writer.print(";");
        this.printElement(tecElement, "vol_annuo_sost");
        this.printElement(letElement, "coeff_corr");
        this.writer.print(";");
        this.writer.print("VTG;");
        this.writer.print(";");
        this.writer.print(";");
        this.printElement(letElement, "tipo_lettura");
        this.writer.print(";");
        this.writer.print(";");
        this.printElement(letElement, "gruppo_mis_int");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print(";");
        this.writer.print("*");
        this.writer.println();
        return this.file.getName();
    }

    private void printElement(Element element, String name) {
        try {
            String value = DomHelper.getTextElement(element, name);
            this.writer.print(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writer.print(";");
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Override
    public void closePod() {
    }
}

