/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.consumi;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.prebilling.common.MisuraException;
import biz.elabor.prebilling.common.model.ContrattiHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.ContrattoEle;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.model.InvalidCurvaRilevazioniException;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Lettura;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.GetCalendarStrategy;
import biz.elabor.prebilling.services.letture.ConsumiHelper;
import biz.elabor.prebilling.services.letture.PdoContratto;
import biz.elabor.prebilling.services.letture.PodConsumi;
import biz.elabor.prebilling.services.tariffe.CalendarException;
import biz.elabor.prebilling.services.tariffe.ConsumiException;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.GetComuniStrategy;
import biz.elabor.prebilling.services.tariffe.GetPraStrategy;
import biz.elabor.prebilling.services.tariffe.InvalidSegnantiException;
import biz.elabor.prebilling.services.tariffe.SmisException;
import biz.elabor.prebilling.services.tariffe.TariffeHelper;
import biz.elabor.prebilling.util.Results;
import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.BasicListMap;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.tools.StringUtils;

public abstract class ConsumiMultipodService
implements Results {
    private static final DateFormat DATE_FORMAT = StrategyHelper.getDataFormat();
    private static final DecimalFormat MESE_NUM_FORMAT = StrategyHelper.getMeseNumFormat();
    private static final Destinatari DESTINATARI = Destinatari.DISPATCHER;
    protected static final String CONSUMI_MULTIPOD = "CONSUMI_MULTIPOD";
    protected final List<String> codiciPod;
    protected final Date dataInizio;
    protected final Date dataFine;
    private final String reseller;
    private final PrebillingDao prebillingDao;
    private final GiadaDao giadaDao;
    private final MisureDao misureDao;
    protected final TalkManager talkManager;
    protected PrebillingConfiguration configuration;
    protected File file;
    private final boolean excludeStimatoFineConsumi;

    public ConsumiMultipodService(List<String> codiciPod, Date dataInizio, Date dataFine, String reseller, PrebillingDao prebillingDao, GiadaDao giadaDao, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager, boolean excludeStimatoFineConsumi) {
        this.codiciPod = codiciPod;
        this.dataInizio = dataInizio;
        this.dataFine = dataFine;
        this.reseller = reseller;
        this.prebillingDao = prebillingDao;
        this.giadaDao = giadaDao;
        this.misureDao = misureDao;
        this.configuration = configuration;
        this.talkManager = talkManager;
        this.file = null;
        this.excludeStimatoFineConsumi = excludeStimatoFineConsumi;
    }

    public void execute() {
        ServiceStatus status = new ServiceStatus(this.configuration, this.prebillingDao);
        new GetCalendarStrategy(this.configuration, this.prebillingDao).execute(status);
        new GetComuniStrategy(this.misureDao).execute(status);
        new GetPraStrategy(this.misureDao, true).execute(status);
        ElaborCalendar calendar = new ElaborCalendar(this.dataFine);
        int annoRif = calendar.getAnno();
        Month meseRif = calendar.getMese();
        BasicListMap<Date, PdoContratto> pdoMap = new BasicListMap<Date, PdoContratto>();
        for (String codicePod : this.codiciPod) {
            WorkingPeriod wp = new WorkingPeriod(this.dataInizio);
            Date dataInizioMese = wp.getStartDate();
            while (!dataInizioMese.after(this.dataFine)) {
                Message sentence;
                int anno = wp.getYear();
                Month mese = wp.getMonth();
                List<PodConsumi> podConsumiList = this.giadaDao.getPodConsumi(codicePod, anno, mese);
                Pdo pdo = null;
                try {
                    PodConsumi contratto = this.getContratto(podConsumiList, codicePod, anno, mese);
                    try {
                        pdo = this.misureDao.getPdo(codicePod, anno, mese, null, StrategyHelper.STATI_ALL);
                        this.fixMissingDays(pdo, contratto, annoRif, meseRif, status);
                    }
                    catch (DataNotFoundException exc) {
                        if ("comune.notFound".equals(exc.getMessage()) || podConsumiList.isEmpty()) {
                            throw exc;
                        }
                        List<Lettura> letture = this.misureDao.getLetture(codicePod, dataInizioMese);
                        try {
                            pdo = this.createPdoFromLetture(contratto, letture, anno, mese, status);
                        }
                        catch (ConsumiException excConsumi) {
                            Message sentence2 = new Message(CONSUMI_MULTIPOD, excConsumi.getMessage());
                            sentence2.addParam(DATE_FORMAT.format(excConsumi.getInizioPeriodo()));
                            sentence2.addParam(DATE_FORMAT.format(excConsumi.getFinePeriodo()));
                            sentence2.addParam(DATE_FORMAT.format(excConsumi.getDataPrevRilevazione()));
                            sentence2.addParam(DATE_FORMAT.format(excConsumi.getDataRilevazione()));
                            sentence2.addParam(null);
                            sentence2.addParam(null);
                            sentence2.addParam(excConsumi.getCodicePod());
                            this.talkManager.addSentence(sentence2);
                        }
                    }
                    PdoContratto pdoContratto = new PdoContratto(pdo, contratto);
                    pdoMap.add(dataInizioMese, pdoContratto);
                }
                catch (DataNotFoundException exc) {
                    sentence = new Message(CONSUMI_MULTIPOD, exc.getMessage());
                    sentence.addParam(exc.getKey());
                    sentence.addParam(codicePod);
                    this.talkManager.addSentence(sentence);
                }
                catch (CalendarNotFoundException exc) {
                    sentence = new Message(CONSUMI_MULTIPOD, exc.getMessage());
                    sentence.addParam(exc.getKey());
                    sentence.addParam(exc.getCodicePod());
                    this.talkManager.addSentence(sentence);
                }
                catch (InvalidSegnantiException exc) {
                    sentence = new Message(CONSUMI_MULTIPOD, exc.getMessage());
                    sentence.addParam(exc.getCodicePod());
                    sentence.addParam(DATE_FORMAT.format(exc.getDataIniziale()));
                    sentence.addParam(DATE_FORMAT.format(exc.getDataFinale()));
                    sentence.addParam(exc.getCodicePod());
                    this.talkManager.addSentence(sentence);
                }
                catch (InvalidCurvaRilevazioniException exc) {
                    sentence = new Message(CONSUMI_MULTIPOD, exc.getMessage());
                    sentence.addParam(codicePod);
                    sentence.addParam(DATE_FORMAT.format(exc.getDate()));
                    this.talkManager.addSentence(sentence);
                }
                catch (MisuraException | CalendarException | SmisException exc) {
                    sentence = new Message(CONSUMI_MULTIPOD, exc.getMessage());
                    this.talkManager.addSentence(sentence);
                }
                wp = wp.next();
                dataInizioMese = wp.getStartDate();
            }
        }
        String title = this.codiciPod.size() == 1 ? this.codiciPod.get(0) : "multipod";
        this.printConsumi(title, pdoMap);
    }

    protected abstract void printConsumi(String var1, ListMap<Date, PdoContratto> var2);

    public PodConsumi getContratto(List<PodConsumi> podConsumiList, String codicePod, int anno, Month mese) throws DataNotFoundException {
        PodConsumi contratto;
        PodConsumi podConsumi = contratto = podConsumiList.isEmpty() ? null : podConsumiList.get(0);
        if (contratto == null || !StringUtils.isEmpty(this.reseller) && !contratto.getReseller().equals(this.reseller)) {
            String key = String.valueOf(codicePod) + " - " + anno + "/" + MESE_NUM_FORMAT.format(mese.getIndex());
            throw new DataNotFoundException("pod.notfound", key, ErroriElaborazione.POD_NOTFOUND.ordinal());
        }
        return contratto;
    }

    private Pdo createPdoFromLetture(PodConsumi contratto, List<Lettura> letture, int anno, Month mese, ServiceStatus status) throws ConsumiException, DataNotFoundException, SmisException, MisuraException, CalendarNotFoundException, CalendarException, InvalidCurvaRilevazioniException {
        List<Lettura> lettureDataSingola = TariffeHelper.getRilevazioniDataSingola(letture);
        RilMese rilMese = this.buildRilmeseFromLetture(contratto, false, anno, mese, lettureDataSingola, status);
        return new Pdo(null, false, rilMese, null, null, null, null, null, null, null, null, null, null);
    }

    private RilMese buildRilmeseFromLetture(PodConsumi contratto, boolean forfettario, int anno, Month mese, List<Lettura> letture, ServiceStatus status) throws ConsumiException, DataNotFoundException, SmisException, MisuraException, CalendarNotFoundException, CalendarException, InvalidCurvaRilevazioniException {
        ArrayList<ContrattoEle> contrattiBatch = new ArrayList<ContrattoEle>();
        Date inizioConsumi = CalendarTools.max(ContrattiHelper.getInizioTariffa(contratto, anno, mese), this.dataInizio);
        Date fineConsumi = CalendarTools.min(ContrattiHelper.getFineTariffa(anno, mese, contratto), this.dataFine);
        return TariffeHelper.buildRilmeseFromLetture(contratto, forfettario, inizioConsumi, fineConsumi, letture, contrattiBatch, true, status);
    }

    private void fixMissingDays(Pdo pdo, PodConsumi contratto, int annoRif, Month meseRif, ServiceStatus status) throws DataNotFoundException, InvalidSegnantiException, SmisException, CalendarException, CalendarNotFoundException, InvalidCurvaRilevazioniException {
        String codicePod = pdo.getCodicePod();
        RilMese rilMese = pdo.getRilMese();
        int anno = rilMese.getAnno();
        Month mese = rilMese.getMese();
        Date inizioMese = CalendarTools.getDate(anno, mese, 1);
        Date fineMese = CalendarTools.getEndDate(anno, mese);
        String pivaDistr = pdo.getPivaDistributore();
        String codComIst = contratto.getCdComIst();
        String codiceOfferta = contratto.getCodiceOfferta();
        Date dataLetPre = contratto.getDataUltimaLettura();
        ConsumiHelper.fixMissingDays(rilMese, codicePod, inizioMese, fineMese, pivaDistr, codComIst, codiceOfferta, null, dataLetPre, annoRif, meseRif, status, DESTINATARI, this.misureDao, this.configuration, this.excludeStimatoFineConsumi);
    }

    @Override
    public void putResults(Map<String, Object> resultsMap) {
    }

    @Override
    public File getFile() {
        return this.file;
    }
}

