/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.consolidamento;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.ServiceStrategy;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.structures.listmap.ListMap;

public class GetPdoConsolidamentoStrategy
implements ServiceStrategy {
    private final ElaborCalendar month;
    private final String prefix;
    private final MisureDao misureDao;
    private final String onlyPod;

    public GetPdoConsolidamentoStrategy(String onlyPod, ElaborCalendar month, String prefix, MisureDao misureDao) {
        this.onlyPod = onlyPod;
        this.month = month;
        this.prefix = prefix;
        this.misureDao = misureDao;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        Logger logger = status.getLogger();
        logger.info("PDO codice pod " + this.onlyPod + " anno " + this.month.getAnno() + " mese " + (Object)((Object)this.month.getMese()) + " prefisso " + this.prefix);
        ListMap<String, Mno> pdo = this.misureDao.getPdoConsolidamento(this.onlyPod, this.month, this.prefix);
        status.setPdoConsolidamento(pdo);
        logger.info("PDO codice pod " + this.onlyPod + " anno " + this.month.getAnno() + " mese " + (Object)((Object)this.month.getMese()) + " prefisso " + this.prefix + ": " + pdo.size());
        return true;
    }
}

