/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.consolidamento;

import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.consolidamento.ConsolidateAbstractStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class ConsolidatePnoStrategy
extends ConsolidateAbstractStrategy {
    private static final List<String> FLUSSI = Arrays.asList("VNO2G", "AV2G", "AVR2G");

    public ConsolidatePnoStrategy(ElaborCalendar month, TalkManager talkManager) {
        super(month, talkManager);
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ListMap<String, Mno> pnoConsolidamento = status.getMnoConsolidamento();
        this.execute(pnoConsolidamento, status);
        return true;
    }

    @Override
    protected void addObsoleto(ServiceStatus status, MnoResult result) {
        status.addPnoObsoleto(result);
    }

    @Override
    protected void addSospeso(ServiceStatus status, MnoResult result) {
        status.addPnoSospeso(result);
    }

    @Override
    protected void addElaborato(ServiceStatus status, MnoResult result) {
        status.addPnoElaborato(result);
    }

    @Override
    protected void addEscluso(ServiceStatus status, MnoResult result) {
        status.addPnoEscluso(result);
    }

    @Override
    protected boolean checkConsolidate(Mno mno) {
        String codiceFlusso = mno.getCodiceFlusso().toUpperCase();
        String raccolta = mno.getRaccoltaEstesa().toUpperCase();
        return FLUSSI.contains(codiceFlusso) || raccolta.equals("V") && !codiceFlusso.equals("PNO2G");
    }

    @Override
    protected void extra(String codicePod, List<Mno> misure) {
        Collections.sort(misure, (mno1, mno2) -> {
            int value = mno2.getDataMisura().compareTo(mno1.getDataMisura());
            if (value == 0) {
                OrdineFlusso of1 = OrdineFlusso.valueOf(mno1.getCodiceFlusso());
                OrdineFlusso of2 = OrdineFlusso.valueOf(mno2.getCodiceFlusso());
                value = of2.compareTo(of1);
            }
            return value;
        });
    }

    private static enum OrdineFlusso {
        PNO2G,
        DS2G,
        RNO2G,
        VNO2G,
        DSR2G,
        AV2G,
        AVR2G,
        VP2G,
        VPR2G;

    }
}

