/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.consolidamento;

import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategyHelper;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public abstract class ConsolidateAbstractStrategy
implements ServiceStrategy {
    private final ElaborCalendar month;
    private final TalkManager talkManager;
    private final DateFormat dataFormat;

    protected abstract void addObsoleto(ServiceStatus var1, MnoResult var2);

    protected abstract void addSospeso(ServiceStatus var1, MnoResult var2);

    protected abstract void addElaborato(ServiceStatus var1, MnoResult var2);

    protected abstract void addEscluso(ServiceStatus var1, MnoResult var2);

    protected abstract boolean checkConsolidate(Mno var1);

    protected abstract void extra(String var1, List<Mno> var2);

    public ConsolidateAbstractStrategy(ElaborCalendar month, TalkManager talkManager) {
        this.month = month;
        this.talkManager = talkManager;
        this.dataFormat = StrategyHelper.getDataFormat();
    }

    protected void execute(ListMap<String, Mno> misureConsolidamento, ServiceStatus status) {
        for (Map.Entry entry : misureConsolidamento.entrySet()) {
            String codicePod = (String)entry.getKey();
            List misure = (List)entry.getValue();
            this.extra(codicePod, misure);
            this.execute(misure, status);
        }
    }

    protected void execute(List<Mno> misure, ServiceStatus status) {
        int anno = this.month.getAnno();
        Month mese = this.month.getMese();
        Date endDate = CalendarTools.getEndDate(anno, mese);
        Mno reale = null;
        Mno stimata = null;
        HashSet<Date> dates = new HashSet<Date>();
        for (Mno mno : misure) {
            Misura misura = mno.getMisura();
            if (this.checkConsolidate(mno)) {
                MnoResult result = this.buildResult(mno, ErroriElaborazione.OK);
                this.addElaborato(status, result);
                continue;
            }
            Date date = misura.getDate();
            if (dates.add(date)) {
                MnoResult result;
                ConsolidateAbstractStrategy.updatePotenza(stimata, mno);
                ConsolidateAbstractStrategy.updatePotenza(reale, mno);
                boolean misuraStimata = misura.isStimata();
                if (reale == null && stimata == null && misuraStimata && date.equals(endDate)) {
                    stimata = mno;
                    result = this.buildResult(mno, ErroriElaborazione.OK);
                    this.addElaborato(status, result);
                    continue;
                }
                if (reale == null && !misuraStimata) {
                    reale = mno;
                    result = this.buildResult(mno, ErroriElaborazione.OK);
                    this.addElaborato(status, result);
                    continue;
                }
                if (mno.getRaccoltaEstesa().equalsIgnoreCase("V")) {
                    result = this.buildResult(mno, ErroriElaborazione.OK);
                    this.addElaborato(status, result);
                    continue;
                }
                result = this.buildResult(mno, ErroriElaborazione.LETTURA2G_NON_ULTIMA);
                this.addEscluso(status, result);
                continue;
            }
            MnoResult result = this.buildResult(mno, ErroriElaborazione.OBSOLETO);
            this.addObsoleto(status, result);
        }
    }

    private static void updatePotenza(Mno validato, Mno mno) {
        double potenzaMax = mno.getPotenzaMax();
        if (validato != null) {
            validato.updatePotenzaMax(potenzaMax);
        }
    }

    private MnoResult buildResult(Mno mno, ErroriElaborazione errore) {
        String codicePod = mno.getCodicePod();
        Date dataMisura = mno.getDataMisura();
        String descrizione = this.getDescrizione(codicePod, dataMisura, errore);
        return new MnoResult(mno, errore, descrizione);
    }

    private String getDescrizione(String codicePod, Date dataMisura, ErroriElaborazione errore) {
        String descrizione;
        String message = errore.getMessage();
        if (message.isEmpty()) {
            descrizione = "";
        } else {
            Message sentence = new Message("consolidamento", message);
            sentence.addParam(codicePod);
            sentence.addParam(this.dataFormat.format(dataMisura));
            descrizione = this.talkManager.getMessage(sentence);
        }
        return descrizione;
    }
}

