/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common.statopod;

import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.letture.statopod.TabellaHandler;
import java.util.Date;

public class PdoTH
implements TabellaHandler {
    private final boolean azzeramento;

    public PdoTH(boolean azzeramento) {
        this.azzeramento = azzeramento;
    }

    @Override
    public boolean isFlmiscon(MisuraPod current) {
        Date dataMisura = current.getDataMisura();
        Pod pod = current.getPod();
        return pod.isMisuraAttiva(dataMisura);
    }

    @Override
    public boolean isFlmisrea(MisuraPod current) {
        Date dataMisura = current.getDataMisura();
        Pod pod = current.getPod();
        return pod.isMisuraReattiva(dataMisura);
    }

    @Override
    public boolean isFlmispot(MisuraPod current) {
        Date dataMisura = current.getDataMisura();
        Pod pod = current.getPod();
        return pod.isMisuraPotenza(dataMisura);
    }

    @Override
    public String getTabella() {
        return "MISURE_POD_ORARI";
    }

    @Override
    public boolean isOrario() {
        return true;
    }

    @Override
    public String getNuMatrA(StatoPod riferimento, MisuraPod current) {
        return riferimento.getNuMatrA();
    }

    @Override
    public String getNuMatrR(StatoPod riferimento, MisuraPod current) {
        return riferimento.getNuMatrR();
    }

    @Override
    public String getNuMatrP(StatoPod riferimento, MisuraPod current) {
        return riferimento.getNuMatrP();
    }

    @Override
    public String getNuMatrBio(StatoPod riferimento, MisuraPod current) {
        return riferimento.getNuMatricBio();
    }

    @Override
    public String getModContatoreA(StatoPod riferimento, MisuraPod current) {
        int tensione = Integer.parseInt(current.getTensione());
        return StrategyHelper.getKeyCdConMag(tensione, this.azzeramento, null, current);
    }

    @Override
    public String getModContatoreR(StatoPod riferimento, MisuraPod current) {
        int tensione = Integer.parseInt(current.getTensione());
        return StrategyHelper.getKeyCdConMag(tensione, this.azzeramento, null, current);
    }

    @Override
    public String getModContatoreP(StatoPod riferimento, MisuraPod current) {
        int tensione = Integer.parseInt(current.getTensione());
        return StrategyHelper.getKeyCdConMag(tensione, this.azzeramento, null, current);
    }

    @Override
    public String getModContatoreBio(StatoPod riferimento, MisuraPod current) {
        return "";
    }

    @Override
    public boolean isAzzeramento() {
        return this.azzeramento;
    }
}

