/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.ExtendedLT;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.DispatcherHandler;
import biz.elabor.prebilling.services.common.ExtendedLTHandler;
import biz.elabor.prebilling.services.common.GestFile16Helper;
import biz.elabor.prebilling.services.common.ResellerHandler;
import biz.elabor.prebilling.services.letture.MisuraMno;
import biz.elabor.prebilling.services.riallineamento.RiallMno;
import biz.elabor.prebilling.util.MapWriter;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.homelinux.elabor.structures.listmap.SafeListMap;

public class WriteGestfile16Service {
    private final PrebillingConfiguration configuration;
    private final ExtendedLTHandler dispatcherHandler;

    public WriteGestfile16Service(PrebillingConfiguration configuration, ServiceStatus status) {
        this.configuration = configuration;
        SafeListMap<String, Prestazione> prestazioni = status.getPrestazioni();
        this.dispatcherHandler = new DispatcherHandler(prestazioni);
    }

    public void writeDisallineate(MapWriter writer, List<MisuraMno> misureDisallineate) {
        Set<String> tarDisDom = this.configuration.getTarDisDom();
        for (MisuraMno misuraPod : misureDisallineate) {
            Mno mno = misuraPod.getMno();
            Pod pod = misuraPod.getPod();
            boolean checkReattiva = StrategyHelper.checkReattiva(pod, tarDisDom);
            RiallMno misura = new RiallMno(mno, !checkReattiva);
            String matricolaAtt = misura.getMatricolaAtt();
            String matricolaRea = misura.getMatricolaRea();
            String matricolaPot = misura.getMatricolaPot();
            String[] matrAnte = new String[]{matricolaAtt, matricolaRea, matricolaPot};
            Misura misAnte = misura.getMisura();
            GestFile16Helper.write(pod, false, matrAnte, misAnte, misura, "5", "1", writer, this.configuration);
        }
    }

    public void writeTecnicheDispatcher(MapWriter mapWriter, List<ExtendedLT> misureTecniche) {
        this.writeTecniche(mapWriter, misureTecniche, this.dispatcherHandler);
    }

    public void writeTecnicheReseller(MapWriter mapWriter, List<ExtendedLT> misureTecniche) {
        ResellerHandler resellerHandler = new ResellerHandler();
        this.writeTecniche(mapWriter, misureTecniche, resellerHandler);
    }

    public void writeRiconfigurazioniVoltureIV(MapWriter mapWriter, List<ExtendedLT> riconfigurazioni) {
        ResellerHandler handler = new ResellerHandler();
        for (ExtendedLT lettura : riconfigurazioni) {
            if (!handler.check(lettura)) continue;
            Pod pod = lettura.getPod();
            MisuraNonoraria mnoSucc = lettura.getMno();
            MisuraNonoraria mnoPrev = lettura.getMnoPrev();
            Date dataPrev = mnoPrev.getDataMisura();
            String tipoRec = handler.getRipoRec(lettura);
            String[] matrAnte = new String[]{pod.isMisuraAttiva(dataPrev) ? mnoPrev.getMatricolaAtt() : "", pod.isMisuraReattiva(dataPrev) ? mnoPrev.getMatricolaRea() : "", pod.isMisuraPotenza(dataPrev) ? mnoPrev.getMatricolaPot() : ""};
            String codiceFlusso = mnoPrev.getCodiceFlusso();
            Misura misAnte = new Misura(dataPrev, false, 3, codiceFlusso);
            GestFile16Helper.write(pod, false, matrAnte, misAnte, mnoSucc, tipoRec, "1", mapWriter, this.configuration);
        }
    }

    private void writeTecniche(MapWriter mapWriter, List<ExtendedLT> misureTecniche, ExtendedLTHandler handler) {
        for (ExtendedLT lettura : misureTecniche) {
            if (!handler.check(lettura)) continue;
            Pod pod = lettura.getPod();
            MisuraNonoraria mnoSucc = lettura.getMno();
            Date dataSucc = mnoSucc.getDataMisura();
            boolean checkReattiva = this.checkReattiva(pod, dataSucc);
            boolean hasReattivaSucc = handler.checkReattiva(checkReattiva);
            MisuraNonoraria mnoPrev = lettura.getMnoPrev();
            Date dataPrev = mnoPrev.getDataMisura();
            boolean hasReattivaPrev = this.checkReattiva(pod, dataPrev);
            String tipoRec = handler.getRipoRec(lettura);
            GestFile16Helper.writeSostituzioneRiprogrammazione(mapWriter, lettura, tipoRec, hasReattivaPrev, hasReattivaSucc, this.configuration);
        }
    }

    private boolean checkReattiva(Pod pod, Date date) {
        Set<String> tarDisDom = this.configuration.getTarDisDom();
        return GestFile16Helper.checkReattiva(pod, date, tarDisDom);
    }
}

