/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.Pratica;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.AbstractVTTPManager;
import biz.elabor.prebilling.services.common.PraticaTardivaHandler;
import biz.elabor.prebilling.services.common.TipoPrestazione;
import biz.elabor.prebilling.services.common.statopod.AbstractStatoPodHandler;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.letture.statopod.SwitchoutStatoPodBuilder;
import biz.elabor.prebilling.services.switched.SnmStatoPodHandler;
import biz.elabor.prebilling.services.volture.SelectVoltureNonOrarieStrategy;
import biz.elabor.prebilling.web.letture.SpecificaPrestazione;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

class VT1_4TPManager
extends AbstractVTTPManager {
    private static final List<String> CHECK_FLUSSI = Arrays.asList("D65");
    private static final Iterable<String> FLUSSI_NO_PRIORITA_1 = Arrays.asList("VNO", "RNV", "VNO2G");
    private static final Iterable<String> FLUSSI_NO_PRIORITA_2 = Arrays.asList("PNO", "PNO2G", "RNO", "RNO2G", "VNO2G");
    private static final Iterable<String> FLUSSI_O_PRIORITA_2 = Arrays.asList("PDO2G", "RFO2G");
    private static final Iterable<StatoMisure> STATI_PRIORITA_1 = Arrays.asList(StatoMisure.VALIDATO, StatoMisure.SOSPESO, StatoMisure.ESCLUSO);
    private static final Iterable<StatoMisure> STATI_PRIORITA_2 = Arrays.asList(StatoMisure.VALIDATO, StatoMisure.SOSPESO, StatoMisure.ESCLUSO, StatoMisure.OBSOLETO, StatoMisure.VALIDATO);

    VT1_4TPManager() {
    }

    @Override
    public <T extends MisuraPod> AbstractStatoPodHandler<T> getStatoPodHandler(SwitchoutStatoPodBuilder<T> builder) {
        return builder.buildVT1();
    }

    @Override
    public SpecificaPrestazione getSpecificaPrestazione(TipoPrestazione tipoPrestazione, Map<String, SpecificaPrestazione> specifiche) {
        return specifiche.get("VT1");
    }

    @Override
    public Mno getMno(Pod pod, Pratica pratica, int scostamento, PraticaTardivaHandler handler, MisureDao misureDao) throws DataNotFoundException {
        Mno mno;
        SpecificaTecnica specificaTecnica = pratica.getSpecificaTecnica();
        Date dataPratica = specificaTecnica.getData();
        String codicePod = pod.getCodice();
        try {
            mno = misureDao.getMnoPraticaTardiva(codicePod, dataPratica, 0, FLUSSI_NO_PRIORITA_1, STATI_PRIORITA_1, NO_TIPI_DATO, ALL_RACCOLTE, "ASC");
        }
        catch (DataNotFoundException e1) {
            Date dataMisura = CalendarTools.previousDay(dataPratica);
            try {
                mno = misureDao.getMnoPraticaTardiva(codicePod, dataMisura, 0, FLUSSI_NO_PRIORITA_1, STATI_PRIORITA_1, NO_TIPI_DATO, ALL_RACCOLTE, "ASC");
            }
            catch (DataNotFoundException e2) {
                try {
                    mno = misureDao.getMnoPraticaTardiva(codicePod, dataMisura, scostamento, FLUSSI_NO_PRIORITA_2, STATI_PRIORITA_2, E_TIPI_DATO, ALL_RACCOLTE, "ASC");
                }
                catch (DataNotFoundException e3) {
                    try {
                        mno = misureDao.getMo2GRPraticaTardiva(codicePod, dataMisura, scostamento, FLUSSI_O_PRIORITA_2, STATI_PRIORITA_2, E_TIPI_DATO, ALL_RACCOLTE, "ASC");
                    }
                    catch (DataNotFoundException e4) {
                        try {
                            mno = misureDao.getMnoPraticaTardiva(codicePod, dataMisura, scostamento, FLUSSI_NO_PRIORITA_2, STATI_PRIORITA_1, S_TIPI_DATO, ALL_RACCOLTE, "ASC");
                        }
                        catch (DataNotFoundException e5) {
                            try {
                                mno = misureDao.getMo2GRPraticaTardiva(codicePod, dataMisura, scostamento, FLUSSI_O_PRIORITA_2, STATI_PRIORITA_1, S_TIPI_DATO, ALL_RACCOLTE, "ASC");
                            }
                            catch (DataNotFoundException e6) {
                                String key = String.valueOf(pratica.getCodicePod()) + " " + StrategyHelper.getDataFormat().format(dataPratica);
                                throw new DataNotFoundException("misura.notfound", key);
                            }
                        }
                    }
                }
            }
        }
        mno.setDataMisura(dataPratica);
        mno.setDataPrestazione(dataPratica);
        return mno;
    }

    @Override
    public void handlePrestazioneTardiva(Funzionalita funzionalita, TipoPrestazione tipoPrestazione, String destinazione, Pod pod, Pratica pratica, Mno mno, StatusTransaction transaction, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager) throws StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException, DataNotFoundException {
        SnmStatoPodHandler statoPodHandler = new SnmStatoPodHandler(misureDao, CHECK_FLUSSI, "SE1");
        SelectVoltureNonOrarieStrategy.riconfigurazioneVolturaIV(mno, pod, transaction, configuration, statoPodHandler);
    }
}

