/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.Pratica;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.common.PraticaTardivaHandler;
import biz.elabor.prebilling.services.common.TipoPrestazione;
import biz.elabor.prebilling.services.common.VT3TPManager;
import biz.elabor.prebilling.services.common.statopod.AbstractStatoPodHandler;
import biz.elabor.prebilling.services.letture.statopod.SwitchoutStatoPodBuilder;
import biz.elabor.prebilling.web.letture.SpecificaPrestazione;
import java.util.Date;
import java.util.Map;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.DataNotFoundException;

class VPTPManager
extends VT3TPManager {
    VPTPManager() {
    }

    @Override
    public SpecificaPrestazione getSpecificaPrestazione(TipoPrestazione tipoPrestazione, Map<String, SpecificaPrestazione> specifiche) {
        return specifiche.get("VP3");
    }

    @Override
    public Mno getMno(Pod pod, Pratica pratica, int scostamento, PraticaTardivaHandler handler, MisureDao misureDao) throws DataNotFoundException {
        Mno mno = super.getMno(pod, pratica, scostamento, handler, misureDao);
        SpecificaTecnica specificaTecnica = pratica.getSpecificaTecnica();
        Date dataPratica = specificaTecnica.getData();
        Date dataMisura = CalendarTools.previousDay(dataPratica);
        mno.setDataMisura(dataMisura);
        return mno;
    }

    @Override
    public <T extends MisuraPod> AbstractStatoPodHandler<T> getStatoPodHandler(SwitchoutStatoPodBuilder<T> builder) {
        return builder.buildVP();
    }
}

