/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.model.InvalidCurvaRilevazioniException;
import biz.elabor.prebilling.model.indici.InvalidCurvaIndiciException;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.tariffe.MisuraFasceQuantita;
import biz.elabor.prebilling.model.tariffe.PrezzoExtractor;
import biz.elabor.prebilling.model.tariffe.TariffaMonoraria;
import biz.elabor.prebilling.services.common.AbstractTariffeAccumulator;
import biz.elabor.prebilling.services.common.IncoherentKException;
import biz.elabor.prebilling.services.tariffe.SmisException;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.ElaborCalendar;

public class TariffeMonorarieAccumulator
extends AbstractTariffeAccumulator {
    public TariffeMonorarieAccumulator(RilMese rilMese, double coeffUM, Date startDate, double qtconfla, double KAttiva, double[] prezziDefault, boolean perdite, double coeffPerdite, double emtaruni, double emspread, double emspreneg, List<Mno> mnoList) {
        super(rilMese, coeffUM, startDate, qtconfla, KAttiva, prezziDefault, perdite, coeffPerdite, emtaruni, emspread, emspreneg, mnoList);
    }

    @Override
    public MisuraFasceQuantita buildMisura(Date date, PrezzoExtractor extractor) throws InvalidCurvaRilevazioniException, InvalidCurvaIndiciException, IncoherentKException, SmisException {
        Date expectedDate = this.expected.getDate();
        TariffaMonoraria tariffa = new TariffaMonoraria(null, this.coeffUM, this.qtconfla, this.prezziDefault, this.emtaruni, this.emspread, this.emspreneg, extractor);
        while (this.curvaGiorno != null) {
            Date preDate = this.curvaGiorno.getData();
            if (!preDate.equals(expectedDate)) {
                Date tarDate = tariffa.getDate();
                if (tarDate == null) {
                    ElaborCalendar cal = new ElaborCalendar(preDate);
                    cal.addGiorni(-1);
                    tarDate = cal.getDate();
                    tariffa.setDate(preDate);
                }
                this.expected.setDate(preDate);
                break;
            }
            if (preDate.after(date)) break;
            tariffa.add(this.curvaGiorno, this.rilGiorno);
            tariffa.setDate(preDate);
            try {
                this.next();
            }
            catch (InvalidCurvaRilevazioniException exc) {
                if (preDate.before(date)) {
                    throw exc;
                }
                this.rilGiorno = null;
            }
            this.expected.addGiorni(1);
            expectedDate = this.expected.getDate();
        }
        if (tariffa.getDate() == null) {
            tariffa.setDate(date);
        }
        return tariffa;
    }
}

