/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.Pratica;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.AbstractBasicTPManager;
import biz.elabor.prebilling.services.common.PraticaTardivaHandler;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.DataNotFoundException;

class SE3RC1TPManager
extends AbstractBasicTPManager {
    SE3RC1TPManager() {
    }

    @Override
    public boolean check(Date dataPratica, Date timeout) {
        return false;
    }

    @Override
    public Mno getMno(Pod pod, Pratica pratica, PraticaTardivaHandler handler, MisureDao misureDao) throws DataNotFoundException {
        return this.getMno(pod, pratica, 0, handler, misureDao);
    }

    @Override
    public Mno getMno(Pod pod, Pratica pratica, int scostamento, PraticaTardivaHandler handler, MisureDao misureDao) throws DataNotFoundException {
        Date dataPratica = pratica.getSpecificaTecnica().getData();
        String codicePod = pod.getCodice();
        Date data = CalendarTools.previousDay(dataPratica);
        List<Mno> mnoList = misureDao.getPnoSoTardivo(data, scostamento, codicePod);
        if (mnoList.isEmpty()) {
            mnoList = misureDao.getPdo2GRSoTardivo(data, scostamento, codicePod);
        }
        if (mnoList.isEmpty()) {
            String key = String.valueOf(codicePod) + " " + StrategyHelper.getDataFormat().format(dataPratica);
            throw new DataNotFoundException("misura.notfound", key);
        }
        Mno mno = mnoList.get(0);
        mno.setDataMisura(data);
        return mno;
    }
}

