/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.model.giada.Rcu;
import java.util.Date;
import org.homelinux.elabor.db.DataNotFoundException;

public class MatricoleHelper {
    private MatricoleHelper() {
    }

    public static String getMatrFromSnf(String matrSnf) {
        return matrSnf == null ? "" : matrSnf.trim();
    }

    public static String getMatrFromRcu(String codicePod, Date dataMisura, GiadaDao giadaDao) {
        String matricola;
        try {
            Rcu rcu = giadaDao.getRcu(codicePod, dataMisura);
            matricola = rcu.getMatricolaAtt();
            matricola = matricola == null ? "" : matricola.trim();
        }
        catch (DataNotFoundException e2) {
            matricola = "";
        }
        return matricola;
    }

    public static String buildMatricola(String codicePod, Date date, String matrSnf, GiadaDao giadaDao) {
        String matricolaAtt = MatricoleHelper.getMatrFromSnf(matrSnf);
        if (matricolaAtt.length() < 16) {
            String matricolaAttRcu = MatricoleHelper.getMatrFromRcu(codicePod, date, giadaDao);
            matricolaAtt = matricolaAtt.length() == 9 && matricolaAttRcu.length() == 8 ? String.valueOf(matricolaAtt) + matricolaAttRcu : (matricolaAttRcu.length() >= 6 ? matricolaAttRcu : "");
        }
        return matricolaAtt;
    }
}

