/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.TestServiceStatus;
import biz.elabor.prebilling.dao.NullMockGiadaDao;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.RigaPod;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.services.riallineamento.GetAllPodStrategy;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;

public class GetAllPodStrategyTest
extends TestCase {
    private static final String DISP_1 = "disp1";
    private static final String DISP_2 = "disp2";
    private static final String POD_1 = "pod1";
    private static final String POD_2 = "pod2";

    public void testExecute() throws DataNotFoundException {
        TestConfiguration configuration = new TestConfiguration();
        TestServiceStatus status = new TestServiceStatus(configuration);
        GetPodMockGiadaDao dao = new GetPodMockGiadaDao();
        GetAllPodStrategy strategy = new GetAllPodStrategy(2018, Month.JUNE, configuration, dao);
        GetAllPodStrategyTest.assertTrue(strategy.execute(status));
        DefaultPodMap pods = status.getAllPods();
        Pod pod11 = pods.get(POD_1);
        GetAllPodStrategyTest.assertEquals(POD_1, pod11.getCodice());
        List<SpecificaTecnica> dates = pod11.getSpecificheTecniche();
        Iterator<SpecificaTecnica> iterator = dates.iterator();
        GetAllPodStrategyTest.assertEquals(CalendarTools.getDate(2018, Month.JUNE, 10), iterator.next().getData());
        GetAllPodStrategyTest.assertEquals(CalendarTools.getDate(2018, Month.JUNE, 20), iterator.next().getData());
        Pod pod22 = pods.get(POD_2);
        GetAllPodStrategyTest.assertEquals(POD_2, pod22.getCodice());
        GetAllPodStrategyTest.assertEquals(DISP_2, pod22.getDispatcher());
        dates = pod22.getSpecificheTecniche();
        GetAllPodStrategyTest.assertTrue(dates.isEmpty());
    }

    class GetPodMockGiadaDao
    extends NullMockGiadaDao {
        GetPodMockGiadaDao() {
        }

        @Override
        public List<RigaPod> getRighePod(int anno, Month mese, String cclettur) {
            ArrayList<RigaPod> righe = new ArrayList<RigaPod>();
            Date dataInizio = CalendarTools.getDate(2018, Month.JANUARY, 1);
            Date dataVoltura = CalendarTools.getDate(2018, Month.JUNE, 10);
            Date dataFine = CalendarTools.getDate(2018, Month.JUNE, 20);
            RigaPod riga = new RigaPod(GetAllPodStrategyTest.POD_1, null, false, 0, dataInizio, null, null, null, true, true, true, null, true, null, null, GetAllPodStrategyTest.DISP_1, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, false, dataInizio, null, null);
            righe.add(riga);
            riga = new RigaPod(GetAllPodStrategyTest.POD_1, null, false, 0, dataInizio, dataVoltura, null, dataFine, true, true, true, null, true, null, null, GetAllPodStrategyTest.DISP_1, null, 0.0, anno, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, false, dataInizio, null, null);
            righe.add(riga);
            riga = new RigaPod(GetAllPodStrategyTest.POD_2, null, false, 0, dataInizio, null, null, null, true, true, true, null, true, null, null, GetAllPodStrategyTest.DISP_2, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, false, dataInizio, null, null);
            righe.add(riga);
            riga = new RigaPod("xxx", null, false, 0, dataInizio, null, null, null, true, true, true, null, true, null, null, GetAllPodStrategyTest.DISP_2, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, false, dataInizio, null, null);
            righe.add(riga);
            return righe;
        }
    }
}

