/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.utils.ExportHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.ExtendedLT;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.model.misure.MisureHelper;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.riallineamento.RiallMno;
import biz.elabor.prebilling.util.DefaultMapWriter;
import biz.elabor.prebilling.util.MapWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.text.Format;
import org.homelinux.elabor.tools.MathUtils;

public class GestFile16Helper {
    private static final String TERM_DOS = "\r\n";
    private static final DateFormat OUTPUT_DATE_FORMAT = new SimpleDateFormat("ddMMyyyy");
    private static final DateFormat SHORT_DATE_FORMAT = new SimpleDateFormat("dd/MM/yy");
    private static final DecimalFormat OUTPUT_MISURE_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "+000000000.000");
    private static final DecimalFormat OUTPUT_K_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "+00000000.00000");

    public static void printGestFile16Header(PrintWriter writer, String sottoTipo, int lunghezzaMatricola) {
        writer.print("@16C");
        writer.print(ExportHelper.fixedLength(sottoTipo, 20));
        writer.print(ExportHelper.fixedLength("", 1032 + lunghezzaMatricola * 10));
        writer.print("S");
        writer.print(TERM_DOS);
    }

    public static void writeMisura(PrintWriter writer, Pod pod, Misura misAnte, MisuraNonoraria misura, String tipoRec, PrebillingConfiguration configuration, boolean checkReattiva) {
        Date dataMisura = misAnte.getDate();
        Date dataPratica = CalendarTools.nextDay(dataMisura);
        String matricola = pod.getMatricola(dataPratica);
        if (matricola == null || matricola.length() < 17 || matricola.startsWith("ORARIA") || matricola.startsWith("FITTIZIA")) {
            matricola = pod.isOrario() ? "ORARIA" : "FITTIZIA";
        }
        String[] matrAnte = new String[]{matricola, matricola, matricola};
        RiallMno mno = new RiallMno(misura, !checkReattiva);
        DefaultMapWriter mapWriter = new DefaultMapWriter();
        String codiceFlusso = misura.getCodiceFlusso();
        String regime = misura.getRegime();
        boolean azzeramento = codiceFlusso.equals("PDO2G") && "NR".equals(regime);
        GestFile16Helper.write(pod, azzeramento, matrAnte, misAnte, mno, tipoRec, "1", mapWriter, configuration);
        mapWriter.flush(writer);
    }

    public static Misura buildMisuraZero(int nFasce, String codiceFlusso, Set<String> id) {
        Date origin = new Date(0L);
        Misura misuraZero = new Misura(origin, false, nFasce, codiceFlusso, id, false, null);
        GestFile16Helper.fillMisuraZero(misuraZero);
        return misuraZero;
    }

    public static void fillMisuraZero(Misura misuraZero) {
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            misuraZero.setAttiva(fascia, 0.0, 0.0);
            misuraZero.setReattiva(fascia, 0.0, 0.0);
            misuraZero.setPotenza(fascia, 0.0, 0.0);
            ++n3;
        }
    }

    public static void write(Pod pod, boolean azzeramento, String[] matrAnte, Misura misAnte, MisuraNonoraria mno, String tipoRec, String cdEsecuz, MapWriter writer, PrebillingConfiguration configuration) {
        double[] lastAttiva = pod.getLastAttiva();
        double[] lastReattiva = pod.getLastReattiva();
        int lunghezzaMatricola = configuration.getLunghezzaMatricola();
        String codice = pod.getCodice();
        Date date = misAnte.getDate();
        boolean misAttivaPod = pod.isMisuraAttiva(date);
        boolean misReattivaPod = pod.isMisuraReattiva(date);
        boolean misPotenzaPod = pod.isMisuraPotenza(date);
        boolean misAttivaPno = mno.hasAttiva();
        boolean misReattivaPno = mno.hasReattiva();
        boolean misPotenzaPno = mno.hasPotenza();
        double ka = mno.getKa().doubleValue();
        double kr = mno.getKr().doubleValue();
        double kp = mno.getKp().doubleValue();
        String matrAtt = mno.getMatricolaAtt();
        String matrRea = mno.getMatricolaRea();
        String matrPot = mno.getMatricolaPot();
        Trattamento trattamento = mno.getTrattamento();
        int fasce = trattamento.getFasce();
        Date dataMisura = mno.getDataMisura();
        String tarDis = pod.getTarDis();
        String ordCdconmag = StrategyHelper.createCdconmag(pod, azzeramento, tarDis, mno, configuration);
        writer.print(codice, "%" + tipoRec, "");
        writer.print(codice, "    ", "");
        writer.print(codice, ExportHelper.fixedLength(codice, 30), "");
        writer.print(codice, ExportHelper.fixedLength("", 9), "");
        writer.print(codice, OUTPUT_DATE_FORMAT.format(dataMisura), "");
        writer.print(codice, "0000", "");
        writer.print(codice, "0000", "");
        writer.print(codice, cdEsecuz, "");
        writer.print(codice, ExportHelper.fixedLength("", 40), "");
        writer.print(codice, ExportHelper.fixedLength("", 40), "");
        writer.print(codice, misAttivaPno ? "1" : "0", "");
        writer.print(codice, misReattivaPno ? "1" : "0", "");
        writer.print(codice, misPotenzaPno ? "1" : "0", "");
        writer.print(codice, "0", "");
        boolean commerciale = mno.getMisura().hasCommerciale();
        writer.print(codice, commerciale ? "3" : "0", "");
        writer.print(codice, String.valueOf(fasce), "");
        writer.print(codice, "     ", "");
        String matrAttAnte = misAttivaPod ? matrAnte[0] : " ";
        writer.print(codice, ExportHelper.fixedLength(matrAttAnte, lunghezzaMatricola), "");
        writer.print(codice, "     ", "");
        String matrReaAnte = misReattivaPod ? matrAnte[1] : " ";
        writer.print(codice, ExportHelper.fixedLength(matrReaAnte, lunghezzaMatricola), "");
        writer.print(codice, "     ", "");
        String matrPotAnte = misPotenzaPod ? matrAnte[2] : " ";
        writer.print(codice, ExportHelper.fixedLength(matrPotAnte, lunghezzaMatricola), "");
        writer.print(codice, "     ", "");
        writer.print(codice, ExportHelper.fixedLength("", lunghezzaMatricola), "");
        writer.print(codice, "     ", "");
        writer.print(codice, ExportHelper.fixedLength("", lunghezzaMatricola), "");
        GestFile16Helper.printMisure(codice, misAttivaPod, misReattivaPod, misPotenzaPod, misAnte, lastAttiva, lastReattiva, true, writer, configuration, ka, kr, kp);
        writer.print(codice, " ", "");
        writer.print(codice, misAttivaPno ? ordCdconmag : "     ", "");
        String matricolaAttPno = misAttivaPno ? matrAtt : "";
        writer.print(codice, ExportHelper.fixedLength(matricolaAttPno, lunghezzaMatricola), "");
        writer.print(codice, " ", "");
        writer.print(codice, misReattivaPno ? ordCdconmag : "     ", "");
        String matricolaReaPno = misReattivaPno ? matrRea : "";
        writer.print(codice, ExportHelper.fixedLength(matricolaReaPno, lunghezzaMatricola), "");
        writer.print(codice, " ", "");
        writer.print(codice, misPotenzaPno ? ordCdconmag : "     ", "");
        String matricolaPotPno = misPotenzaPno ? matrPot : "";
        writer.print(codice, ExportHelper.fixedLength(matricolaPotPno, lunghezzaMatricola), "");
        writer.print(codice, " ", "");
        writer.print(codice, ExportHelper.fixedLength("", 5), "");
        writer.print(codice, ExportHelper.fixedLength("", lunghezzaMatricola), "");
        writer.print(codice, " ", "");
        writer.print(codice, commerciale ? ordCdconmag : "     ", "");
        String matrCommerciale = commerciale ? matrAtt : "";
        writer.print(codice, ExportHelper.fixedLength(matrCommerciale, lunghezzaMatricola), "");
        Misura misuraPno = mno.getMisura();
        GestFile16Helper.printMisure(codice, misAttivaPno, misReattivaPno, misPotenzaPno, misuraPno, lastAttiva, lastReattiva, true, writer, configuration, ka, kr, kp);
        writer.print(codice, ExportHelper.fixedLength("", 30), "");
        writer.print(codice, ExportHelper.fixedLength("", 8), "");
        writer.print(codice, ExportHelper.fixedLength("", 4), "");
        writer.print(codice, ExportHelper.fixedLength("", 4), "");
        writer.print(codice, " ", "");
        writer.print(codice, "1", "");
        writer.print(codice, SHORT_DATE_FORMAT.format(dataMisura), "");
        writer.print(codice, ExportHelper.fixedLength("", 4), "");
        writer.print(codice, "00", "");
        writer.print(codice, "00000000000000", "");
        writer.print(codice, "00000000000000", "");
        writer.print(codice, "9", "");
        writer.print(codice, ExportHelper.fixedLength("", 12), "");
        writer.print(codice, ExportHelper.fixedLength("", 12), "");
        writer.print(codice, "9", "");
        writer.print(codice, "9", "");
        writer.print(codice, "00000", "");
        writer.print(codice, ExportHelper.fixedLength("", 8), "");
        writer.print(codice, "0000", "");
        GestFile16Helper.printK(writer, codice, misAttivaPod && configuration.handleCoeffTrasf() ? pod.getKa(date) : 0.0);
        GestFile16Helper.printK(writer, codice, misReattivaPod && configuration.handleCoeffTrasf() ? pod.getKr(date) : 0.0);
        GestFile16Helper.printK(writer, codice, misPotenzaPod && configuration.handleCoeffTrasf() ? pod.getKp(date) : 0.0);
        GestFile16Helper.printK(writer, codice, misAnte.hasCommerciale() && configuration.handleCoeffTrasf() ? pod.getKa(date) : 0.0);
        GestFile16Helper.printKString(writer, codice, misAttivaPno && configuration.handleCoeffTrasf() ? mno.getKaString() : "0");
        GestFile16Helper.printKString(writer, codice, misReattivaPno && configuration.handleCoeffTrasf() ? mno.getKrString() : "0");
        GestFile16Helper.printKString(writer, codice, misPotenzaPno && configuration.handleCoeffTrasf() ? mno.getKpString() : "0");
        GestFile16Helper.printKString(writer, codice, commerciale && configuration.handleCoeffTrasf() ? mno.getKaSegnale() : "0");
        writer.print(codice, TERM_DOS, "");
    }

    private static void printMisure(String codice, boolean misAttiva, boolean misReattiva, boolean misPotenza, Misura misura, double[] lastAttiva, double[] lastReattiva, boolean checkLast, MapWriter writer, PrebillingConfiguration configuration, double ka, double kr, double kp) {
        int nCifre;
        boolean trunking;
        double[] attiva;
        int nFasce = misura.getFasce();
        if (misAttiva) {
            attiva = MisureHelper.getNetti(misura.getAttiva());
            trunking = configuration.isTrunking();
            nCifre = configuration.getNCifreAttiva(ka);
            GestFile16Helper.printMisura(codice, attiva, lastAttiva, nFasce, checkLast, writer, trunking, nCifre);
        } else {
            GestFile16Helper.printMisureAssenti(codice, 4, writer);
        }
        if (misReattiva) {
            double[] reattiva = MisureHelper.getNetti(misura.getReattiva());
            trunking = configuration.isTrunking();
            nCifre = configuration.getNCifreReattiva(kr);
            GestFile16Helper.printMisura(codice, reattiva, lastReattiva, nFasce, checkLast, writer, trunking, nCifre);
        } else {
            GestFile16Helper.printMisureAssenti(codice, 4, writer);
        }
        if (misPotenza) {
            double[] potenza = MisureHelper.getNetti(misura.getPotenza());
            trunking = configuration.isTrunking();
            nCifre = configuration.getNCifrePotenza(kp);
            GestFile16Helper.printMisura(codice, potenza, potenza, nFasce, checkLast, writer, trunking, nCifre);
        } else {
            GestFile16Helper.printMisureAssenti(codice, 4, writer);
        }
        GestFile16Helper.printMisureAssenti(codice, 4, writer);
        if (misura.hasCommerciale()) {
            attiva = MisureHelper.getNetti(misura.getCommerciale());
            trunking = configuration.isTrunking();
            nCifre = configuration.getNCifreAttiva(ka);
            GestFile16Helper.printMisura(codice, attiva, lastAttiva, nFasce, false, writer, trunking, nCifre);
        } else {
            GestFile16Helper.printMisureAssenti(codice, 4, writer);
        }
    }

    private static void printMisureAssenti(String codice, int n2, MapWriter writer) {
        int index = 0;
        while (index < n2) {
            GestFile16Helper.printMisuraAssente(writer, codice);
            ++index;
        }
    }

    private static void printMisura(String codice, double[] energia, double[] last, int nFasce, boolean checkLast, MapWriter writer, boolean trunking, int nCifre) {
        int i2 = 0;
        while (i2 < nFasce) {
            writer.print(codice, "p", "");
            double misura = GestFile16Helper.buildMisura(energia[i2], last[i2], checkLast);
            String formatMisura = GestFile16Helper.formatMisura(misura, trunking, nCifre);
            writer.print(codice, formatMisura, "");
            ++i2;
        }
        int nMisureAssenti = FasciaOraria.values().length - nFasce + 1;
        int i3 = 0;
        while (i3 < nMisureAssenti) {
            GestFile16Helper.printMisuraAssente(writer, codice);
            ++i3;
        }
    }

    private static double buildMisura(double energia, double last, boolean checkLast) {
        return energia < last - 1.0 || energia > last || !checkLast ? energia : last;
    }

    private static void printMisuraAssente(MapWriter writer, String codice) {
        writer.print(codice, "a", "");
        writer.print(codice, ExportHelper.fixedLength("", 14), "");
    }

    private static String formatMisura(double misura, boolean trunking, int nCifre) {
        double m2 = trunking ? MathUtils.floor(misura, nCifre) : misura;
        return OUTPUT_MISURE_FORMAT.format(m2);
    }

    private static String formatMisura(double misura) {
        return OUTPUT_MISURE_FORMAT.format(misura);
    }

    public static void writeSostituzioneRiprogrammazione(MapWriter mapWriter, ExtendedLT lettura, String tipoRec, boolean hasReattivaPrev, boolean hasReattivaSucc, PrebillingConfiguration configuration) {
        MisuraNonoraria mno = lettura.getMno();
        MisuraNonoraria mnoPrev = lettura.getMnoPrev();
        Pod pod = lettura.getPod();
        Pod podPrev = lettura.getPodPrev();
        if (lettura.isMonorario()) {
            GestFile16Helper.monorario(mapWriter, mnoPrev, podPrev, mno, pod, hasReattivaPrev, hasReattivaSucc, tipoRec, configuration);
        } else {
            GestFile16Helper.fasce(mapWriter, mnoPrev, podPrev, mno, pod, false, hasReattivaPrev, hasReattivaSucc, tipoRec, configuration);
        }
    }

    private static void fasce(MapWriter mapWriter, MisuraNonoraria prevMno, Pod prevPod, MisuraNonoraria succMno, Pod succPod, boolean azzeramento, boolean prevMisuraReattiva, boolean succMisuraReattiva, String tipoRec, PrebillingConfiguration configuration) {
        int lunghezzaMatricola = configuration.getLunghezzaMatricola();
        String codice = prevPod.getCodice();
        String tarDis = succPod.getTarDis();
        String ordCdconmag = StrategyHelper.createCdconmag(prevPod, azzeramento, tarDis, succMno, configuration);
        Date prevDate = prevMno.getDataMisura();
        Date succDate = succMno.getDataMisura();
        boolean prevMisuraAttiva = prevPod.isMisuraAttiva(prevDate);
        boolean prevMisuraPotenza = prevPod.isMisuraPotenza(prevDate);
        Misura prevMisura = prevMno.getMisura();
        boolean prevMisuraCommerciale = prevMisura.hasCommerciale();
        boolean succMisuraAttiva = succPod.isMisuraAttiva(succDate);
        boolean succMisuraPotenza = succPod.isMisuraPotenza(succDate);
        Misura succMisura = succMno.getMisura();
        boolean succMisuraCommerciale = succMisura.hasCommerciale();
        mapWriter.print(codice, "%" + tipoRec, "");
        mapWriter.print(codice, "    ", "");
        mapWriter.print(codice, ExportHelper.fixedLength(codice, 30), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 9), "");
        mapWriter.print(codice, OUTPUT_DATE_FORMAT.format(prevDate), "");
        mapWriter.print(codice, "0000", "");
        mapWriter.print(codice, "0000", "");
        mapWriter.print(codice, "1", "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 40), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 40), "");
        mapWriter.print(codice, succMisuraAttiva ? "1" : "0", "");
        mapWriter.print(codice, succMisuraReattiva ? "1" : "0", "");
        mapWriter.print(codice, succMisuraPotenza ? "1" : "0", "");
        mapWriter.print(codice, "0", "");
        mapWriter.print(codice, prevMisuraCommerciale ? "1" : "0", "");
        mapWriter.print(codice, "3", "");
        mapWriter.print(codice, "     ", "");
        String prevMatricolaAtt = prevMno.getMatricolaAtt();
        String matrAttPre = prevMisuraAttiva ? prevMatricolaAtt : " ";
        String prevMatricolaRea = prevMno.getMatricolaRea();
        String matrReaPre = prevMisuraReattiva ? GestFile16Helper.fixMatricola(prevMatricolaRea, prevMatricolaAtt) : " ";
        String prevMatricolaPot = prevMno.getMatricolaPot();
        String matrPotPre = prevMisuraPotenza ? GestFile16Helper.fixMatricola(prevMatricolaPot, prevMatricolaAtt) : " ";
        String matrCommPre = prevMisuraCommerciale ? prevMatricolaAtt : " ";
        String matrAttSuc = succMisuraAttiva ? succMno.getMatricolaAtt() : " ";
        String matrReaSuc = succMisuraReattiva ? succMno.getMatricolaRea() : " ";
        String matrPotSuc = succMisuraPotenza ? succMno.getMatricolaPot() : " ";
        String matrCommSuc = succMisuraCommerciale ? succMno.getMatricolaAtt() : " ";
        mapWriter.print(codice, ExportHelper.fixedLength(matrAttPre, lunghezzaMatricola), "");
        mapWriter.print(codice, "     ", "");
        mapWriter.print(codice, ExportHelper.fixedLength(matrReaPre, lunghezzaMatricola), "");
        mapWriter.print(codice, "     ", "");
        mapWriter.print(codice, ExportHelper.fixedLength(matrPotPre, lunghezzaMatricola), "");
        mapWriter.print(codice, "     ", "");
        mapWriter.print(codice, ExportHelper.fixedLength("", lunghezzaMatricola), "");
        mapWriter.print(codice, "     ", "");
        mapWriter.print(codice, ExportHelper.fixedLength(matrCommPre, lunghezzaMatricola), "");
        GestFile16Helper.printMisure(mapWriter, prevMisura, prevPod, true, prevMisuraReattiva, configuration);
        mapWriter.print(codice, " ", "");
        mapWriter.print(codice, succMisuraAttiva ? ordCdconmag : "     ", "");
        mapWriter.print(codice, ExportHelper.fixedLength(matrAttSuc, lunghezzaMatricola), "");
        mapWriter.print(codice, " ", "");
        mapWriter.print(codice, succMisuraReattiva ? ordCdconmag : "     ", "");
        mapWriter.print(codice, ExportHelper.fixedLength(matrReaSuc, lunghezzaMatricola), "");
        mapWriter.print(codice, " ", "");
        mapWriter.print(codice, succMisuraPotenza ? ordCdconmag : "     ", "");
        mapWriter.print(codice, ExportHelper.fixedLength(matrPotSuc, lunghezzaMatricola), "");
        mapWriter.print(codice, " ", "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 5), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", lunghezzaMatricola), "");
        mapWriter.print(codice, " ", "");
        mapWriter.print(codice, succMisuraCommerciale ? ordCdconmag : "     ", "");
        mapWriter.print(codice, ExportHelper.fixedLength(matrCommSuc, lunghezzaMatricola), "");
        GestFile16Helper.printMisure(mapWriter, succMisura, succPod, false, succMisuraReattiva, configuration);
        mapWriter.print(codice, ExportHelper.fixedLength("", 30), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 8), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 4), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 4), "");
        mapWriter.print(codice, " ", "");
        mapWriter.print(codice, "1", "");
        mapWriter.print(codice, SHORT_DATE_FORMAT.format(succDate), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 4), "");
        mapWriter.print(codice, "00", "");
        mapWriter.print(codice, "00000000000000", "");
        mapWriter.print(codice, "00000000000000", "");
        mapWriter.print(codice, "9", "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 12), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 12), "");
        mapWriter.print(codice, "9", "");
        mapWriter.print(codice, "9", "");
        mapWriter.print(codice, "00000", "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 8), "");
        mapWriter.print(codice, "0000", "");
        GestFile16Helper.printKString(mapWriter, codice, prevMisuraAttiva && configuration.handleCoeffTrasf() ? prevMno.getKaSegnale() : "0");
        GestFile16Helper.printKString(mapWriter, codice, prevMisuraReattiva && configuration.handleCoeffTrasf() ? prevMno.getKrSegnale() : "0");
        GestFile16Helper.printKString(mapWriter, codice, prevMisuraPotenza && configuration.handleCoeffTrasf() ? prevMno.getKpSegnale() : "0");
        GestFile16Helper.printKString(mapWriter, codice, prevMisuraCommerciale && configuration.handleCoeffTrasf() ? prevMno.getKaSegnale() : "0");
        GestFile16Helper.printKString(mapWriter, codice, succMisuraAttiva && configuration.handleCoeffTrasf() ? succMno.getKaSegnale() : "0");
        GestFile16Helper.printKString(mapWriter, codice, succMisuraReattiva && configuration.handleCoeffTrasf() ? succMno.getKrSegnale() : "0");
        GestFile16Helper.printKString(mapWriter, codice, succMisuraPotenza && configuration.handleCoeffTrasf() ? succMno.getKpSegnale() : "0");
        GestFile16Helper.printKString(mapWriter, codice, succMisuraCommerciale && configuration.handleCoeffTrasf() ? succMno.getKaSegnale() : "0");
        mapWriter.print(codice, TERM_DOS, "");
    }

    private static void monorario(MapWriter mapWriter, MisuraNonoraria prevMno, Pod prevPod, MisuraNonoraria succMno, Pod succPod, boolean prevMisuraReattiva, boolean succMisuraReattiva, String tipoRec, PrebillingConfiguration configuration) {
        int lunghezzaMatricola = configuration.getLunghezzaMatricola();
        String codice = prevPod.getCodice();
        String tarDis = succPod.getTarDis();
        String ordCdconmag = StrategyHelper.createCdconmag(prevPod, false, tarDis, succMno, configuration);
        Date prevDate = prevMno.getDataMisura();
        Misura prevMisura = prevMno.getMisura();
        boolean prevMisuraAttiva = prevPod.isMisuraAttiva(prevDate);
        boolean prevMisuraPotenza = prevPod.isMisuraPotenza(prevDate);
        boolean prevMisuraCommerciale = prevMisura.hasCommerciale();
        mapWriter.print(codice, "%" + tipoRec, "");
        mapWriter.print(codice, "    ", "");
        mapWriter.print(codice, ExportHelper.fixedLength(codice, 30), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 9), "");
        mapWriter.print(codice, OUTPUT_DATE_FORMAT.format(prevDate), "");
        mapWriter.print(codice, "0000", "");
        mapWriter.print(codice, "0000", "");
        mapWriter.print(codice, "1", "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 40), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 40), "");
        mapWriter.print(codice, prevMisuraAttiva ? "1" : "0", "");
        mapWriter.print(codice, prevMisuraReattiva ? "1" : "0", "");
        mapWriter.print(codice, prevMisuraPotenza ? "1" : "0", "");
        mapWriter.print(codice, prevMisuraCommerciale ? "1" : "0", "");
        mapWriter.print(codice, "0", "");
        mapWriter.print(codice, "3", "");
        mapWriter.print(codice, "     ", "");
        String matrAtt = prevMisuraAttiva ? prevMno.getMatricolaAtt() : " ";
        mapWriter.print(codice, ExportHelper.fixedLength(matrAtt, lunghezzaMatricola), "");
        mapWriter.print(codice, "     ", "");
        String matrRea = prevMisuraReattiva ? prevMno.getMatricolaRea() : " ";
        mapWriter.print(codice, ExportHelper.fixedLength(matrRea, lunghezzaMatricola), "");
        mapWriter.print(codice, "     ", "");
        String matrPot = prevMisuraPotenza ? prevMno.getMatricolaPot() : " ";
        mapWriter.print(codice, ExportHelper.fixedLength(matrPot, lunghezzaMatricola), "");
        mapWriter.print(codice, "     ", "");
        mapWriter.print(codice, ExportHelper.fixedLength("", lunghezzaMatricola), "");
        mapWriter.print(codice, "     ", "");
        String matrComm = prevMisuraCommerciale ? prevMno.getMatricolaAtt() : " ";
        mapWriter.print(codice, ExportHelper.fixedLength(matrComm, lunghezzaMatricola), "");
        GestFile16Helper.printMisureMonoOrarie(mapWriter, prevMisura, prevPod, true, prevMisuraReattiva, configuration);
        mapWriter.print(codice, " ", "");
        Misura succMisura = succMno.getMisura();
        Date date = succMisura.getDate();
        boolean succMisuraAttiva = succPod.isMisuraAttiva(date);
        boolean succMisuraPotenza = succPod.isMisuraPotenza(date);
        boolean succMisuraCommerciale = succMisura.hasCommerciale();
        mapWriter.print(codice, succMisuraAttiva ? ordCdconmag : "     ", "");
        String succMatrAtt = succMno.getMatricolaAtt();
        mapWriter.print(codice, ExportHelper.fixedLength(succMisuraAttiva ? succMatrAtt : "", lunghezzaMatricola), "");
        mapWriter.print(codice, " ", "");
        mapWriter.print(codice, succMisuraReattiva ? ordCdconmag : "     ", "");
        String succMatrRea = succMno.getMatricolaRea();
        mapWriter.print(codice, ExportHelper.fixedLength(succMisuraReattiva ? succMatrRea : "", lunghezzaMatricola), "");
        mapWriter.print(codice, " ", "");
        mapWriter.print(codice, succMisuraPotenza ? ordCdconmag : "     ", "");
        String succMatrPot = succMno.getMatricolaPot();
        mapWriter.print(codice, ExportHelper.fixedLength(succMisuraPotenza ? succMatrPot : "", lunghezzaMatricola), "");
        mapWriter.print(codice, " ", "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 5), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", lunghezzaMatricola), "");
        mapWriter.print(codice, " ", "");
        mapWriter.print(codice, succMisuraCommerciale ? ordCdconmag : "     ", "");
        String succMatrComm = succMisuraCommerciale ? succMatrAtt : " ";
        mapWriter.print(codice, ExportHelper.fixedLength(succMatrComm, lunghezzaMatricola), "");
        GestFile16Helper.printMisure(mapWriter, succMisura, succPod, true, succMisuraReattiva, configuration);
        mapWriter.print(codice, ExportHelper.fixedLength("", 30), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 8), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 4), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 4), "");
        mapWriter.print(codice, " ", "");
        mapWriter.print(codice, "1", "");
        mapWriter.print(codice, SHORT_DATE_FORMAT.format(succMno.getDataMisura()), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 4), "");
        mapWriter.print(codice, "00", "");
        mapWriter.print(codice, "00000000000000", "");
        mapWriter.print(codice, "00000000000000", "");
        mapWriter.print(codice, "9", "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 12), "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 12), "");
        mapWriter.print(codice, "9", "");
        mapWriter.print(codice, "9", "");
        mapWriter.print(codice, "00000", "");
        mapWriter.print(codice, ExportHelper.fixedLength("", 8), "");
        mapWriter.print(codice, "0000", "");
        GestFile16Helper.printKString(mapWriter, codice, prevMisuraAttiva && configuration.handleCoeffTrasf() ? prevMno.getKaSegnale() : "0");
        GestFile16Helper.printKString(mapWriter, codice, prevMisuraReattiva && configuration.handleCoeffTrasf() ? prevMno.getKrSegnale() : "0");
        GestFile16Helper.printKString(mapWriter, codice, prevMisuraPotenza && configuration.handleCoeffTrasf() ? prevMno.getKpSegnale() : "0");
        GestFile16Helper.printKString(mapWriter, codice, prevMisuraCommerciale && configuration.handleCoeffTrasf() ? prevMno.getKaSegnale() : "0");
        GestFile16Helper.printKString(mapWriter, codice, succMisuraAttiva && configuration.handleCoeffTrasf() ? succMno.getKaSegnale() : "0");
        GestFile16Helper.printKString(mapWriter, codice, succMisuraReattiva && configuration.handleCoeffTrasf() ? succMno.getKrSegnale() : "0");
        GestFile16Helper.printKString(mapWriter, codice, succMisuraPotenza && configuration.handleCoeffTrasf() ? succMno.getKpSegnale() : "0");
        GestFile16Helper.printKString(mapWriter, codice, succMisuraCommerciale && configuration.handleCoeffTrasf() ? succMno.getKaSegnale() : "0");
        mapWriter.print(codice, TERM_DOS, "");
    }

    private static void printMisure(MapWriter mapWriter, Misura misura, Pod pod, boolean checkLast, boolean misuraReattiva, PrebillingConfiguration configuration) {
        String presenza;
        String misuraToPrint;
        int nCifre;
        boolean trunking;
        FasciaOraria fascia;
        String codicePod = pod.getCodice();
        Date date = misura.getDate();
        double ka = pod.getKa(date);
        double kr = pod.getKr(date);
        double kp = pod.getKp(date);
        boolean misuraAttiva = pod.isMisuraAttiva(date);
        boolean misuraPotenza = pod.isMisuraPotenza(date);
        boolean misuraCommerciale = misura.hasCommerciale();
        double[] lastAttiva = pod.getLastAttiva();
        double[] lastReattiva = pod.getLastReattiva();
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            fascia = fasciaOrariaArray[n3];
            if (misuraAttiva) {
                double attiva = misura.getAttiva(fascia).getNetto();
                attiva = GestFile16Helper.buildMisura(attiva, lastAttiva[fascia.ordinal()], checkLast);
                trunking = configuration.isTrunking();
                nCifre = configuration.getNCifreAttiva(ka);
                misuraToPrint = GestFile16Helper.formatMisura(attiva, trunking, nCifre);
                presenza = "p";
            } else {
                misuraToPrint = ExportHelper.fixedLength("", 14);
                presenza = "a";
            }
            mapWriter.print(codicePod, presenza, "");
            mapWriter.print(codicePod, misuraToPrint, "");
            ++n3;
        }
        GestFile16Helper.printMisuraAssente(mapWriter, codicePod);
        fasciaOrariaArray = FasciaOraria.values();
        n2 = fasciaOrariaArray.length;
        n3 = 0;
        while (n3 < n2) {
            fascia = fasciaOrariaArray[n3];
            if (misuraReattiva) {
                double reattiva = misura.getReattiva(fascia).getNetto();
                reattiva = GestFile16Helper.buildMisura(reattiva, lastReattiva[fascia.ordinal()], checkLast);
                trunking = configuration.isTrunking();
                nCifre = configuration.getNCifreReattiva(kr);
                misuraToPrint = GestFile16Helper.formatMisura(reattiva, trunking, nCifre);
                presenza = "p";
            } else {
                misuraToPrint = ExportHelper.fixedLength("", 14);
                presenza = "a";
            }
            mapWriter.print(codicePod, presenza, "");
            mapWriter.print(codicePod, misuraToPrint, "");
            ++n3;
        }
        GestFile16Helper.printMisuraAssente(mapWriter, codicePod);
        fasciaOrariaArray = FasciaOraria.values();
        n2 = fasciaOrariaArray.length;
        n3 = 0;
        while (n3 < n2) {
            fascia = fasciaOrariaArray[n3];
            if (misuraPotenza) {
                double potenza = misura.getPotenza(fascia).getNetto();
                trunking = configuration.isTrunking();
                nCifre = configuration.getNCifrePotenza(kp);
                misuraToPrint = GestFile16Helper.formatMisura(potenza, trunking, nCifre);
                presenza = "p";
            } else {
                misuraToPrint = ExportHelper.fixedLength("", 14);
                presenza = "a";
            }
            mapWriter.print(codicePod, presenza, "");
            mapWriter.print(codicePod, misuraToPrint, "");
            ++n3;
        }
        GestFile16Helper.printMisuraAssente(mapWriter, codicePod);
        int index = 0;
        while (index < 4) {
            GestFile16Helper.printMisuraAssente(mapWriter, codicePod);
            ++index;
        }
        fasciaOrariaArray = FasciaOraria.values();
        n2 = fasciaOrariaArray.length;
        n3 = 0;
        while (n3 < n2) {
            fascia = fasciaOrariaArray[n3];
            if (misuraCommerciale) {
                double commerciale = misura.getCommerciale(fascia).getNetto();
                misuraToPrint = GestFile16Helper.formatMisura(commerciale);
                presenza = "p";
            } else {
                misuraToPrint = ExportHelper.fixedLength("", 14);
                presenza = "a";
            }
            mapWriter.print(codicePod, presenza, "");
            mapWriter.print(codicePod, misuraToPrint, "");
            ++n3;
        }
        GestFile16Helper.printMisuraAssente(mapWriter, codicePod);
    }

    private static String fixMatricola(String matricola, String matrAtt) {
        return matricola == null || matricola.isEmpty() ? matrAtt : matricola;
    }

    private static void printMisureMonoOrarie(MapWriter mapWriter, Misura misura, Pod pod, boolean checkLast, boolean prevMisuraReattiva, PrebillingConfiguration configuration) {
        String presenza;
        String misuraToPrint;
        int nCifre;
        FasciaOraria fascia = FasciaOraria.F1;
        Date date = misura.getDate();
        double ka = pod.getKa(date);
        double kr = pod.getKr(date);
        double kp = pod.getKp(date);
        if (pod.isMisuraAttiva(date)) {
            double attiva = misura.getAttiva(fascia).getNetto();
            double[] lastAttiva = pod.getLastAttiva();
            attiva = GestFile16Helper.buildMisura(attiva, lastAttiva[fascia.ordinal()], checkLast);
            boolean trunking = configuration.isTrunking();
            nCifre = configuration.getNCifreAttiva(ka);
            misuraToPrint = GestFile16Helper.formatMisura(attiva, trunking, nCifre);
            presenza = "p";
        } else {
            misuraToPrint = ExportHelper.fixedLength("", 14);
            presenza = "a";
        }
        String codice = pod.getCodice();
        mapWriter.print(codice, presenza, "");
        mapWriter.print(codice, misuraToPrint, "");
        int index = 0;
        while (index < 3) {
            GestFile16Helper.printMisuraAssente(mapWriter, codice);
            ++index;
        }
        if (prevMisuraReattiva) {
            double reattiva = misura.getReattiva(fascia).getNetto();
            double[] last = pod.getLastReattiva();
            reattiva = GestFile16Helper.buildMisura(reattiva, last[fascia.ordinal()], checkLast);
            boolean trunking = configuration.isTrunking();
            int nCifre2 = configuration.getNCifreReattiva(kr);
            misuraToPrint = GestFile16Helper.formatMisura(reattiva, trunking, nCifre2);
            presenza = "p";
        } else {
            misuraToPrint = ExportHelper.fixedLength("", 14);
            presenza = "a";
        }
        mapWriter.print(codice, presenza, "");
        mapWriter.print(codice, misuraToPrint, "");
        index = 0;
        while (index < 3) {
            GestFile16Helper.printMisuraAssente(mapWriter, codice);
            ++index;
        }
        if (pod.isMisuraPotenza(date)) {
            double potenza = misura.getPotenza(fascia).getNetto();
            boolean trunking = configuration.isTrunking();
            nCifre = configuration.getNCifrePotenza(kp);
            misuraToPrint = GestFile16Helper.formatMisura(potenza, trunking, nCifre);
            presenza = "p";
        } else {
            misuraToPrint = ExportHelper.fixedLength("", 14);
            presenza = "a";
        }
        mapWriter.print(codice, presenza, "");
        mapWriter.print(codice, misuraToPrint, "");
        index = 0;
        while (index < 11) {
            GestFile16Helper.printMisuraAssente(mapWriter, codice);
            ++index;
        }
    }

    private static void printKString(MapWriter mapWriter, String codice, String kString) {
        if (kString == null || kString.isEmpty()) {
            mapWriter.print(codice, ExportHelper.fixedLength("", 15), "");
        } else {
            double k2 = Double.parseDouble(kString);
            GestFile16Helper.printK(mapWriter, codice, k2);
        }
    }

    private static void printK(MapWriter mapWriter, String codice, double k2) {
        mapWriter.print(codice, OUTPUT_K_FORMAT.format(k2), "");
    }

    public static boolean checkReattiva(Pod pod, Date date, Set<String> tarDisDom) {
        return pod.isMisuraReattiva(date) && (!pod.isAllineato() || !StrategyHelper.checkReattiva(pod, tarDisDom));
    }
}

