/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.StatusManager;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.SnfResult;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.switched.SnfD65;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;

public class D65CrmService {
    public static final Set<String> BANNED_D65 = new HashSet<String>(Arrays.asList("matratt", "matrrea", "matrpot", "configurazionemisuratore", "disalimentabilita", "residenza", "datamessaregime", "tipomisuratore", "datainstmisatt", "datainstmisrea", "datainstmispot"));
    private final PrebillingConfiguration configuration;
    private final TalkManager talkManager;
    private final Funzionalita funzionalita;
    private final DateFormat timestampFormat;
    private final DateFormat dataFormat;
    private final DecimalFormat usEnergyFormat;
    private final Set<String> banned;
    private DateFormat longDataFormat;

    public D65CrmService(Funzionalita funzionalita, PrebillingConfiguration configuration, TalkManager talkManager) {
        this(funzionalita, configuration, talkManager, BANNED_D65);
    }

    public D65CrmService(Funzionalita funzionalita, PrebillingConfiguration configuration, TalkManager talkManager, Set<String> banned) {
        this.funzionalita = funzionalita;
        this.configuration = configuration;
        this.talkManager = talkManager;
        this.timestampFormat = StrategyCommonHelper.getTimestampFormat();
        this.dataFormat = StrategyHelper.getDataFormat();
        this.usEnergyFormat = StrategyHelper.getUsEnergyFormat();
        this.banned = banned;
    }

    public boolean export(Iterable<? extends SnfD65> toExport, String prefix, String codicePod, String codiceProcesso, boolean flusso, StatusManager statusManager) {
        Iterator<? extends SnfD65> iterator = toExport.iterator();
        return this.export(iterator, prefix, codicePod, codiceProcesso, flusso, statusManager);
    }

    public boolean export(Iterator<? extends SnfD65> toExport, String prefix, String codicePod, String codiceProcesso, boolean flusso, StatusManager statusManager) {
        boolean ok;
        String idEsecuzione = statusManager.getIdEsecuzione();
        File folder = ConfigurationHelper.getMiddlewareTmpFolder(this.configuration, idEsecuzione, this.funzionalita);
        String dateStr = this.timestampFormat.format(new Date());
        String fileName = String.valueOf(prefix) + "-" + codicePod + "-" + dateStr + ".xml";
        File file = new File(folder, fileName);
        try {
            Throwable throwable = null;
            Object var14_15 = null;
            try (PrintWriter writer = new PrintWriter(file);){
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                writer.println("<FlussoMisure xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" CodFlusso=\"D65\">");
                writer.println("<CodProcesso>" + codiceProcesso + "</CodProcesso>");
                while (toExport.hasNext()) {
                    SnfD65 snf = toExport.next();
                    String codiceFlusso = snf.getCodiceFlusso();
                    String codice = flusso ? codiceFlusso : codiceProcesso;
                    this.exportDatiPod(snf, writer);
                    statusManager.count("middleware", codice);
                    SnfResult result = new SnfResult(snf, ErroriElaborazione.OK, "");
                    statusManager.addSnfElaborato(result);
                }
                writer.print("</FlussoMisure>");
                ok = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException exc) {
            Warning sentence = new Warning("export.snf.strategy", "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(file.getAbsolutePath());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private void exportDatiPod(SnfD65 snf, PrintWriter writer) {
        boolean truncate = this.configuration.isTrunking();
        Map<String, Map<String, String>> datiPod = snf.getDatiPod();
        writer.println("<DatiPod>");
        String codicePod = snf.getCodicePod();
        double ka = StrategyHelper.getK(snf.getKa());
        double kr = StrategyHelper.getK(snf.getKr());
        double kp = StrategyHelper.getK(snf.getKp());
        writer.println("<Pod>" + codicePod + "</Pod>");
        Date date = snf.getDate();
        writer.println("<DataMisura>" + this.dataFormat.format(date) + "</DataMisura>");
        for (String nomeDati : datiPod.keySet()) {
            Map<String, String> mappaDettagli = datiPod.get(nomeDati);
            writer.println("<" + nomeDati + ">");
            StrategyHelper.printValueMap(mappaDettagli, null, this.banned, truncate, this.usEnergyFormat, this.configuration, writer, this.longDataFormat, this.dataFormat, ka, kr, kp);
            writer.println("</" + nomeDati + ">");
        }
        if (datiPod.get("Misura") == null) {
            writer.println("<Misura>");
            if (snf.getTrattamento().isMono()) {
                writer.println("<EaM>0</EaM>");
            } else {
                writer.println("<EaF1>0</EaF1>");
                writer.println("<EaF2>0</EaF2>");
                writer.println("<EaF3>0</EaF3>");
            }
            writer.println("</Misura>");
        }
        writer.println("</DatiPod>");
    }
}

