/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.Pratica;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.MisuraNonorariaPod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.AbstractGenericTPManager;
import biz.elabor.prebilling.services.common.PraticaTardivaHandler;
import biz.elabor.prebilling.services.common.TipoPrestazione;
import biz.elabor.prebilling.services.volture.ExportVnoCrmStrategy;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

abstract class AbstractVTTPManager
extends AbstractGenericTPManager {
    private static final Iterable<String> FLUSSI_NO_PRIORITA_1 = Arrays.asList("VNO", "RNV", "VNO2G", "RNV2G");
    private static final Iterable<String> FLUSSI_NO_PRIORITA_2 = Arrays.asList("VNO", "RNV", "VNO2G", "RNV2G", "PNO", "PNO2G", "RNO", "RNO2G");
    private static final Iterable<String> FLUSSI_O_PRIORITA_2 = Arrays.asList("PDO2G", "RFO2G");
    private static final Iterable<StatoMisure> STATI_PRIORITA_1 = Arrays.asList(StatoMisure.VALIDATO, StatoMisure.SOSPESO, StatoMisure.ESCLUSO, StatoMisure.ELABORATO);
    private static final Iterable<StatoMisure> STATI_PRIORITA_2 = Arrays.asList(StatoMisure.VALIDATO, StatoMisure.SOSPESO, StatoMisure.ESCLUSO, StatoMisure.OBSOLETO, StatoMisure.ELABORATO);
    protected static final Iterable<String> ALL_RACCOLTE = Arrays.asList("P", "T", "V");
    protected static final Iterable<String> V_RACCOLTE = Arrays.asList("V");

    AbstractVTTPManager() {
    }

    @Override
    public Mno getMno(Pod pod, Pratica pratica, int scostamento, PraticaTardivaHandler handler, MisureDao misureDao) throws DataNotFoundException {
        Mno mno;
        Date dataPratica;
        block15: {
            SpecificaTecnica specificaTecnica = pratica.getSpecificaTecnica();
            dataPratica = specificaTecnica.getData();
            Date dataMisura = CalendarTools.previousDay(dataPratica);
            String codicePod = pod.getCodice();
            try {
                mno = misureDao.getMnoPraticaTardiva(codicePod, dataPratica, 0, FLUSSI_NO_PRIORITA_1, STATI_PRIORITA_1, ALL_TIPI_DATO, ALL_RACCOLTE, "DESC");
            }
            catch (DataNotFoundException e1) {
                try {
                    mno = misureDao.getMnoPraticaTardiva(codicePod, dataMisura, 0, FLUSSI_NO_PRIORITA_2, STATI_PRIORITA_1, ALL_TIPI_DATO, V_RACCOLTE, "DESC");
                }
                catch (DataNotFoundException e2) {
                    try {
                        mno = misureDao.getMo2GRPraticaTardiva(codicePod, dataMisura, 0, FLUSSI_O_PRIORITA_2, STATI_PRIORITA_1, ALL_TIPI_DATO, V_RACCOLTE, "DESC");
                    }
                    catch (DataNotFoundException e3) {
                        try {
                            mno = misureDao.getMnoPraticaTardiva(codicePod, dataMisura, scostamento, FLUSSI_NO_PRIORITA_2, STATI_PRIORITA_2, E_TIPI_DATO, ALL_RACCOLTE, "DESC");
                        }
                        catch (DataNotFoundException e4) {
                            try {
                                mno = misureDao.getMo2GRPraticaTardiva(codicePod, dataMisura, scostamento, FLUSSI_O_PRIORITA_2, STATI_PRIORITA_2, E_TIPI_DATO, ALL_RACCOLTE, "DESC");
                            }
                            catch (DataNotFoundException e5) {
                                try {
                                    mno = misureDao.getMnoPraticaTardiva(codicePod, dataMisura, scostamento, FLUSSI_NO_PRIORITA_2, STATI_PRIORITA_2, S_TIPI_DATO, ALL_RACCOLTE, "ASC");
                                }
                                catch (DataNotFoundException e6) {
                                    try {
                                        mno = misureDao.getMo2GRPraticaTardiva(codicePod, dataMisura, scostamento, FLUSSI_O_PRIORITA_2, STATI_PRIORITA_2, S_TIPI_DATO, ALL_RACCOLTE, "ASC");
                                    }
                                    catch (DataNotFoundException e7) {
                                        Date dataMax = pod.getDataMax();
                                        if (AbstractVTTPManager.checkData(dataMax, dataPratica, scostamento)) {
                                            mno = handler.buildMnoFromPod(pod, dataPratica);
                                            break block15;
                                        }
                                        String key = String.valueOf(pratica.getCodicePod()) + " " + StrategyHelper.getDataFormat().format(dataPratica);
                                        throw new DataNotFoundException("misura.notfound", key);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        mno.setDataMisura(dataPratica);
        return mno;
    }

    public static void handleD65(Funzionalita funzionalita, TipoPrestazione tipoPrestazione, String destinazione, Pod pod, Pratica pratica, Mno mno, StatusTransaction transaction, PrebillingConfiguration configuration, TalkManager talkManager) {
        SpecificaTecnica specificaTecnica = pratica.getSpecificaTecnica();
        Date dataVoltura = specificaTecnica.getData();
        mno.setDataVoltura(dataVoltura);
        String codicePrestazione = tipoPrestazione.name();
        mno.setCodPratAtt(pratica.getCodPratAtt());
        List<Mno> mnoList = Arrays.asList(mno);
        if (destinazione == null) {
            DateFormat timestampFormat = StrategyCommonHelper.getTimestampFormat();
            DateFormat longDateFormat = StrategyHelper.getFullDateFormat();
            DateFormat dateFormat = StrategyHelper.getDataFormat();
            DecimalFormat usEnergyFormat = StrategyHelper.getUsEnergyFormat();
            String prefix = String.valueOf(codicePrestazione) + "-tardiva";
            String idEsecuzione = transaction.getStatus().getIdEsecuzione();
            ExportVnoCrmStrategy.exportVolturaPod(prefix, pod, mnoList, transaction, funzionalita, configuration, usEnergyFormat, timestampFormat, longDateFormat, dateFormat, talkManager, idEsecuzione);
        } else {
            MisuraNonorariaPod misura = new MisuraNonorariaPod(codicePrestazione, pod, mno);
            transaction.addMisuraLateProcessing(misura);
        }
    }

    private static boolean checkData(Date data, Date dataPratica, int scostamento) {
        ElaborCalendar calendar = new ElaborCalendar(dataPratica);
        calendar.addGiorni(scostamento);
        Date dataMax = calendar.getDate();
        calendar.setDate(dataPratica);
        calendar.addGiorni(-scostamento);
        Date dataMin = calendar.getDate();
        return !data.before(dataMin) && !data.after(dataMax);
    }
}

