/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.model.InvalidCurvaRilevazioniException;
import biz.elabor.prebilling.model.indici.CurvaIndiciGiornaliera;
import biz.elabor.prebilling.model.indici.CurvaIndiciMensile;
import biz.elabor.prebilling.model.indici.InvalidCurvaIndiciException;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.services.common.IncoherentKException;
import biz.elabor.prebilling.services.common.TariffeAccumulator;
import biz.elabor.prebilling.services.tariffe.SmisException;
import biz.elabor.prebilling.services.tariffe.TariffeHelper;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;

public abstract class AbstractTariffeAccumulator
implements TariffeAccumulator {
    private final RilMese rilMese;
    private final List<Mno> mnoList;
    private final Date startDate;
    private final double kAttivaStart;
    protected final double coeffUM;
    protected final double qtconfla;
    protected final double[] prezziDefault;
    protected final boolean perdite;
    protected final double coeffPerdite;
    protected final double emtaruni;
    protected final double emspread;
    protected final double emspreneg;
    private Iterator<CurvaIndiciGiornaliera> cIterator;
    private Iterator<RilGiorno> rIterator;
    private Iterator<Mno> smisIterator;
    private Mno smis;
    protected ElaborCalendar expected;
    protected CurvaIndiciGiornaliera curvaGiorno;
    protected RilGiorno rilGiorno;
    protected double kAttiva;

    public AbstractTariffeAccumulator(RilMese rilMese, double coeffUM, Date startDate, double qtconfla, double kAttivaStart, double[] prezziDefault, boolean perdite, double coeffPerdite, double emtaruni, double emspread, double emspreneg, List<Mno> mnoList) {
        this.rilMese = rilMese;
        this.mnoList = mnoList;
        this.startDate = startDate;
        this.kAttivaStart = kAttivaStart;
        this.coeffUM = coeffUM;
        this.qtconfla = qtconfla;
        this.prezziDefault = prezziDefault;
        this.perdite = perdite;
        this.coeffPerdite = coeffPerdite;
        this.emtaruni = emtaruni;
        this.emspread = emspread;
        this.emspreneg = emspreneg;
    }

    @Override
    public void init(CurvaIndiciMensile curva) throws SmisException, InvalidCurvaRilevazioniException, InvalidCurvaIndiciException, IncoherentKException {
        this.cIterator = curva.iterator();
        this.rIterator = this.rilMese.iterator();
        this.smisIterator = TariffeHelper.buildMontaggiIterator(this.mnoList);
        this.smis = this.smisIterator.next();
        int anno = curva.getAnno();
        Month mese = curva.getMese();
        this.expected = new ElaborCalendar(anno, mese, 1);
        this.kAttiva = this.kAttivaStart;
        this.next();
    }

    protected void next() throws InvalidCurvaRilevazioniException, InvalidCurvaIndiciException, IncoherentKException, SmisException {
        if (this.cIterator.hasNext() && this.rIterator.hasNext()) {
            this.curvaGiorno = this.cIterator.next();
            this.rilGiorno = this.rIterator.next();
            this.checkKa();
            Date rilDate = this.rilGiorno.getDate();
            Date indDate = this.curvaGiorno.getData();
            if (rilDate.before(indDate)) {
                throw new InvalidCurvaRilevazioniException(rilDate);
            }
            Date firstIndDate = CalendarTools.min(rilDate, this.startDate);
            while (indDate.before(firstIndDate) && this.cIterator.hasNext()) {
                this.curvaGiorno = this.cIterator.next();
                indDate = this.curvaGiorno.getData();
            }
            if (rilDate.after(indDate)) {
                throw new InvalidCurvaRilevazioniException(indDate);
            }
        } else {
            if (this.cIterator.hasNext()) {
                this.curvaGiorno = this.cIterator.next();
                Date missingDate = this.curvaGiorno.getData();
                throw new InvalidCurvaRilevazioniException(missingDate);
            }
            if (this.rIterator.hasNext()) {
                throw new InvalidCurvaIndiciException();
            }
            this.curvaGiorno = null;
        }
    }

    private void checkKa() throws IncoherentKException, SmisException {
        double newKa;
        Date date = this.rilGiorno.getDate();
        Date smisDate = this.smis.getDataMisura();
        while (date.after(smisDate)) {
            this.smis = this.smisIterator.next();
            smisDate = this.smis.getDataMisura();
        }
        if (date.equals(smisDate)) {
            if (!date.equals(smisDate) || !this.smis.getRaccolta().equals("M")) {
                String codicePod = this.smis.getCodicePod();
                throw new SmisException(codicePod, date);
            }
            newKa = this.smis.getKa().doubleValue();
            this.smis = this.smisIterator.next();
            smisDate = this.smis.getDataMisura();
        } else {
            newKa = this.kAttiva;
        }
        if (!this.rilGiorno.checkKA(this.kAttiva, newKa)) {
            throw new IncoherentKException(date);
        }
        this.kAttiva = newKa;
    }
}

