/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.Pratica;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.MisuraPdo;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.common.PnoSwitchoutSPB;
import biz.elabor.prebilling.services.common.PraticaTardivaHandler;
import biz.elabor.prebilling.services.common.SwitchoutHelper;
import biz.elabor.prebilling.services.common.TipoPrestazione;
import biz.elabor.prebilling.services.common.TipoPrestazioneManager;
import biz.elabor.prebilling.services.common.statopod.AbstractStatoPodHandler;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.letture.MisuraMno;
import biz.elabor.prebilling.services.letture.statopod.PdoSwitchoutStatoPodHandler;
import biz.elabor.prebilling.services.letture.statopod.SwitchoutStatoPodBuilder;
import biz.elabor.prebilling.web.letture.SpecificaPrestazione;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

abstract class AbstractBasicTPManager
implements TipoPrestazioneManager {
    protected static final Iterable<String> NO_TIPI_DATO = Arrays.asList(new String[0]);
    protected static final Iterable<String> E_TIPI_DATO = Arrays.asList("E");
    protected static final Iterable<String> S_TIPI_DATO = Arrays.asList("S");
    protected static final Iterable<String> ALL_TIPI_DATO = Arrays.asList("E", "S");
    protected static final Iterable<StatoMisure> STATI = Arrays.asList(Arrays.copyOfRange(StatoMisure.values(), StatoMisure.ELABORATO.ordinal(), StatoMisure.values().length));

    AbstractBasicTPManager() {
    }

    @Override
    public <T extends MisuraPod> AbstractStatoPodHandler<T> getStatoPodHandler(SwitchoutStatoPodBuilder<T> builder) {
        return builder.buildGeneric();
    }

    @Override
    public boolean checkTardivo(Date dataPratica, Date timeout, boolean azzeramento) {
        return dataPratica.before(timeout);
    }

    @Override
    public void addSwitchOut(String destinazione, String codicePrestazione, MisuraPod misura, StatusTransaction transaction) {
        transaction.addSwitchOut(destinazione, codicePrestazione, misura);
    }

    @Override
    public void addMisuraOrariaPeriodo(MisuraPdo misuraPdo, StatusTransaction transaction) {
    }

    @Override
    public SpecificaPrestazione getSpecificaPrestazione(TipoPrestazione tipoPrestazione, Map<String, SpecificaPrestazione> specifiche) {
        return specifiche.get(tipoPrestazione.name());
    }

    protected Mno getMisuraPraticaTardiva(String codicePod, Date dataMisura, int scostamento, Iterable<String> tipiDato, PraticaTardivaHandler handler, MisureDao misureDao) throws DataNotFoundException {
        Mno mno;
        try {
            mno = handler.getPnoPraticaTardiva(codicePod, dataMisura, scostamento, tipiDato, misureDao);
        }
        catch (DataNotFoundException exc) {
            mno = handler.getPdo2GRPraticaTardiva(codicePod, dataMisura, scostamento, tipiDato, misureDao);
        }
        return mno;
    }

    @Override
    public Pdo getPdo(Pod pod, Pratica pratica, int scostamento, MisureDao misureDao) {
        SpecificaTecnica specificaTecnica = pratica.getSpecificaTecnica();
        Date dataPratica = specificaTecnica.getData();
        ElaborCalendar calendar = new ElaborCalendar(dataPratica);
        calendar.addGiorni(-1);
        int anno = calendar.getAnno();
        Month mese = calendar.getMese();
        String codicePod = pod.getCodice();
        List<Pdo> pdoList = misureDao.getPdoMese(anno, mese, codicePod, null, STATI);
        Pdo pdo = pdoList.isEmpty() ? AbstractBasicTPManager.buildPdoFromPod(pod, dataPratica) : pdoList.get(pdoList.size() - 1);
        return pdo;
    }

    @Override
    public void handlePrestazioneTardiva(Funzionalita funzionalita, TipoPrestazione tipoPrestazione, String destinazione, Pod pod, Pratica pratica, Mno mno, StatusTransaction transaction, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        MisuraMno misura = new MisuraMno(pod, mno);
        AbstractBasicTPManager.handleSwitchout(tipoPrestazione, pratica, misura, transaction, misureDao, configuration);
    }

    @Override
    public void handlePrestazioneTardiva(TipoPrestazione tipoPrestazione, boolean crm, Pod pod, Pratica pratica, Pdo pdo, StatusTransaction transaction, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager) throws DataNotFoundException {
        PdoSwitchoutStatoPodHandler pdoStatoPodHandler = new PdoSwitchoutStatoPodHandler(misureDao);
        SpecificaTecnica specificaTecnica = pratica.getSpecificaTecnica();
        Date dataPratica = specificaTecnica.getData();
        Date dataMisura = CalendarTools.previousDay(dataPratica);
        SwitchoutHelper.addSwitchout(tipoPrestazione, dataMisura, pratica, pod, pdo, transaction, pdoStatoPodHandler, configuration);
    }

    public void handleSwitchout(TipoPrestazione tipoPrestazione, Pod pod, Pratica pratica, Mno mno, StatusTransaction transaction, MisureDao misureDao, PrebillingConfiguration configuration) throws DataNotFoundException {
        MisuraMno misura = new MisuraMno(pod, mno);
        AbstractBasicTPManager.handleSwitchout(tipoPrestazione, pratica, misura, transaction, misureDao, configuration);
    }

    public static void handleSwitchout(TipoPrestazione tipoPrestazione, Pratica pratica, MisuraPod misura, StatusTransaction transaction, MisureDao misureDao, PrebillingConfiguration configuration) throws DataNotFoundException {
        PnoSwitchoutSPB builder = new PnoSwitchoutSPB(misureDao);
        AbstractStatoPodHandler<MisuraPod> statoPodHandler = tipoPrestazione.getStatoPodHandler(builder);
        SwitchoutHelper.addSwitchout(tipoPrestazione, pratica, misura, transaction, configuration, statoPodHandler);
    }

    protected static Pdo buildPdoFromPod(Pod pod, Date data) {
        String codicePod = pod.getCodice();
        ElaborCalendar calendar = new ElaborCalendar(data);
        int anno = calendar.getAnno();
        Month mese = calendar.getMese();
        RilMese rilMese = new RilMese(codicePod, anno, mese, null);
        HashMap<String, Map<String, String>> datiPod = new HashMap<String, Map<String, String>>();
        HashMap<String, String> datiPdp = new HashMap<String, String>();
        datiPdp.put("Trattamento", "O");
        datiPod.put("DatiPdp", datiPdp);
        return new Pdo("0", false, rilMese, null, null, null, null, null, datiPod, null, null, null, null, null, null, null, null, null);
    }
}

