/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.cessazioni;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.services.cessazioni.CessazioniStrategiesHandler;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import biz.elabor.prebilling.web.common.AbstractRequestHandler;
import biz.elabor.prebilling.web.common.JsonRequestHandler;
import java.util.LinkedHashMap;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class CessazioniHandler
extends AbstractRequestHandler
implements JsonRequestHandler {
    private final String anno;
    private final String mese;

    public CessazioniHandler(String anno, String mese, TalkManager talkManager) {
        super(Funzionalita.CESSAZIONI.name().toLowerCase(), talkManager);
        this.anno = anno;
        this.mese = mese;
    }

    @Override
    public String handleRequest(ConfigurationInstance instance) {
        PrebillingConfiguration configuration = instance.getConfiguration();
        CessazioniStrategiesHandler handler = new CessazioniStrategiesHandler(this.anno, this.mese, instance, this.talkManager);
        PrebillingDao prebillingDao = instance.getPrebillingDao();
        Results results = this.handleRequest(handler, configuration, prebillingDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected String getReseller() {
        return null;
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("anno", this.anno);
        params.put("mese", this.mese);
        return params;
    }
}

