/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.BasicServiceStatus;
import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.config.CdConMag;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodInstance;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.RigaPod;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.D65;
import biz.elabor.prebilling.model.misure.ExtendedMno;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraD65;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.model.misure.MisuraPdo;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.Rno;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.model.prebilling.DispatchingFlussi;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.letture.MisuraMno;
import biz.elabor.prebilling.services.letture.TrattamentoHandler;
import biz.elabor.prebilling.services.letture.WriteLetstdService;
import biz.elabor.prebilling.util.MapWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.exceptions.DataException;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.listmap.ListMapKey;
import org.homelinux.elabor.structures.safe.SafeMap;
import org.homelinux.elabor.text.Format;
import org.homelinux.elabor.tools.MathUtils;
import org.homelinux.elabor.tools.StringUtils;

public class StrategyHelper {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    public static final String D65_SCHEMA = " xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" CodFlusso=\"D65\"";
    public static final List<String> MOROSITA = Arrays.asList("RT", "SM", "RT2G", "SM2G", "RTR", "SMR", "RTR2G", "SMR2G");
    public static final String TERM_DOS = "\r\n";
    public static final String TERM = "\n";
    public static final Iterable<StatoMisure> STATI = Arrays.asList(StatoMisure.VALIDATO, StatoMisure.SOSPESO);
    public static final Iterable<StatoMisure> ELABORATO = Arrays.asList(StatoMisure.ELABORATO);
    public static final Iterable<StatoMisure> STATI_ALL = Arrays.asList(StatoMisure.values());
    public static final Reseller RESELLER = new Reseller("*", null, null, false, false);
    public static final Iterable<String> PNO = Arrays.asList("PNO");
    public static final Iterable<String> PNO2G = Arrays.asList("PNO2G");
    public static final Iterable<String> PNO_ALL = Arrays.asList("PNO", "PNO2G");
    public static final Iterable<String> SNM_ALL = Arrays.asList("SNM", "SNM2G");
    public static final Iterable<String> PDO = Arrays.asList("PDO");
    public static final Iterable<String> PDO2G = Arrays.asList("PDO2G");
    public static final Iterable<String> PDO_ALL = Arrays.asList("PDO", "PDO2G");
    public static final List<String> PNO_CDUNIPRE_LIST = Arrays.asList("SE3", "RC1", "COF", "VT4", "DS1", "DS3");
    public static final List<String> ATTIVAZIONI_CDUNIPRE_LIST = Arrays.asList("AV1");
    public static final List<String> VARIAZIONI_POTENZA_CDUNIPRE_LIST = Arrays.asList("VP1", "VP3", "VP4");
    public static final List<String> VARIAZIONI_POTENZA_CDUNIPRE_STATO_POD_LIST = Arrays.asList("VP3");
    public static final List<String> CESSAZIONI_CDUNIPRE_LIST = Arrays.asList("VT4", "DS1", "DS3");
    public static final String SWITCH_CDUNIPRE = "SE1";
    public static final List<String> SWITCH_CDUNIPRE_LIST = Arrays.asList("SE1");
    public static final List<String> VOLTURE_CDUNIPRE_LIST = Arrays.asList("VT1", "VT3", "AE1");
    public static final List<String> PIV_CDUNIPRE_LIST = Arrays.asList("DS", "DSR", "DS2G", "DSR2G");
    public static final List<String> LETTURE_CDUNIPRE_LIST = new ArrayList<String>();
    public static final List<String> FLUSSI_POD_ORARI;
    private static final Set<String> POWER;
    private static final Set<String> ENERGY;
    private static final Set<String> DATES;
    private static final Set<String> CIFRE;

    static {
        LETTURE_CDUNIPRE_LIST.addAll(PNO_CDUNIPRE_LIST);
        LETTURE_CDUNIPRE_LIST.addAll(VOLTURE_CDUNIPRE_LIST);
        FLUSSI_POD_ORARI = Arrays.asList("PDO", "RFO", "PDO2G", "RFO2G");
        POWER = new HashSet<String>();
        POWER.add("potmax");
        POWER.add("potcontrimp");
        POWER.add("potimp");
        POWER.add("potdisp");
        POWER.add("ka");
        POWER.add("kr");
        POWER.add("kp");
        ENERGY = new HashSet<String>();
        ENERGY.add("eam");
        ENERGY.add("eaf1");
        ENERGY.add("eaf2");
        ENERGY.add("eaf3");
        ENERGY.add("eaf4");
        ENERGY.add("eaf5");
        ENERGY.add("eaf6");
        ENERGY.add("erm");
        ENERGY.add("erf1");
        ENERGY.add("erf2");
        ENERGY.add("erf3");
        ENERGY.add("erf4");
        ENERGY.add("erf5");
        ENERGY.add("erf6");
        ENERGY.add("ercm");
        ENERGY.add("ercf1");
        ENERGY.add("ercf2");
        ENERGY.add("ercf3");
        ENERGY.add("ercf4");
        ENERGY.add("ercf5");
        ENERGY.add("ercf6");
        ENERGY.add("erim");
        ENERGY.add("erif1");
        ENERGY.add("erif2");
        ENERGY.add("erif3");
        ENERGY.add("erif4");
        ENERGY.add("erif5");
        ENERGY.add("erif6");
        ENERGY.add("potm");
        ENERGY.add("potf1");
        ENERGY.add("potf2");
        ENERGY.add("potf3");
        ENERGY.add("potf4");
        ENERGY.add("potf5");
        ENERGY.add("potf6");
        DATES = new HashSet<String>();
        DATES.add("datainstmisatt");
        DATES.add("datainstmisrea");
        DATES.add("datainstmispot");
        DATES.add("datamessaregime2g");
        CIFRE = new HashSet<String>();
        CIFRE.add("CifreAtt");
        CIFRE.add("CifreRea");
        CIFRE.add("CifrePot");
    }

    public static void newPrintValueMap(Map<String, String> map, Map<String, Double> lastMap, Set<String> toPrint, boolean truncateEnergy, DecimalFormat energyFormat, PrebillingConfiguration configuration, PrintWriter writer, DateFormat longDateFormat, DateFormat dateFormat, double ka, double kr, double kp) {
        HashMap<String, String> translations = new HashMap<String, String>();
        StrategyHelper.newPrintValueMap(map, lastMap, toPrint, translations, truncateEnergy, energyFormat, configuration, writer, longDateFormat, dateFormat, ka, kr, kp);
    }

    public static void newPrintValueMap(Map<String, String> map, Map<String, Double> lastMap, Set<String> toPrint, Map<String, String> translations, boolean truncateEnergy, DecimalFormat energyFormat, PrebillingConfiguration configuration, PrintWriter writer, DateFormat longDateFormat, DateFormat dateFormat, double ka, double kr, double kp) {
        if (map != null) {
            for (String key : toPrint) {
                String value = map.get(key);
                String transKey = translations.containsKey(key) ? translations.get(key) : key;
                StrategyHelper.print(truncateEnergy, energyFormat, configuration, writer, transKey, value, lastMap, longDateFormat, dateFormat, ka, kr, kp);
            }
        }
    }

    public static void printValueMap(Map<String, String> map, Map<String, Double> lastMap, Set<String> banned, boolean truncateEnergy, DecimalFormat energyFormat, PrebillingConfiguration configuration, PrintWriter writer, DateFormat longDateFormat, DateFormat dateFormat, double ka, double kr, double kp) {
        HashMap<String, String> translations = new HashMap<String, String>();
        StrategyHelper.printValueMap(map, lastMap, banned, translations, truncateEnergy, energyFormat, configuration, writer, longDateFormat, dateFormat, ka, kr, kp);
    }

    public static void printValueMap(String codicePod, Map<String, String> map, Map<String, Double> valueMap, Set<String> banned, boolean truncateEnergy, DecimalFormat energyFormat, PrebillingConfiguration configuration, MapWriter writer, DateFormat longDateFormat, DateFormat dateFormat, double ka, double kr, double kp) {
        HashMap<String, String> translations = new HashMap<String, String>();
        StrategyHelper.printValueMap(codicePod, map, valueMap, banned, translations, truncateEnergy, energyFormat, configuration, writer, longDateFormat, dateFormat, ka, kr, kp);
    }

    public static void printValueMap(Map<String, String> map, Map<String, Double> lastMap, Set<String> banned, Map<String, String> translations, boolean truncateEnergy, DecimalFormat energyFormat, PrebillingConfiguration configuration, PrintWriter writer, DateFormat longDateFormat, DateFormat dateFormat, double ka, double kr, double kp) {
        if (map != null) {
            for (String key : map.keySet()) {
                String lowKey = key.toLowerCase();
                if (banned.contains(lowKey)) continue;
                String value = map.get(key);
                String transKey = translations.containsKey(key) ? translations.get(key) : key;
                StrategyHelper.print(truncateEnergy, energyFormat, configuration, writer, transKey, value, lastMap, longDateFormat, dateFormat, ka, kr, kp);
            }
        }
    }

    private static void printValueMap(String codicePod, Map<String, String> map, Map<String, Double> valueMap, Set<String> banned, Map<String, String> translations, boolean truncateEnergy, DecimalFormat energyFormat, PrebillingConfiguration configuration, MapWriter writer, DateFormat longDateFormat, DateFormat dateFormat, double ka, double kr, double kp) {
        for (String key : map.keySet()) {
            String lowKey = key.toLowerCase();
            if (banned.contains(lowKey)) continue;
            String value = map.get(key);
            String transKey = translations.containsKey(key) ? translations.get(key) : key;
            StrategyHelper.print(codicePod, truncateEnergy, energyFormat, configuration, writer, transKey, value, valueMap, longDateFormat, dateFormat, ka, kr, kp);
        }
    }

    public static void print(boolean truncateEnergy, DecimalFormat energyFormat, PrebillingConfiguration configuration, PrintWriter writer, String key, String value, Map<String, Double> lastMap, DateFormat longDateFormat, DateFormat dateFormat, double ka, double kr, double kp) {
        String formattedValue = value;
        String lowKey = key.toLowerCase();
        if (POWER.contains(lowKey)) {
            try {
                double doubleValue = Double.parseDouble(value);
                formattedValue = energyFormat.format(doubleValue);
            }
            catch (Exception doubleValue) {}
        } else if (ENERGY.contains(lowKey)) {
            try {
                Double lastValue;
                double doubleValue = Double.parseDouble(value);
                double lastDoubleValue = 0.0;
                if (lastMap != null && (lastValue = lastMap.get(key)) != null) {
                    lastDoubleValue = lastValue;
                }
                if (doubleValue >= lastDoubleValue - 1.0 && doubleValue < lastDoubleValue) {
                    doubleValue = lastDoubleValue;
                }
                if (truncateEnergy) {
                    int nCifre = StrategyHelper.getNCifre(configuration, lowKey, ka, kr, kp);
                    doubleValue = MathUtils.floor(doubleValue, nCifre);
                }
                formattedValue = energyFormat.format(doubleValue);
            }
            catch (Exception doubleValue) {}
        } else if (DATES.contains(lowKey)) {
            try {
                Date date = longDateFormat.parse(value);
                formattedValue = dateFormat.format(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (CIFRE.contains(key) && (value == null || value.trim().isEmpty())) {
            formattedValue = configuration.getCifreStd();
        }
        if (formattedValue != null && !formattedValue.trim().isEmpty()) {
            writer.println("<" + key + ">" + formattedValue.trim() + "</" + key + ">");
        }
    }

    private static void print(String codicePod, boolean truncateEnergy, DecimalFormat energyFormat, PrebillingConfiguration configuration, MapWriter writer, String key, String value, Map<String, Double> valueMap, DateFormat longDateFormat, DateFormat dateFormat, double ka, double kr, double kp) {
        String formattedValue = value;
        String lowKey = key.toLowerCase();
        if (POWER.contains(lowKey)) {
            try {
                double doubleValue = Double.parseDouble(value);
                formattedValue = energyFormat.format(doubleValue);
            }
            catch (Exception doubleValue) {}
        } else if (ENERGY.contains(lowKey)) {
            try {
                Double lastValue;
                double doubleValue = Double.parseDouble(value);
                double lastDoubleValue = 0.0;
                if (valueMap != null && (lastValue = valueMap.get(key)) != null) {
                    lastDoubleValue = lastValue;
                }
                if (doubleValue >= lastDoubleValue - 1.0 && doubleValue < lastDoubleValue) {
                    doubleValue = lastDoubleValue;
                }
                if (truncateEnergy) {
                    int nCifre = StrategyHelper.getNCifre(configuration, lowKey, ka, kr, kp);
                    doubleValue = MathUtils.floor(doubleValue, nCifre);
                }
                formattedValue = energyFormat.format(doubleValue);
            }
            catch (Exception doubleValue) {}
        } else if (DATES.contains(lowKey)) {
            try {
                Date date = longDateFormat.parse(value);
                formattedValue = dateFormat.format(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (CIFRE.contains(key) && (value == null || value.trim().isEmpty())) {
            formattedValue = configuration.getCifreStd();
        }
        writer.print(codicePod, "<" + key + ">" + (formattedValue == null ? "" : formattedValue.trim()) + "</" + key + ">", TERM);
    }

    private static int getNCifre(PrebillingConfiguration configuration, String lowKey, double ka, double kr, double kp) {
        return lowKey.startsWith("ea") ? configuration.getNCifreAttiva(ka) : (lowKey.startsWith("er") ? configuration.getNCifreReattiva(kr) : configuration.getNCifrePotenza(kp));
    }

    public static void checkDisallineato(Pod pod, MisuraNonoraria mno, List<MisuraNonoraria> listToExport) {
        if (!StrategyHelper.checkAllineamento(pod, mno)) {
            listToExport.add(mno);
        }
    }

    public static void checkDisallineatoNoCrm(Pod pod, MisuraNonoraria mno, List<ExtendedMno> listToExport) {
        if (!StrategyHelper.checkAllineamento(pod, mno)) {
            ExtendedMno toExport = new ExtendedMno(mno, pod);
            listToExport.add(toExport);
        }
    }

    public static boolean checkAllineamento(Pod pod, MisuraNonoraria pno) {
        boolean ok = true;
        if (pod.isAllineato()) {
            ok = StrategyHelper.checkAllineamentoStretto(pod, pno, false, null);
        }
        return ok;
    }

    public static boolean checkAllineamentoStretto(Pod pod, MisuraNonoraria pno, boolean noReattiva, Set<String> tarDisDom) {
        boolean ok = true;
        Date date = pno.getDataMisura();
        ok &= pod.isMisuraAttiva(date) == pno.hasAttiva();
        ok &= pod.isMisuraReattiva(date) == pno.hasReattiva() || noReattiva && StrategyHelper.checkReattiva(pod, tarDisDom);
        if (ok &= pod.isMisuraPotenza(date) == pno.hasPotenza()) {
            ok = StrategyHelper.checkK(pod, pno);
        }
        return ok;
    }

    public static boolean checkK(Pod pod, MisuraNonoraria mno) {
        boolean ok = true;
        Date date = mno.getDataMisura();
        if (pod.isMisuraAttiva(date)) {
            ok &= pod.getKa(date) == mno.getKa().doubleValue();
        }
        if (pod.isMisuraReattiva(date)) {
            ok &= pod.getKr(date) == mno.getKr().doubleValue();
        }
        if (pod.isMisuraPotenza(date)) {
            ok &= pod.getKp(date) == mno.getKp().doubleValue();
        }
        return ok;
    }

    public static boolean checkReattiva(Pod pod, Set<String> tarDisDom) {
        String tarDis = pod.getTarDis();
        double potImp = pod.getPotImp();
        return tarDisDom.contains(tarDis) || potImp <= 15.0;
    }

    public static void printDatiPod(PrintWriter writer, Map<String, Map<String, String>> datiPod, Map<String, Double> lastMap, Set<String> banned, boolean truncateEnergy, DecimalFormat energyFormat, PrebillingConfiguration configuration, DateFormat longDateFormat, DateFormat dateFormat, double ka, double kr, double kp) {
        for (String nomeDati : datiPod.keySet()) {
            Map<String, String> mappaDettagli = datiPod.get(nomeDati);
            writer.println("<" + nomeDati + ">");
            StrategyHelper.printValueMap(mappaDettagli, lastMap, banned, truncateEnergy, energyFormat, configuration, writer, longDateFormat, dateFormat, ka, kr, kp);
            writer.println("</" + nomeDati + ">");
        }
    }

    public static void printDatiPod(D65 dati, Map<String, Double> lastMap, Date dataMisura, Set<String> banned, boolean truncateEnergy, DecimalFormat energyFormat, PrebillingConfiguration configuration, PrintWriter writer, DateFormat longDateFormat, DateFormat dateFormat) {
        String codicePod = dati.getCodicePod();
        Map<String, Map<String, String>> datiPod = dati.getDatiPod();
        writer.println("<DatiPod>");
        writer.println("<Pod>" + codicePod + "</Pod>");
        String codPratAtt = dati.getCodPratAtt();
        if (codPratAtt != null) {
            writer.println("<CodPratAtt>" + codPratAtt + "</CodPratAtt>");
        }
        writer.println("<DataMisura>" + dateFormat.format(dataMisura) + "</DataMisura>");
        double ka = StrategyHelper.getK(dati.getKa());
        double kr = StrategyHelper.getK(dati.getKr());
        double kp = StrategyHelper.getK(dati.getKp());
        StrategyHelper.printDatiPod(writer, datiPod, lastMap, banned, truncateEnergy, energyFormat, configuration, longDateFormat, dateFormat, ka, kr, kp);
        writer.println("</DatiPod>");
    }

    public static ErroriElaborazione getErroreElaborazione(DataException exc) {
        int error = exc.getError();
        return ErroriElaborazione.values()[error];
    }

    public static boolean matchReseller(String azienda, String reseller) {
        return reseller.isEmpty() || reseller.equals(azienda);
    }

    public static Reseller getReseller(String azienda, ServiceStatus status) throws DataNotFoundException {
        SafeMap<String, Reseller> resellers = status.getResellers();
        return (Reseller)resellers.get(azienda);
    }

    public static PraticaVolo getPiv(String codicePod, Date dataInizio, StatusTransaction transaction) throws DataNotFoundException {
        ListMap<String, PraticaVolo> piv = transaction.getPiv();
        return StrategyHelper.getPiv(codicePod, dataInizio, piv);
    }

    public static PraticaVolo getPiv(String codicePod, Date dataInizio, ServiceStatus status) throws DataNotFoundException {
        ListMap<String, PraticaVolo> piv = status.getPiv();
        return StrategyHelper.getPiv(codicePod, dataInizio, piv);
    }

    private static PraticaVolo getPiv(String codicePod, Date data, ListMap<String, PraticaVolo> piv) throws DataNotFoundException {
        List podPivs = (List)piv.get(codicePod);
        if (podPivs == null) {
            int errore = ErroriElaborazione.PIV_NOTFOUND.ordinal();
            throw new DataNotFoundException("piv.notfound", codicePod, errore);
        }
        return data == null ? (PraticaVolo)podPivs.get(0) : StrategyHelper.getPiv(codicePod, data, podPivs);
    }

    private static PraticaVolo getPiv(String codicePod, Date data, List<PraticaVolo> podPivs) throws DataNotFoundException {
        PraticaVolo piv = null;
        Iterator<PraticaVolo> iterator = podPivs.iterator();
        while (piv == null && iterator.hasNext()) {
            PraticaVolo current = iterator.next();
            SpecificaTecnica specificaTecnica = current.getSpecificaTecnica();
            Date dataPiv = specificaTecnica.getData();
            if (!data.equals(dataPiv)) continue;
            piv = current;
        }
        if (piv == null) {
            int errore = ErroriElaborazione.PIV_NOTFOUND.ordinal();
            DateFormat dataFormat = StrategyHelper.getDataFormat();
            String key = String.valueOf(codicePod) + " - " + dataFormat.format(data);
            throw new DataNotFoundException("piv.notfound", key, errore);
        }
        return piv;
    }

    public static Set<String> buildBanned(Pod pod, Mno vno) {
        Date date = vno.getDataMisura();
        return pod.isAllineato() ? StrategyHelper.buildBanned(vno) : StrategyHelper.buildBanned(pod, date);
    }

    public static Set<String> buildBanned(MisuraD65 vno) {
        HashSet<String> banned = new HashSet<String>();
        banned.add("motivazionestima");
        banned.add("potmax");
        banned.add("ercf1");
        banned.add("ercf2");
        banned.add("ercf3");
        banned.add("ercf4");
        banned.add("ercf5");
        banned.add("ercf6");
        banned.add("erif1");
        banned.add("erif2");
        banned.add("erif3");
        banned.add("erif4");
        banned.add("erif5");
        banned.add("erif6");
        if (!vno.hasAttiva()) {
            banned.add("matratt");
            banned.add("cifreatt");
            banned.add("datainstmisatt");
            banned.add("eam");
            banned.add("eaf1");
            banned.add("eaf2");
            banned.add("eaf3");
            banned.add("ka");
        }
        if (!vno.hasReattiva()) {
            banned.add("matrrea");
            banned.add("cifrerea");
            banned.add("datainstmisrea");
            banned.add("erm");
            banned.add("erf1");
            banned.add("erf2");
            banned.add("erf3");
            banned.add("kr");
        }
        if (!vno.hasPotenza()) {
            banned.add("matrpot");
            banned.add("cifrepot");
            banned.add("datainstmispot");
            banned.add("potm");
            banned.add("potf1");
            banned.add("potf2");
            banned.add("potf3");
            banned.add("kp");
        }
        if (vno.isForfait()) {
            banned.add("matratt");
            banned.add("datainstmisatt");
            banned.add("validato");
            banned.add("eaf2");
            banned.add("eaf3");
            banned.add("tipodato");
        }
        return banned;
    }

    private static Set<String> buildBanned(Pod pod, Date date) {
        HashSet<String> banned = new HashSet<String>();
        if (!pod.isMisuraAttiva(date)) {
            banned.add("matratt");
            banned.add("cifreatt");
            banned.add("datainstmisatt");
            banned.add("eam");
            banned.add("eaf1");
            banned.add("eaf2");
            banned.add("eaf3");
            banned.add("ka");
        }
        if (!pod.isMisuraReattiva(date)) {
            banned.add("matrrea");
            banned.add("cifrerea");
            banned.add("datainstmisrea");
            banned.add("erm");
            banned.add("erf1");
            banned.add("erf2");
            banned.add("erf3");
            banned.add("kr");
        }
        if (!pod.isMisuraPotenza(date)) {
            banned.add("matrpot");
            banned.add("cifrepot");
            banned.add("datainstmispot");
            banned.add("potm");
            banned.add("potf1");
            banned.add("potf2");
            banned.add("potf3");
            banned.add("kp");
        }
        return banned;
    }

    public static void handleKX(Rno rno) throws DataNotFoundException {
        boolean allineato = rno.isAllineato();
        boolean attiva = rno.isAttiva();
        boolean reattiva = rno.isReattiva();
        boolean potenza = rno.isPotenza();
        Mno mno = rno.getMno();
        StrategyHelper.handleKX(mno, allineato, attiva, reattiva, potenza);
    }

    public static void handleKX(Pod pod, Mno mno) throws DataNotFoundException {
        Date date = mno.getDataMisura();
        boolean allineato = pod.isAllineato();
        boolean attiva = pod.isMisuraAttiva(date);
        boolean reattiva = pod.isMisuraReattiva(date);
        boolean potenza = pod.isMisuraPotenza(date);
        StrategyHelper.handleKX(mno, allineato, attiva, reattiva, potenza);
    }

    private static void handleKX(Mno mno, boolean allineato, boolean attiva, boolean reattiva, boolean potenza) throws DataNotFoundException {
        if (allineato) {
            StrategyHelper.checkKa(mno);
            StrategyHelper.checkKr(mno);
            StrategyHelper.checkKp(mno);
        } else {
            StrategyHelper.handleKa(attiva, mno);
            StrategyHelper.handleKr(reattiva, mno);
            StrategyHelper.handleKp(potenza, mno);
        }
    }

    private static void handleKp(boolean misuraPotenza, Mno mno) {
        String kp = mno.getKpSegnale();
        String newKp = StrategyHelper.getKx(misuraPotenza, kp);
        mno.setKp(newKp);
    }

    private static void handleKr(boolean misuraReattiva, Mno mno) {
        String kr = mno.getKrSegnale();
        String newKr = StrategyHelper.getKx(misuraReattiva, kr);
        mno.setKr(newKr);
    }

    private static void handleKa(boolean misuraAttiva, Mno mno) {
        String ka = mno.getKaSegnale();
        String newKa = StrategyHelper.getKx(misuraAttiva, ka);
        mno.setKa(newKa);
    }

    private static String getKx(boolean misuraAttiva, String kx) {
        return misuraAttiva && kx != null && Double.parseDouble(kx) == 0.0 ? "1" : kx;
    }

    private static void checkKp(Mno mno) throws DataNotFoundException {
        StrategyHelper.checkKx(mno.getKp(), "Kp");
    }

    private static void checkKr(Mno mno) throws DataNotFoundException {
        StrategyHelper.checkKx(mno.getKr(), "Kr");
    }

    private static void checkKa(Mno mno) throws DataNotFoundException {
        StrategyHelper.checkKx(mno.getKa(), "Ka");
    }

    private static void checkKx(Number kx, String key) throws DataNotFoundException {
        if (kx != null && kx.doubleValue() == 0.0) {
            throw new DataNotFoundException("coeff.notvalid", key, ErroriElaborazione.COEFF_NONVALIDO.ordinal());
        }
    }

    public static void sortByDate(List<Mno> vnos) {
        Collections.sort(vnos, new Comparator<Mno>(){

            @Override
            public int compare(Mno o1, Mno o2) {
                return o1.getDataMisura().compareTo(o2.getDataMisura());
            }
        });
    }

    public static String fillPodMap(List<RigaPod> righePod, int anno, Month mese, DefaultPodMap podMap) {
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        Date startDate = calendar.getDate();
        calendar.addMesi(1);
        calendar.addGiorni(-1);
        Date endDate = calendar.getDate();
        Pod pod = null;
        Date prevDate = null;
        String lastCodice = null;
        for (RigaPod riga : righePod) {
            String codice = riga.getCodice();
            String numatric = riga.getNumatric();
            String ccLettur = riga.getCcLettur();
            PrebillingContext.setContext("fillPodMap", "pod: " + codice);
            Date inizioReale = riga.getInizio();
            Date dataInst = riga.getDataInst();
            String dispatcher = riga.getDispatcher();
            ElaborCalendar inizioCalendar = new ElaborCalendar(inizioReale);
            inizioCalendar.addGiorni(-1);
            Date inizioConvenzionale = inizioCalendar.getDate();
            if (riga.isNuovaFornitura()) {
                inizioCalendar.addGiorni(-1);
            }
            Date inizioConsumi = inizioCalendar.getDate();
            boolean attiva = riga.getMisuraAttiva();
            boolean reattiva = riga.getMisuraReattiva();
            boolean potenza = riga.getMisuraPotenza();
            boolean azzcon = riga.isAzzcon();
            String cdConMag = riga.getCdconmag();
            double attF1 = riga.getAttF1();
            double attF2 = riga.getAttF2();
            double attF3 = riga.getAttF3();
            double reaF1 = riga.getReaF1();
            double reaF2 = riga.getReaF2();
            double reaF3 = riga.getReaF3();
            double kA = riga.getkA();
            double kR = riga.getkR();
            double kP = riga.getkP();
            boolean podNuovo = riga.isPodNuovo();
            String pivaDispatcher = riga.getPivaDispatcher();
            String pivaDistributore = riga.getPivaDistributore();
            SpecificaTecnica specifica = riga.getSpecificaTecnica();
            String codiceOfferta = specifica.getCodiceOfferta();
            Date switchout = riga.getSwitchout();
            if (pod == null || !codice.equals(pod.getCodice()) || !dispatcher.equals(pod.getDispatcher())) {
                ArrayList<PodInstance> instances;
                if (pod == null) {
                    instances = new ArrayList<PodInstance>();
                } else {
                    instances = dispatcher.equals(pod.getDispatcher()) ? new ArrayList() : pod.getInstances();
                    podMap.addWithDispatcher(pod);
                    lastCodice = pod.getCodice();
                }
                prevDate = null;
                boolean orario = riga.isOrario();
                int tensione = riga.getTensione();
                String azienda = riga.getAzienda();
                Date dataMax = riga.getDataMax();
                Date fine = riga.getFine();
                String statoUtenza = riga.getStatoUtenza();
                String tarDis = riga.getTarDis();
                double potImp = riga.getPotImp();
                boolean allineato = riga.isAllineato();
                boolean attesaSnm = riga.isAttesaSnm();
                boolean nuovaFornitura = riga.isNuovaFornitura();
                boolean commerciale = riga.isCommerciale();
                double potDisponibile = riga.getPotDisponibile();
                String cdcomist = riga.getCdcomist();
                pod = new Pod(codice, orario, tensione, azienda, inizioConsumi, fine, attiva, reattiva, potenza, dataMax, statoUtenza, dispatcher, allineato, switchout, attesaSnm, tarDis, potImp, potDisponibile, nuovaFornitura, attF1, attF2, attF3, reaF1, reaF2, reaF3, codiceOfferta, kA, kR, kP, commerciale, numatric, podNuovo, cdcomist, instances);
                pod.setInizioConvenzionale(inizioConvenzionale);
            }
            if (inizioConsumi.before(startDate)) {
                Date dataTecnica = specifica.getData();
                Date fine = riga.getFine();
                if (dataTecnica != null && dataTecnica.before(endDate) && (fine == null || dataTecnica.before(fine))) {
                    prevDate = StrategyHelper.addSpecificaTecnica(pod, specifica, prevDate);
                }
                if (fine != null && fine.before(endDate)) {
                    SpecificaTecnica fineDateSpec = new SpecificaTecnica(codiceOfferta, fine);
                    prevDate = StrategyHelper.addSpecificaTecnica(pod, fineDateSpec, prevDate);
                }
            } else {
                SpecificaTecnica inizioDateSpec = new SpecificaTecnica(codiceOfferta, inizioConsumi);
                prevDate = StrategyHelper.addSpecificaTecnica(pod, inizioDateSpec, prevDate);
            }
            PodInstance instance = new PodInstance(dataInst, attiva, reattiva, potenza, azzcon, kA, kR, kP, cdConMag, podNuovo, inizioReale, pivaDistributore, pivaDispatcher, numatric, ccLettur);
            pod.addInstance(instance);
            pod.setSwitchout(switchout);
        }
        return lastCodice == null ? "" : lastCodice;
    }

    private static Date addSpecificaTecnica(Pod pod, SpecificaTecnica dateSpec, Date prevDate) {
        Date date = dateSpec.getData();
        Date currDate = null;
        if (prevDate == null || prevDate.before(date)) {
            pod.addSpecificaTecnica(dateSpec);
            currDate = date;
        }
        return currDate;
    }

    public static String getPotMaxXml(Mno mno, DecimalFormat itEnergyFormat) {
        Number potMax = mno.getPotMax();
        return potMax == null ? null : itEnergyFormat.format(potMax);
    }

    public static String handleErrore(Pod pod, ErroriElaborazione errore, TalkManager talkManager) {
        String message = errore.getMessage();
        Warning sentence = new Warning("aggregation.strategy", message);
        String codicePod = pod.getCodice();
        sentence.addParam(codicePod);
        sentence.setCss("alert-warning");
        talkManager.addSentence(sentence);
        return talkManager.getMessage(sentence);
    }

    public static String handleRuntimeException(Exception exc, String codicePod, String ambito, TalkManager talkManager, BasicServiceStatus status) {
        Warning sentence = new Warning(ambito, "excluding.error");
        sentence.setCss("alert-danger");
        sentence.addParam(codicePod);
        talkManager.addSentence(sentence);
        Logger logger = status.getLogger();
        String userMessage = talkManager.getMessage(sentence);
        logger.log(Level.SEVERE, userMessage, exc);
        exc.printStackTrace();
        return userMessage;
    }

    public static String createCdconmag(Pod pod, boolean azzeramento, String tarDis, MisuraNonoraria mno, PrebillingConfiguration configuration) {
        int tensione = pod.getTensione();
        String keyCdConMag = StrategyHelper.getKeyCdConMag(tensione, azzeramento, tarDis, mno);
        CdConMag cdConMag = configuration.getCdConMag(keyCdConMag);
        return cdConMag.getValue();
    }

    public static String getKeyCdConMag(int tensione, boolean isAzzeramento, String tarDis, MisuraNonoraria mno) {
        String flussoFunzionale = mno.getFlussoFunzionale();
        String codiceFlusso = mno.getCodiceFlusso();
        String tipoMisuratore = mno.getTipoMisuratore();
        Trattamento trattamento = mno.getTrattamento();
        boolean mono = mno.getEAF2() == null;
        boolean forfait = mno.isForfait();
        return StrategyHelper.getKeyCdConMag(codiceFlusso, flussoFunzionale, tensione, trattamento, tipoMisuratore, isAzzeramento, mono, forfait, tarDis);
    }

    public static String getKeyCdConMag(String codiceFlusso, String flussoFunzionale, int tensione, Trattamento trattamento, String tipoMisuratore, boolean isAzzeramento, boolean mono, boolean forfait, String tarDis) {
        String keyCdConMag = "SMIS".equals(codiceFlusso) ? (tipoMisuratore.equals("T") ? "MONO" : (tipoMisuratore.equals("E") ? (mono ? "MONO" : "CE") : "CE2G")) : ("F2G".equalsIgnoreCase(flussoFunzionale) || codiceFlusso.endsWith("2G") ? (isAzzeramento ? "CEO2G" : "CE2G") : (forfait ? "FORFAIT" : (tensione >= 1000 ? "GME" : trattamento.getOrdCdConmag(tarDis))));
        return keyCdConMag;
    }

    public static void fixPotenza(Mno vno) {
        Map<String, Map<String, String>> datiPod = vno.getDatiPod();
        Misura misuraValue = vno.getMisura();
        Map<String, String> misuraOrig = datiPod.get("Misura");
        StrategyHelper.fixPotenza(misuraOrig, misuraValue);
    }

    public static void fixPotenza(Map<String, String> misuraOrig, Misura misuraValue) {
        if (misuraOrig != null) {
            FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
            int n2 = fasciaOrariaArray.length;
            int n3 = 0;
            while (n3 < n2) {
                FasciaOraria fascia = fasciaOrariaArray[n3];
                String key = "Pot" + fascia.name();
                String potenzaOrig = misuraOrig.get(key);
                if (potenzaOrig != null) {
                    double potenzaValue = misuraValue.getPotenza(fascia).getNetto();
                    potenzaOrig = String.valueOf(potenzaValue);
                    misuraOrig.put(key, potenzaOrig);
                }
                ++n3;
            }
        }
    }

    public static void addMisureRettifica(String codicePod, String azienda, Map<String, ListMapKey<String, MisuraMno>> misureRettifica, Map<String, Map<String, MapWriter>> rettificheWriter, ServiceStatus status) {
        PrebillingConfiguration configuration = status.getConfiguration();
        WriteLetstdService service = new WriteLetstdService(codicePod, configuration);
        StrategyHelper.addMisureRettifica(codicePod, azienda, misureRettifica, service, rettificheWriter);
    }

    private static void addMisureRettifica(String codicePod, String azienda, Map<String, ListMapKey<String, MisuraMno>> misureRettifica, WriteLetstdService service, Map<String, Map<String, MapWriter>> mapMapWriter) {
        for (Map.Entry<String, ListMapKey<String, MisuraMno>> entry : misureRettifica.entrySet()) {
            String codiceFlusso = entry.getKey();
            ListMapKey<String, MisuraMno> misureFlusso = entry.getValue();
            StrategyHelper.addMisureRettifica(codicePod, azienda, codiceFlusso, misureFlusso, service, mapMapWriter);
        }
    }

    private static void addMisureRettifica(String codicePod, String azienda, String codiceFlusso, ListMapKey<String, MisuraMno> misureFlusso, WriteLetstdService service, Map<String, Map<String, MapWriter>> mapMapWriter) {
        MapWriter mapWriter = ServiceStatus.getMisureWriter(codiceFlusso, azienda, mapMapWriter);
        StrategyHelper.addMisureRettifica(codicePod, misureFlusso, mapWriter, service);
    }

    private static void addMisureRettifica(String codicePod, ListMapKey<String, MisuraMno> misureFlusso, MapWriter mapWriter, WriteLetstdService service) {
        List misurePod = (List)misureFlusso.get(codicePod);
        MisuraMno misuraMno = (MisuraMno)misurePod.get(0);
        Trattamento trattamento = misuraMno.getTrattamento();
        TrattamentoHandler handler = trattamento.getHandler();
        service.write(misurePod, mapWriter, handler, false);
    }

    public static boolean checkDispatcher(Pod pod, String dispatcher) {
        String podDispatcher = pod.getDispatcher();
        return dispatcher.isEmpty() || podDispatcher.equals(dispatcher);
    }

    public static DateFormat getMeseAnnoFormat() {
        return new SimpleDateFormat("MM/yyyy");
    }

    public static DecimalFormat getItEnergyFormat() {
        return Format.newDecimalFormat(Locale.ITALIAN, "#0.000");
    }

    public static DecimalFormat getUsEnergyFormat() {
        return Format.newDecimalFormat(Locale.US, "#0.000");
    }

    public static DecimalFormat getMeseNumFormat() {
        return Format.newDecimalFormat(Locale.ITALIAN, "00");
    }

    public static DateFormat getFullDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    }

    public static DateFormat getLongDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static DateFormat getDataFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public static DateFormat getGiornoFormat() {
        return new SimpleDateFormat("dd");
    }

    public static MisuraPdo buildMisuraZero(MisuraPdo misuraPdo) {
        Pod pod = misuraPdo.getPod();
        Pdo pdo = misuraPdo.getPdo();
        Date date = misuraPdo.getDataMisura();
        boolean stimata = misuraPdo.getMisura().isStimata();
        String codiceFlusso = misuraPdo.getCodiceFlusso();
        Misura misura = new Misura(date, stimata, 3, codiceFlusso);
        MisuraPdo misuraZero = new MisuraPdo(pod, pdo, misura);
        misuraZero.setKa(misuraPdo.getKaString());
        misuraZero.setKr(misuraPdo.getKrString());
        misuraZero.setKp(misuraPdo.getKpString());
        return misuraZero;
    }

    public static RilMese merge(RilMese rettifica, RilMese originale) {
        String codicePod = rettifica.getCodicePod();
        int anno = rettifica.getAnno();
        Month mese = rettifica.getMese();
        String matricola = rettifica.getMatricola();
        RilMese valore = new RilMese(codicePod, anno, mese, matricola);
        Iterator<RilGiorno> rettIterator = rettifica.iterator();
        Iterator<RilGiorno> origIterator = originale.iterator();
        RilGiorno origGiorno = (RilGiorno)origIterator.next();
        RilGiorno rettGiorno = (RilGiorno)rettIterator.next();
        while (origGiorno != null || rettGiorno != null) {
            Date rettDate;
            Date origDate = origGiorno == null ? CalendarTools.getEndOfTime() : origGiorno.getDate();
            Date date = rettDate = rettGiorno == null ? CalendarTools.getEndOfTime() : rettGiorno.getDate();
            if (origDate.equals(rettDate)) {
                valore.add(rettGiorno);
                origGiorno = StrategyHelper.nextGiorno(origIterator);
                rettGiorno = StrategyHelper.nextGiorno(rettIterator);
                continue;
            }
            if (origDate.before(rettDate)) {
                valore.add(origGiorno);
                origGiorno = StrategyHelper.nextGiorno(origIterator);
                continue;
            }
            valore.add(rettGiorno);
            rettGiorno = StrategyHelper.nextGiorno(rettIterator);
        }
        return valore;
    }

    private static RilGiorno nextGiorno(Iterator<RilGiorno> iterator) {
        return iterator.hasNext() ? iterator.next() : null;
    }

    public static Number unoifnull(Number value) {
        return value == null ? (Number)1.0 : (Number)value;
    }

    public static Date getTimeout(Date toDay, int ritardo) {
        ElaborCalendar calendar = new ElaborCalendar(toDay);
        calendar.addGiorni(-ritardo);
        return calendar.getDate();
    }

    public static double getK(Number k2) {
        return k2 == null ? 0.0 : k2.doubleValue();
    }

    public static WorkingPeriod checkWorkingPeriod(String annoTxt, String meseTxt, PrebillingConfiguration configuration) throws InvalidParameterValue {
        WorkingPeriod workingPeriod;
        if (StringUtils.isEmpty(annoTxt) || StringUtils.isEmpty(meseTxt)) {
            Date toDay = configuration.getToDay();
            workingPeriod = new WorkingPeriod(toDay);
        } else {
            int anno = ControllerHelper.checkInt("anno", annoTxt);
            Month mese = ControllerHelper.checkEnum("mese", meseTxt, Month.class);
            workingPeriod = new WorkingPeriod(anno, mese);
        }
        return workingPeriod;
    }

    public static DateFormat getPlainDateFormat() {
        return new SimpleDateFormat("dd-MM-yyyy");
    }

    public static void addMnoObsoleti(List<Mno> obsoleti, String codiceReseller, ServiceStatus status, TalkManager talkManager) {
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        ErroriElaborazione errore = ErroriElaborazione.OBSOLETO;
        for (Mno mno : obsoleti) {
            mno.setCdaziend(codiceReseller);
            MnoResult result = StrategyHelper.handleResult(mno, errore, talkManager, dateFormat);
            status.addPnoObsoleto(result);
        }
    }

    private static MnoResult handleResult(Mno mno, ErroriElaborazione errore, TalkManager talkManager, DateFormat dateFormat) {
        String message = errore.getMessage();
        Message sentence = new Message("", message);
        String codicePod = mno.getCodicePod();
        Date dataMisura = mno.getDataMisura();
        sentence.addParam(codicePod);
        sentence.addParam(dateFormat.format(dataMisura));
        talkManager.addSentence(sentence);
        String descrizione = talkManager.getMessage(sentence);
        return new MnoResult(mno, errore, descrizione);
    }

    @Deprecated
    public static boolean isCrmLate(PrebillingConfiguration configuration, String flusso, String azienda, String codicePrestazione, ServiceStatus status) throws DataNotFoundException {
        String flussoDispatch = FLUSSI_POD_ORARI.contains(flusso) ? "PDO" : "PNO";
        return StrategyHelper.isCrm(configuration, flussoDispatch, azienda, codicePrestazione, status);
    }

    public static String getDestinazioneLate(PrebillingConfiguration configuration, String flusso, String azienda, String codicePrestazione, ServiceStatus status) throws DataNotFoundException {
        String flussoDispatch = FLUSSI_POD_ORARI.contains(flusso) ? "PDO" : "PNO";
        return StrategyHelper.getDestinazione(configuration, flussoDispatch, azienda, codicePrestazione, status);
    }

    @Deprecated
    public static boolean isCrm(PrebillingConfiguration configuration, String flusso, String azienda, String codicePrestazione, ServiceStatus status) throws DataNotFoundException {
        boolean crm = configuration.hasCrm();
        if (crm) {
            SafeMap<String, Reseller> resellers = status.getResellers();
            Reseller reseller = (Reseller)resellers.get(azienda);
            DispatchingFlussi dispatchingFlussi = status.getDispatchingFlussi();
            boolean resellerCrm = reseller.isCrm();
            crm = dispatchingFlussi.isCrm("E", codicePrestazione, flusso, azienda, resellerCrm);
        }
        return crm;
    }

    public static String getDestinazione(PrebillingConfiguration configuration, String flusso, String azienda, String codicePrestazione, ServiceStatus status) throws DataNotFoundException {
        String destinazione;
        if (configuration.hasCrm()) {
            SafeMap<String, Reseller> resellers = status.getResellers();
            Reseller reseller = (Reseller)resellers.get(azienda);
            DispatchingFlussi dispatchingFlussi = status.getDispatchingFlussi();
            boolean resellerCrm = reseller.isCrm();
            destinazione = dispatchingFlussi.getDestinazione("E", codicePrestazione, flusso, azienda, resellerCrm);
        } else {
            destinazione = "";
        }
        return destinazione;
    }
}

