/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services;

import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.services.common.statopod.StatoPodChecker;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;

public class PrestazioniStatoPodChecker
implements StatoPodChecker<Mno> {
    @Override
    public void check(Mno current, StatoPod riferimento, String prestazione) throws StatoPodInvalidoException {
        int nnFasciaRif;
        int tensioneRif;
        String codicePod = current.getCodicePod();
        ErroriElaborazione errore = ErroriElaborazione.STATOPOD_DISALLINEATO;
        String message = errore.getMessage();
        int tensione = Integer.valueOf(current.getTensione());
        if (tensione != (tensioneRif = riferimento.getTensione())) {
            String specification = "tensione " + tensioneRif + "/" + tensione;
            throw new StatoPodInvalidoException(message, errore, codicePod, specification);
        }
        boolean mono = current.getTrattamento(null).isMono();
        if (mono != ((nnFasciaRif = riferimento.getNnFascia()) == 1)) {
            String specification = "fasce " + nnFasciaRif + "/" + (mono ? 1 : 3);
            throw new StatoPodInvalidoException(message, errore, codicePod, specification);
        }
        double ka = current.getKa().doubleValue();
        double kaRif = riferimento.getInmisCon();
        double kr = current.getKr().doubleValue();
        double krRif = riferimento.getInmisRea();
        double kp = current.getKp().doubleValue();
        double kpRif = riferimento.getInmisPot();
        if (ka != kaRif || kr != krRif || kp != kpRif) {
            String specification = "K " + kaRif + "-" + krRif + "-" + kpRif + "/" + ka + "-" + kr + "-" + kp;
            throw new StatoPodInvalidoException(message, errore, codicePod, specification);
        }
    }
}

