/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategyHelper;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public abstract class PrestazioniOrfaneStrategy
implements ServiceStrategy {
    private final int anno;
    private final Month mese;
    private final MisureDao misureDao;
    private final TalkManager talkManager;
    private final Iterable<String> flussi;

    public PrestazioniOrfaneStrategy(int anno, Month mese, MisureDao misureDao, TalkManager talkManager, Iterable<String> flussi) {
        this.anno = anno;
        this.mese = mese;
        this.misureDao = misureDao;
        this.talkManager = talkManager;
        this.flussi = flussi;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ListMap<String, PraticaVolo> pivMap = status.getPiv();
        List<Mno> mnoList = this.misureDao.getMnoPrestazione(this.anno, this.mese, StrategyHelper.STATI, this.flussi);
        for (Mno mno : mnoList) {
            if (PrestazioniOrfaneStrategy.exists(mno, pivMap) || this.rettifica(mno)) continue;
            ErroriElaborazione error = ErroriElaborazione.PIV_NOTFOUND;
            String message = error.getMessage();
            Message sentence = new Message("orfane", message);
            sentence.addParam(mno.getCodicePod());
            this.talkManager.addSentence(sentence);
            String userMessage = this.talkManager.getMessage(sentence);
            MnoResult result = new MnoResult(mno, error, userMessage);
            status.addPnoSospeso(result);
        }
        return true;
    }

    private boolean rettifica(Mno mno) {
        String codicePod = mno.getCodicePod();
        Date dataPratica = mno.getDataPrestazione();
        return mno.getCodiceFlusso().replace("2G", "").endsWith("R") && this.misureElaborate(codicePod, dataPratica);
    }

    private static boolean exists(Mno mno, ListMap<String, PraticaVolo> pivMap) {
        boolean found = false;
        String codicePod = mno.getCodicePod();
        List pivList = (List)pivMap.get(codicePod);
        if (pivList != null) {
            for (PraticaVolo piv : pivList) {
                Date dataPrestazione;
                SpecificaTecnica specificaTecnica = piv.getSpecificaTecnica();
                Date data = specificaTecnica.getData();
                if (!data.equals(dataPrestazione = mno.getDataPrestazione())) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    private boolean misureElaborate(String codicePod, Date dataPratica) {
        List<Mno> elaborate = this.misureDao.getMnoPrestazione(codicePod, dataPratica, StrategyHelper.ELABORATO, this.flussi);
        return !elaborate.isEmpty();
    }
}

