/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services;

import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.model.misure.RilQuartoType;
import java.util.Date;
import org.homelinux.elabor.calendar.DaysOfMonthIterator;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;

public class HelperTest {
    public static RilMese buildRilMese(String codicePod, int anno, Month mese) {
        return HelperTest.buildRilMese(codicePod, "PDO", anno, mese);
    }

    public static RilMese buildRilMese(String codicePod, String codiceFlusso, int anno, Month mese) {
        RilMese rilMese = new RilMese(codicePod, anno, mese, null);
        DaysOfMonthIterator iterator = new DaysOfMonthIterator(2016, Month.JUNE);
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        while (iterator.hasNext()) {
            int giorno = iterator.next();
            calendar.setGiorno(giorno);
            Date date = calendar.getDate();
            RilGiorno rilGiorno = new RilGiorno(date);
            int quarto = 0;
            while (quarto < 96) {
                RilQuarto rilQuarto = HelperTest.createRilQuarto(quarto, codiceFlusso, "", 10.0, giorno * quarto * 2, giorno * quarto * 2, giorno * quarto * 2);
                rilGiorno.add(rilQuarto);
                ++quarto;
            }
            rilMese.add(rilGiorno);
        }
        return rilMese;
    }

    public static RilQuarto createRilQuarto(int index, double attiva, double reattiva, double reattivaCapacitiva, double reattivaInduttiva) {
        return new RilQuarto(index, "PDO", "", attiva, reattiva, reattivaCapacitiva, reattivaInduttiva, 0.0, RilQuartoType.REALE);
    }

    public static RilQuarto createRilQuarto(int index, String codiceFlusso, String id, double attiva, double reattiva, double reattivaCapacitiva, double reattivaInduttiva) {
        return new RilQuarto(index, codiceFlusso, id, attiva, reattiva, reattivaCapacitiva, reattivaInduttiva, 0.0, RilQuartoType.REALE);
    }

    public static RilMese buildRilMeseZero(String codicePod, String codiceFlusso) {
        return HelperTest.builRilMeseZero(codicePod, 2016, Month.JUNE, codiceFlusso);
    }

    public static RilMese builRilMeseZero(String codicePod, int anno, Month mese, String codiceFlusso) {
        RilMese rilMese = new RilMese(codicePod, anno, mese, null);
        DaysOfMonthIterator iterator = new DaysOfMonthIterator(anno, mese);
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        while (iterator.hasNext()) {
            int giorno = iterator.next();
            calendar.setGiorno(giorno);
            Date date = calendar.getDate();
            RilGiorno rilGiorno = new RilGiorno(date);
            int quarto = 0;
            while (quarto < 96) {
                RilQuarto rilQuarto = HelperTest.createRilQuarto(quarto, codiceFlusso, "", 0.0, 0.0, 0.0, 0.0);
                rilGiorno.add(rilQuarto);
                ++quarto;
            }
            rilMese.add(rilGiorno);
        }
        return rilMese;
    }
}

